/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import org.osgl.util.Keyword;

public enum OS {
    WINDOWS,
    MAC_OS{

        @Override
        public String toString() {
            return "macOS";
        }
    }
    ,
    LINUX,
    OS_2{

        @Override
        public String toString() {
            return "OS/2";
        }
    }
    ,
    HP_UX{

        @Override
        public String toString() {
            return "HP-UX";
        }
    }
    ,
    AIX{

        @Override
        public String toString() {
            return "AIX";
        }
    }
    ,
    IRIX{

        @Override
        public String toString() {
            return "IRIX";
        }
    }
    ,
    SOLARIS,
    SUN_OS{

        @Override
        public String toString() {
            return "SunOS";
        }
    }
    ,
    MPE_IX{

        @Override
        public String toString() {
            return "MPE/iX";
        }
    }
    ,
    OS_390{

        @Override
        public String toString() {
            return "OS/390";
        }
    }
    ,
    FREEBSD{

        @Override
        public String toString() {
            return "FreeBSD";
        }
    }
    ,
    DIGITAL_UNIX{

        @Override
        public String toString() {
            return "Digital UNIX";
        }
    }
    ,
    OSF_1{

        @Override
        public String toString() {
            return "OSF/1";
        }
    }
    ,
    UNKNOWN;

    private static OS os;
    private String lineSeparator = System.getProperty("line.separator");
    private String pathSeparator = System.getProperty("path.separator");
    private String fileSeparator = System.getProperty("file.separator");

    public boolean isWindows() {
        return WINDOWS == this;
    }

    public boolean isMacOsX() {
        return MAC_OS == this;
    }

    public boolean isLinux() {
        return LINUX == this;
    }

    public boolean isUnix() {
        return UNKNOWN != this && WINDOWS != this;
    }

    public String lineSeparator() {
        return this.lineSeparator;
    }

    public String pathSeparator() {
        return this.pathSeparator;
    }

    public String fileSeparator() {
        return this.fileSeparator;
    }

    public String toString() {
        return Keyword.of(this.name()).readable();
    }

    public static OS get() {
        return os;
    }

    static {
        os = null;
        String s = Keyword.of(System.getProperty("os.name")).snakeCase().toUpperCase();
        for (OS x : OS.values()) {
            if (!s.startsWith(x.name())) continue;
            os = x;
            break;
        }
        if (null == os) {
            os = UNKNOWN;
        }
    }
}

