/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.WriterOutputStream;

public interface Output
extends Appendable,
Closeable,
Flushable {
    public void open();

    @Override
    public void close();

    @Override
    public void flush();

    @Override
    public Output append(CharSequence var1);

    @Override
    public Output append(CharSequence var1, int var2, int var3);

    @Override
    public Output append(char var1);

    public Output append(byte[] var1);

    public Output append(byte[] var1, int var2, int var3);

    public Output append(byte var1);

    public Output append(ByteBuffer var1);

    public OutputStream asOutputStream();

    public Writer asWriter();

    public static class Adaptors {
        public static Output of(final OutputStream os) {
            if (os instanceof Output) {
                return (Output)((Object)os);
            }
            final OutputStreamWriter w = new OutputStreamWriter(os);
            return new Output(){

                @Override
                public void open() {
                }

                @Override
                public void close() {
                    IO.close(os);
                }

                @Override
                public void flush() {
                    IO.flush(os);
                }

                @Override
                public Output append(CharSequence csq) {
                    IO.append(csq, w);
                    return this;
                }

                @Override
                public Output append(CharSequence csq, int start, int end) {
                    IO.append(csq.subSequence(start, end), w);
                    return this;
                }

                @Override
                public Output append(char c) {
                    IO.append(c, w);
                    return this;
                }

                @Override
                public Output append(byte[] bytes) {
                    IO.append(bytes, os);
                    return this;
                }

                @Override
                public Output append(byte[] bytes, int start, int end) {
                    try {
                        os.write(bytes, start, end);
                    }
                    catch (IOException e) {
                        throw E.ioException(e);
                    }
                    return this;
                }

                @Override
                public Output append(byte b) {
                    IO.append(b, os);
                    return this;
                }

                @Override
                public Output append(ByteBuffer buffer) {
                    int len = buffer.remaining();
                    byte[] bytes = new byte[len];
                    buffer.get(bytes);
                    return this.append(bytes);
                }

                @Override
                public OutputStream asOutputStream() {
                    return os;
                }

                @Override
                public Writer asWriter() {
                    return w;
                }
            };
        }

        public static Output of(final Writer w) {
            final WriterOutputStream os = new WriterOutputStream(w, StandardCharsets.UTF_8);
            return new Output(){

                @Override
                public void open() {
                }

                @Override
                public void close() {
                    IO.close(w);
                }

                @Override
                public void flush() {
                    IO.flush(w);
                }

                @Override
                public Output append(CharSequence csq) {
                    IO.append(csq, w);
                    return this;
                }

                @Override
                public Output append(CharSequence csq, int start, int end) {
                    IO.append(csq.subSequence(start, end), w);
                    return this;
                }

                @Override
                public Output append(char c) {
                    IO.append(c, w);
                    return this;
                }

                @Override
                public Output append(byte[] bytes) {
                    IO.append(bytes, os);
                    return this;
                }

                @Override
                public Output append(byte[] bytes, int start, int end) {
                    try {
                        os.write(bytes, start, end);
                    }
                    catch (IOException e) {
                        throw E.ioException(e);
                    }
                    return this;
                }

                @Override
                public Output append(byte b) {
                    IO.append(b, os);
                    return this;
                }

                @Override
                public Output append(ByteBuffer buffer) {
                    int len = buffer.remaining();
                    byte[] bytes = new byte[len];
                    buffer.get(bytes);
                    return this.append(bytes);
                }

                @Override
                public OutputStream asOutputStream() {
                    return os;
                }

                @Override
                public Writer asWriter() {
                    return w;
                }
            };
        }

        public static Output of(final Appendable appendable) {
            if (appendable instanceof Output) {
                return (Output)appendable;
            }
            return new Output(){

                @Override
                public void open() {
                }

                @Override
                public void close() {
                }

                @Override
                public void flush() {
                }

                @Override
                public Output append(CharSequence csq) {
                    if (null == csq) {
                        return this;
                    }
                    try {
                        appendable.append(csq);
                    }
                    catch (IOException e) {
                        throw E.ioException(e);
                    }
                    return this;
                }

                @Override
                public Output append(CharSequence csq, int start, int end) {
                    if (null == csq) {
                        return this;
                    }
                    try {
                        appendable.append(csq, start, end);
                    }
                    catch (IOException e) {
                        throw E.ioException(e);
                    }
                    return this;
                }

                @Override
                public Output append(char c) {
                    try {
                        appendable.append(c);
                    }
                    catch (IOException e) {
                        throw E.ioException(e);
                    }
                    return this;
                }

                @Override
                public Output append(byte[] bytes) {
                    if (null == bytes) {
                        return this;
                    }
                    this.append(ByteBuffer.wrap(bytes));
                    return this;
                }

                @Override
                public Output append(byte[] bytes, int start, int end) {
                    this.append(ByteBuffer.wrap(bytes, start, end));
                    return this;
                }

                @Override
                public Output append(byte b) {
                    this.append((char)(b & 0xFF));
                    return this;
                }

                @Override
                public Output append(ByteBuffer buffer) {
                    try {
                        appendable.append(buffer.asCharBuffer());
                    }
                    catch (IOException e) {
                        throw E.ioException(e);
                    }
                    return this;
                }

                @Override
                public OutputStream asOutputStream() {
                    return Adaptors.asOutputStream(this);
                }

                @Override
                public Writer asWriter() {
                    return Adaptors.asWriter(this);
                }
            };
        }

        public static OutputStream asOutputStream(final Output output) {
            return new OutputStream(){

                @Override
                public void write(int b) {
                    output.append((byte)b);
                }

                @Override
                public void write(byte[] b) {
                    output.append(b);
                }

                @Override
                public void write(byte[] b, int off, int len) {
                    output.append(b, off, len);
                }

                @Override
                public void flush() {
                    output.flush();
                }

                @Override
                public void close() {
                    output.close();
                }
            };
        }

        public static Writer asWriter(final Output output) {
            return new Writer(){

                @Override
                public void write(char[] c, int off, int len) {
                    if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len == 0) {
                        return;
                    }
                    output.append(CharBuffer.wrap(c, off, len));
                }

                @Override
                public void flush() {
                    output.flush();
                }

                @Override
                public void close() {
                    output.close();
                }
            };
        }
    }
}

