/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.osgl.$;
import org.osgl.util.IO;
import org.osgl.util.Output;

public class OutputStreamOutput
implements Output {
    private OutputStream os;

    public OutputStreamOutput(OutputStream os) {
        this.os = $.requireNotNull(os);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        IO.close(this.os);
    }

    @Override
    public void flush() {
        IO.flush(this.os);
    }

    @Override
    public Output append(CharSequence csq) {
        return this.append(csq.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Output append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public Output append(char c) {
        if (c < '\u0080') {
            return this.append((byte)c);
        }
        String s = String.valueOf(c);
        return this.append(s);
    }

    @Override
    public Output append(byte[] bytes) {
        IO.append(new ByteArrayInputStream(bytes), this.os);
        return this;
    }

    @Override
    public Output append(byte[] bytes, int start, int end) {
        int len = end - start;
        byte[] ba = new byte[len];
        System.arraycopy(bytes, start, ba, 0, len);
        return this.append(ba);
    }

    @Override
    public Output append(byte b) {
        IO.write(b, this.os);
        return this;
    }

    @Override
    public Output append(ByteBuffer buffer) {
        int len = buffer.limit();
        byte[] ba = new byte[len];
        buffer.get(ba);
        return this.append(ba);
    }

    @Override
    public OutputStream asOutputStream() {
        return this.os;
    }

    @Override
    public Writer asWriter() {
        return new OutputStreamWriter(this.os);
    }
}

