/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.lang.reflect.Field;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import org.osgl.$;
import org.osgl.OsglConfig;
import org.osgl.util.AdaptiveMap;
import org.osgl.util.C;
import org.osgl.util.E;

public class ResultSetRecordConverter<T> {
    private static Map<Class, List<Field>> classMetaInfoRepo = new HashMap<Class, List<Field>>();
    private Class<T> targetType;
    private ResultSet rs;
    private ResultSetMetaData rsMeta;
    private Map<String, String> specialMaps;
    private Map<String, String> reverseSpecialMaps;
    private static Map<ResultSetMetaData, Map<String, Integer>> resultSetMetaDataColumnNameLookup = new HashMap<ResultSetMetaData, Map<String, Integer>>();

    public ResultSetRecordConverter(ResultSet rs, Class<T> targetType, Map<String, String> specialMaps) {
        this.targetType = $.requireNotNull(targetType);
        this.specialMaps = specialMaps;
        if (null != specialMaps) {
            this.reverseSpecialMaps = C.Map(specialMaps).flipped();
        }
        try {
            this.rsMeta = rs.getMetaData();
        }
        catch (SQLException e) {
            throw E.sqlException(e);
        }
        this.rs = rs;
    }

    private Map<String, Integer> columnNameLookup() throws SQLException {
        Map<String, Integer> lookup = resultSetMetaDataColumnNameLookup.get(this.rsMeta);
        if (null == lookup) {
            lookup = new HashMap<String, Integer>();
            int n = this.rsMeta.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                lookup.put(this.rsMeta.getColumnLabel(i), i);
            }
            resultSetMetaDataColumnNameLookup.put(this.rsMeta, lookup);
        }
        return lookup;
    }

    public T doConvert() {
        try {
            Object entity = OsglConfig.globalInstanceFactory().apply(this.targetType);
            if (Map.class.isAssignableFrom(this.targetType)) {
                return (T)this.convertToMap((Map)entity);
            }
            if (AdaptiveMap.class.isAssignableFrom(this.targetType)) {
                return (T)this.convertToAdaptiveMap((AdaptiveMap)entity);
            }
            return (T)this.convertToEntity(entity);
        }
        catch (SQLException e) {
            throw E.sqlException(e);
        }
    }

    private Map convertToMap(Map map) throws SQLException {
        int n = this.rsMeta.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String newLabel;
            String label = this.rsMeta.getColumnLabel(i);
            if (null != this.specialMaps && null != (newLabel = this.specialMaps.get(label))) {
                label = newLabel;
            }
            map.put(label, this.getFieldValue(i));
        }
        return map;
    }

    private AdaptiveMap convertToAdaptiveMap(AdaptiveMap map) throws SQLException {
        int n = this.rsMeta.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String newLabel;
            String label = this.rsMeta.getColumnLabel(i);
            if (null != this.specialMaps && null != (newLabel = this.specialMaps.get(label))) {
                label = newLabel;
            }
            map.putValue(label, this.getFieldValue(i));
        }
        return map;
    }

    private Object convertToEntity(Object entity) throws SQLException {
        List<Field> fields = classMetaInfoRepo.get(this.targetType);
        if (null == fields) {
            fields = $.fieldsOf(this.targetType);
            classMetaInfoRepo.put(this.targetType, fields);
        }
        Map<String, Integer> columnNameLookup = this.columnNameLookup();
        for (Field f2 : fields) {
            Integer n;
            String newLabel;
            String label;
            Column column = f2.getAnnotation(Column.class);
            String string = label = null != column ? column.name() : f2.getName();
            if (null != this.reverseSpecialMaps && null != (newLabel = this.reverseSpecialMaps.get(label))) {
                label = newLabel;
            }
            if (null == (n = columnNameLookup.get(label))) continue;
            Class<?> fieldType = f2.getType();
            Object o = this.getFieldValue(n);
            $.setFieldValue(entity, f2, $.convert(o).to(fieldType));
        }
        return entity;
    }

    private Object getFieldValue(int colId) throws SQLException {
        Object o = null;
        switch (this.rsMeta.getColumnType(colId)) {
            case 2003: {
                Array array = this.rs.getArray(colId);
                return null == array ? null : array.getArray();
            }
            case -5: {
                o = this.rs.getLong(colId);
                break;
            }
            case -2: {
                o = this.rs.getBytes(colId);
                break;
            }
            case -7: {
                o = this.rs.getBoolean(colId);
                break;
            }
            case 2004: {
                o = this.rs.getBlob(colId);
                break;
            }
            case 16: {
                o = this.rs.getBoolean(colId);
                break;
            }
            case 1: {
                o = this.rs.getString(colId);
                break;
            }
            case 2005: {
                o = this.rs.getClob(colId);
                break;
            }
            case 70: {
                o = this.rs.getURL(colId);
                break;
            }
            case 91: {
                o = this.rs.getDate(colId);
                break;
            }
            case 3: {
                o = this.rs.getBigDecimal(colId);
                break;
            }
            case 8: {
                o = this.rs.getDouble(colId);
                break;
            }
            case 6: {
                o = Float.valueOf(this.rs.getFloat(colId));
                break;
            }
            case 4: {
                o = this.rs.getInt(colId);
                break;
            }
            case 2000: {
                o = this.rs.getObject(colId);
                break;
            }
            case -16: 
            case -1: {
                o = this.rs.getString(colId);
                break;
            }
            case -4: {
                o = this.rs.getBytes(colId);
                break;
            }
            case -15: {
                o = this.rs.getString(colId);
                break;
            }
            case 2011: {
                o = this.rs.getNClob(colId);
                break;
            }
            case 0: {
                o = null;
                break;
            }
            case 2: {
                o = this.rs.getBigDecimal(colId);
                break;
            }
            case -9: {
                o = this.rs.getString(colId);
                break;
            }
            case 7: {
                o = Float.valueOf(this.rs.getFloat(colId));
                break;
            }
            case 5: {
                o = this.rs.getInt(colId);
                break;
            }
            case 2009: {
                o = this.rs.getSQLXML(colId);
                break;
            }
            case 92: {
                o = this.rs.getTime(colId);
                break;
            }
            case -6: {
                o = this.rs.getInt(colId);
                break;
            }
            case -3: {
                o = this.rs.getBytes(colId);
                break;
            }
            case 12: {
                o = this.rs.getString(colId);
                break;
            }
            default: {
                o = null;
            }
        }
        if (this.rs.wasNull()) {
            o = null;
        }
        return o;
    }
}

