/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.NoSuchElementException;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.CollectorRSeq;
import org.osgl.util.CompositeRSeq;
import org.osgl.util.FilteredIterator;
import org.osgl.util.FilteredRSeq;
import org.osgl.util.FlatMappedRSeq;
import org.osgl.util.IndexFilteredRSeq;
import org.osgl.util.MappedRSeq;
import org.osgl.util.Nil;
import org.osgl.util.ReversedRSeq;
import org.osgl.util.SequenceBase;
import org.osgl.util.ZippedRSeq;

abstract class ReversibleSeqBase<T>
extends SequenceBase<T>
implements C.ReversibleSequence<T> {
    ReversibleSeqBase() {
    }

    @Override
    public C.ReversibleSequence<T> lazy() {
        super.lazy();
        return this;
    }

    @Override
    public C.ReversibleSequence<T> eager() {
        super.eager();
        return this;
    }

    @Override
    public C.ReversibleSequence<T> parallel() {
        super.parallel();
        return this;
    }

    @Override
    public C.ReversibleSequence<T> sequential() {
        super.sequential();
        return this;
    }

    @Override
    public ReversibleSeqBase<T> accept(Lang.Visitor<? super T> visitor) {
        super.accept((Lang.Visitor)visitor);
        return this;
    }

    @Override
    public ReversibleSeqBase<T> each(Lang.Visitor<? super T> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    @Override
    public ReversibleSeqBase<T> forEach(Lang.Visitor<? super T> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    @Override
    public C.ReversibleSequence<T> acceptLeft(Lang.Visitor<? super T> visitor) {
        super.acceptLeft(visitor);
        return this;
    }

    @Override
    public C.ReversibleSequence<T> head(int n) {
        if (n == 0) {
            return Nil.rseq();
        }
        if (n < 0) {
            if (this.isLimited()) {
                return this.drop(this.size() + n);
            }
            throw new UnsupportedOperationException();
        }
        if (this.isLimited() && n >= this.size()) {
            return this;
        }
        return IndexFilteredRSeq.of(this, Lang.F.lessThan(n));
    }

    @Override
    public C.ReversibleSequence<T> tail() throws UnsupportedOperationException {
        return IndexFilteredRSeq.of(this, Lang.F.greaterThan(0));
    }

    @Override
    public C.ReversibleSequence<T> take(int n) {
        return this.head(n);
    }

    @Override
    public C.ReversibleSequence<T> takeWhile(Lang.Function<? super T, Boolean> predicate) {
        return FilteredRSeq.of(this, predicate, FilteredIterator.Type.WHILE);
    }

    @Override
    public C.ReversibleSequence<T> drop(int n) throws IllegalArgumentException {
        int sz = this.size();
        if (n < 0) {
            if ((n = -n) >= sz) {
                return Nil.rseq();
            }
            return this.take(sz - n);
        }
        if (n == 0) {
            return this;
        }
        return IndexFilteredRSeq.of(this, Lang.F.gte(n));
    }

    @Override
    public C.ReversibleSequence<T> dropWhile(Lang.Function<? super T, Boolean> predicate) {
        return FilteredRSeq.of(this, Lang.F.negate(predicate), FilteredIterator.Type.UNTIL);
    }

    @Override
    public C.ReversibleSequence<T> append(T t) {
        return CompositeRSeq.of(this, $.val(t));
    }

    @Override
    public C.ReversibleSequence<T> prepend(T t) {
        return CompositeRSeq.of($.val(t), this);
    }

    @Override
    public C.ReversibleSequence<T> filter(Lang.Function<? super T, Boolean> predicate) {
        return FilteredRSeq.of(this, predicate);
    }

    @Override
    public <R> C.ReversibleSequence<R> map(Lang.Function<? super T, ? extends R> mapper) {
        return MappedRSeq.of(this, mapper);
    }

    @Override
    public <R> C.ReversibleSequence<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return FlatMappedRSeq.of(this, mapper);
    }

    @Override
    public <R> C.Sequence<R> collect(String path) {
        return CollectorRSeq.of(this, path);
    }

    @Override
    public C.ReversibleSequence<T> append(C.ReversibleSequence<T> seq) {
        if (seq.isEmpty()) {
            return this;
        }
        return CompositeRSeq.of(this, seq);
    }

    @Override
    public C.ReversibleSequence<T> prepend(C.ReversibleSequence<T> seq) {
        if (seq.isEmpty()) {
            return this;
        }
        return CompositeRSeq.of(seq, this);
    }

    @Override
    public T last() throws UnsupportedOperationException, NoSuchElementException {
        return this.reverseIterator().next();
    }

    @Override
    public C.ReversibleSequence<T> tail(int n) throws UnsupportedOperationException, IndexOutOfBoundsException {
        int sz = this.size();
        if (n < 0) {
            return this.head(-n);
        }
        if (n == 0) {
            return Nil.rseq();
        }
        if (n >= sz) {
            return this;
        }
        return this.reverse().take(n).reverse();
    }

    @Override
    public C.ReversibleSequence<T> reverse() throws UnsupportedOperationException {
        if (this.isEmpty()) {
            return Nil.rseq();
        }
        return ReversedRSeq.of(this);
    }

    @Override
    public <R> R reduceRight(R identity, Lang.Func2<R, T, R> accumulator) {
        return this.reverse().reduceLeft(identity, accumulator);
    }

    @Override
    public Lang.Option<T> reduceRight(Lang.Func2<T, T, T> accumulator) {
        return this.reverse().reduceLeft(accumulator);
    }

    @Override
    public Lang.Option<T> findLast(Lang.Function<? super T, Boolean> predicate) {
        return this.reverse().findFirst(predicate);
    }

    @Override
    public C.ReversibleSequence<T> acceptRight(Lang.Visitor<? super T> visitor) {
        return this.reverse().acceptLeft((Lang.Visitor)visitor);
    }

    @Override
    public <T2> C.ReversibleSequence<Lang.Binary<T, T2>> zip(C.ReversibleSequence<T2> rseq) {
        return new ZippedRSeq(this, rseq);
    }

    @Override
    public <T2> C.ReversibleSequence<Lang.Binary<T, T2>> zipAll(C.ReversibleSequence<T2> rseq, T def1, T2 def2) {
        return new ZippedRSeq<T, T2>(this, rseq, def1, def2);
    }
}

