/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.CollectorSeq;
import org.osgl.util.CompositeSeq;
import org.osgl.util.FilteredIterator;
import org.osgl.util.FilteredSeq;
import org.osgl.util.FlatMappedSeq;
import org.osgl.util.IndexFilteredSeq;
import org.osgl.util.IndexIterable;
import org.osgl.util.MappedSeq;
import org.osgl.util.Nil;
import org.osgl.util.TraversableBase;
import org.osgl.util.ZippedSeq;

public abstract class SequenceBase<T>
extends TraversableBase<T>
implements C.Sequence<T> {
    protected final boolean isLazy() {
        return this.is(C.Feature.LAZY);
    }

    protected final boolean isImmutable() {
        return this.is(C.Feature.IMMUTABLE);
    }

    protected final boolean isReadOnly() {
        return this.is(C.Feature.READONLY);
    }

    protected final boolean isMutable() {
        return !this.isImmutable() && !this.isReadOnly();
    }

    protected final boolean isLimited() {
        return this.is(C.Feature.LIMITED);
    }

    @Override
    public C.Sequence<T> lazy() {
        return (C.Sequence)super.lazy();
    }

    @Override
    public C.Sequence<T> eager() {
        return (C.Sequence)super.eager();
    }

    @Override
    public C.Sequence<T> parallel() {
        return (C.Sequence)super.parallel();
    }

    @Override
    public C.Sequence<T> sequential() {
        return (C.Sequence)super.sequential();
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return EnumSet.of(C.Feature.LAZY, C.Feature.READONLY);
    }

    @Override
    public C.List<T> asList() {
        return C.list(this);
    }

    @Override
    public SequenceBase<T> accept(Lang.Visitor<? super T> visitor) {
        C.forEach(this, visitor);
        return this;
    }

    @Override
    public SequenceBase<T> forEach(Lang.Visitor<? super T> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    @Override
    public C.Sequence<T> each(Lang.Visitor<? super T> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    protected void forEachLeft(Lang.Visitor<? super T> visitor) {
        this.forEach((Lang.Visitor)visitor);
    }

    @Override
    public T first() throws NoSuchElementException {
        return this.iterator().next();
    }

    @Override
    public final T head() throws NoSuchElementException {
        return this.first();
    }

    @Override
    public C.Sequence<T> acceptLeft(Lang.Visitor<? super T> visitor) {
        this.forEachLeft(visitor);
        return this;
    }

    @Override
    public <R> R reduceLeft(R identity, Lang.Func2<R, T, R> accumulator) {
        return this.reduce(identity, accumulator);
    }

    @Override
    public Lang.Option<T> reduceLeft(Lang.Func2<T, T, T> accumulator) {
        return this.reduce(accumulator);
    }

    @Override
    public Lang.Option<T> findFirst(Lang.Function<? super T, Boolean> predicate) {
        return this.findOne(predicate);
    }

    @Override
    public C.Sequence<T> head(int n) {
        if (n == 0) {
            return Nil.seq();
        }
        if (n < 0) {
            if (this.isLimited()) {
                return this.drop(this.size() + n);
            }
            throw new UnsupportedOperationException();
        }
        if (this.isLimited() && n >= this.size()) {
            return this;
        }
        return IndexFilteredSeq.of(this, Lang.F.lessThan(n));
    }

    @Override
    public C.Sequence<T> tail() throws UnsupportedOperationException {
        return IndexFilteredSeq.of(this, Lang.F.greaterThan(0));
    }

    @Override
    public C.Sequence<T> take(int n) {
        return this.head(n);
    }

    @Override
    public C.Sequence<T> takeWhile(Lang.Function<? super T, Boolean> predicate) {
        return FilteredSeq.of(this, predicate, FilteredIterator.Type.WHILE);
    }

    @Override
    public C.Sequence<T> drop(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            return this;
        }
        return IndexFilteredSeq.of(this, Lang.F.gte(n));
    }

    @Override
    public C.Sequence<T> dropWhile(Lang.Function<? super T, Boolean> predicate) {
        return FilteredSeq.of(this, Lang.F.negate(predicate), FilteredIterator.Type.UNTIL);
    }

    @Override
    public C.Sequence<T> append(Iterable<? extends T> iterable) {
        return this.append((T)C.seq(iterable));
    }

    @Override
    public C.Sequence<T> append(C.Sequence<? extends T> seq) {
        if (seq.isEmpty()) {
            return this;
        }
        return CompositeSeq.of(this, seq);
    }

    @Override
    public C.Sequence<T> append(Iterator<? extends T> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        return CompositeSeq.of(this, C.seq(iterator));
    }

    @Override
    public C.Sequence<T> append(Enumeration<? extends T> enumeration) {
        if (!enumeration.hasMoreElements()) {
            return this;
        }
        return CompositeSeq.of(this, C.seq(enumeration));
    }

    @Override
    public C.Sequence<T> append(T t) {
        return CompositeSeq.of(this, $.val(t));
    }

    @Override
    public C.Sequence<T> prepend(Iterable<? extends T> iterable) {
        if (!iterable.iterator().hasNext()) {
            return this;
        }
        return this.prepend((T)C.seq(iterable));
    }

    @Override
    public C.Sequence<T> prepend(Iterator<? extends T> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        return this.prepend((T)C.seq(iterator));
    }

    @Override
    public C.Sequence<T> prepend(Enumeration<? extends T> enumeration) {
        if (!enumeration.hasMoreElements()) {
            return this;
        }
        return this.prepend((T)C.seq(enumeration));
    }

    @Override
    public C.Sequence<T> prepend(C.Sequence<? extends T> seq) {
        if (seq.isEmpty()) {
            return this;
        }
        C.Sequence casted = (C.Sequence)$.cast(seq);
        return casted.append(this);
    }

    @Override
    public C.Sequence<T> prepend(T t) {
        return CompositeSeq.of(C.singletonList(t), this);
    }

    @Override
    public C.Sequence<T> filter(Lang.Function<? super T, Boolean> predicate) {
        return FilteredSeq.of(this, predicate);
    }

    @Override
    public <R> C.Sequence<R> map(Lang.Function<? super T, ? extends R> mapper) {
        return MappedSeq.of(this, mapper);
    }

    @Override
    public <R> C.Sequence<R> flatMap(Lang.Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return FlatMappedSeq.of(this, mapper);
    }

    @Override
    public <R> C.Sequence<R> collect(String path) {
        return CollectorSeq.of(this, path);
    }

    @Override
    public <T2> C.Sequence<Lang.Binary<T, T2>> zip(Iterable<T2> iterable) {
        return new ZippedSeq(this, iterable);
    }

    @Override
    public <T2> C.Sequence<Lang.Binary<T, T2>> zipAll(Iterable<T2> iterable, T def1, T2 def2) {
        return new ZippedSeq<T, T2>(this, iterable, def1, def2);
    }

    @Override
    public C.Sequence<Lang.Binary<T, Integer>> zipWithIndex() {
        return new ZippedSeq(this, new IndexIterable(this));
    }

    @Override
    public int count(T t) {
        return SequenceBase.count(this, t);
    }

    public static <T> int count(C.Sequence<T> sequence, T element) {
        int n = 0;
        for (Object t : sequence) {
            if (!$.eq(t, element)) continue;
            ++n;
        }
        return n;
    }
}

