/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.Iterators;
import org.osgl.util.S;

public class StringTokenSet
implements Set<String> {
    private String data;
    private boolean sorted;
    private int size;
    private String[] array;
    public static final String SEPARATOR = ",";
    public static final char SEPARATOR_CHAR = ',';

    public StringTokenSet() {
    }

    public StringTokenSet(String data) {
        StringTokenSet set = StringTokenSet.of(data);
        $.copy(set).to(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (null == this.data || !String.class.isInstance(o)) {
            return false;
        }
        int loc = this.locate((String)o);
        return loc > -1;
    }

    @Override
    public Iterator<String> iterator() {
        if (null == this.data) {
            return Iterators.nil();
        }
        S.List list = S.fastSplit(this.data, SEPARATOR);
        return list.iterator();
    }

    @Override
    public Object[] toArray() {
        this.ensureArray();
        return $.cloneOf(this.array);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return (Object[])$.cast(this.toArray());
        }
        this.ensureArray();
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public boolean add(String s) {
        if (this.contains(s)) {
            return false;
        }
        this.data = null == this.data ? s : this.data + SEPARATOR + s;
        ++this.size;
        this.array = null;
        this.sorted = false;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (null == this.data || !String.class.isInstance(o)) {
            return false;
        }
        String s = (String)o;
        int loc = this.locate(s);
        if (loc < 0) {
            return false;
        }
        if (1 == this.size) {
            this.size = 0;
            this.data = null;
        } else {
            int sz = s.length();
            if (loc + sz >= this.data.length()) {
                this.data = this.data.substring(0, loc - 1);
            } else if (loc == 0) {
                this.data = this.data.substring(sz + 1);
            } else {
                String prefix = this.data.substring(0, loc - 1);
                String suffix = this.data.substring(loc + sz);
                this.data = prefix + suffix;
            }
            --this.size;
        }
        this.array = null;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean changed = false;
        C.Set<? extends String> set = C.Set(c);
        for (String string : set) {
            boolean b = this.add(string);
            changed = changed || b;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<String> toBeRemoved = new HashSet<String>();
        for (String s : this) {
            if (c.contains(s)) continue;
            toBeRemoved.add(s);
        }
        for (String s : toBeRemoved) {
            this.remove(s);
        }
        return !toBeRemoved.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            boolean b = this.remove(o);
            changed = changed || b;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.data = null;
        this.array = null;
        this.size = 0;
    }

    @Override
    public int hashCode() {
        this.sort();
        return $.hc(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringTokenSet) {
            StringTokenSet that = (StringTokenSet)$.cast(obj);
            if ($.eq(that.data, this.data)) {
                return true;
            }
            this.sort();
            that.sort();
            return $.eq(this.data, that.data);
        }
        if (obj instanceof Set) {
            Set set = (Set)obj;
            return set.equals(this);
        }
        return false;
    }

    public String toString() {
        return this.data;
    }

    public StringTokenSet sort() {
        if (!this.sorted) {
            this.ensureArray();
            Arrays.sort(this.array);
            this.data = S.join(C.listOf(this.array)).by(SEPARATOR).get();
            this.sorted = true;
        }
        return this;
    }

    private int locate(String s) {
        int sz = s.length();
        int loc = this.data.indexOf(s);
        while (loc != -1) {
            boolean endInTheMiddle;
            boolean beginInTheMiddle;
            boolean bl = beginInTheMiddle = loc > 0 && this.data.charAt(loc - 1) != ',';
            if (beginInTheMiddle) {
                loc = this.data.indexOf(s, loc + 1);
                continue;
            }
            int end = loc + sz;
            boolean bl2 = endInTheMiddle = this.size > end && this.data.charAt(end + 1) != ',';
            if (endInTheMiddle) {
                loc = this.data.indexOf(s, loc + 1);
                continue;
            }
            return loc;
        }
        return -1;
    }

    private void ensureArray() {
        if (null != this.array) {
            return;
        }
        if (0 == this.size) {
            this.array = S.EMPTY_ARRAY;
            return;
        }
        this.array = new String[this.size];
        int cur = 0;
        int i = 0;
        int loc = this.data.indexOf(44, cur);
        while (loc != -1) {
            this.array[i++] = this.data.substring(cur, loc);
            cur = loc + 1;
            loc = this.data.indexOf(44, cur);
        }
        this.array[i] = this.data.substring(cur, this.data.length());
    }

    public static StringTokenSet of(String data) {
        StringTokenSet set = new StringTokenSet();
        if (null != data) {
            set.addAll(S.fastSplit(data, SEPARATOR));
        }
        return set;
    }

    public static String merge(String a, String b) {
        if (null == a) {
            if (null == b) {
                return null;
            }
            return StringTokenSet.of(b).toString();
        }
        if (null == b) {
            return StringTokenSet.of(a).toString();
        }
        String s = S.concat(a, SEPARATOR, b);
        return StringTokenSet.of(s).toString();
    }

    public static String merge(String a, String ... others) {
        return StringTokenSet.of(S.concat((Object)a, S.join(others).by(SEPARATOR))).toString();
    }

    public static String merge(String[] sa) {
        return StringTokenSet.of(S.join(sa).by(SEPARATOR).get()).toString();
    }

    public static String merge(Collection<String> sa) {
        return StringTokenSet.of(S.join(sa).by(SEPARATOR).get()).toString();
    }
}

