/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.AnnotationAware;
import org.osgl.util.BigDecimalValueObjectCodec;
import org.osgl.util.BigIntegerValueObjectCodec;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.Generics;
import org.osgl.util.Keyword;
import org.osgl.util.KeywordValueObjectCodec;
import org.osgl.util.S;
import org.osgl.util.Str;

public abstract class StringValueResolver<T>
extends Lang.F1<String, T> {
    private final Type targetType;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    private static final StringValueResolver<Boolean> _boolean = new StringValueResolver<Boolean>(){

        @Override
        public Boolean resolve(String value) {
            if (S.empty(value)) {
                return Boolean.FALSE;
            }
            return Boolean.parseBoolean(value);
        }
    };
    private static final StringValueResolver<Boolean> _Boolean = new StringValueResolver<Boolean>(){

        @Override
        public Boolean resolve(String value) {
            if (S.empty(value)) {
                return null;
            }
            return Boolean.parseBoolean(value);
        }
    };
    private static final Map<String, Character> PREDEFINED_CHARS = new HashMap<String, Character>();
    private static final StringValueResolver<Character> _char;
    private static final StringValueResolver<Character> _Char;
    private static final StringValueResolver<char[]> _charArray;
    private static final StringValueResolver<Byte> _byte;
    private static final StringValueResolver<Byte> _Byte;
    private static final StringValueResolver<Short> _short;
    private static final StringValueResolver<Short> _Short;
    private static final StringValueResolver<Number> _Number;
    private static final StringValueResolver<Integer> _int;
    private static final StringValueResolver<Integer> _Integer;
    private static final StringValueResolver<Long> _long;
    private static final StringValueResolver<Long> _Long;
    private static final StringValueResolver<Float> _float;
    private static final StringValueResolver<Float> _Float;
    private static final StringValueResolver<Double> _double;
    private static final StringValueResolver<Double> _Double;
    private static final StringValueResolver<String> _String;
    private static final StringValueResolver<Str> _Str;
    private static final StringValueResolver<FastStr> _FastStr;
    private static final StringValueResolver<Locale> _Locale;
    private static Map<Class, StringValueResolver> predefined;

    public StringValueResolver() {
        this.targetType = this.findTargetType();
    }

    protected StringValueResolver(Class<T> targetType) {
        this.targetType = $.requireNotNull(targetType);
    }

    public abstract T resolve(String var1);

    public Class<T> targetType() {
        return Generics.classOf(this.targetType);
    }

    public Type genericTargetType() {
        return this.targetType;
    }

    private Type findTargetType() {
        return StringValueResolver.findTargetType(this.getClass());
    }

    private static Type findTargetType(Class<?> clazz) {
        List<Type> typeParams = Generics.typeParamImplementations(clazz, StringValueResolver.class);
        if (typeParams.size() > 0) {
            return typeParams.get(0);
        }
        throw E.unsupport("Cannot identify the target type from %s", clazz);
    }

    @Override
    public final T apply(String s) throws NotAppliedException, Lang.Break {
        return this.resolve(s);
    }

    public StringValueResolver<T> attribute(String key, Object value) {
        if (null == value) {
            this.attributes.remove(value);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    public StringValueResolver<T> attributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public StringValueResolver<T> clearAttributes() {
        this.attributes.clear();
        return this;
    }

    protected <V> V attribute(String key) {
        return (V)this.attributes.get(key);
    }

    public StringValueResolver<T> amended(AnnotationAware beanSpec) {
        return this;
    }

    public static <T> StringValueResolver<T> wrap(final Lang.Function<String, T> func, Class<T> targetType) {
        if (func instanceof StringValueResolver) {
            return (StringValueResolver)func;
        }
        return new StringValueResolver<T>(targetType){

            @Override
            public T resolve(String value) {
                return func.apply(value);
            }
        };
    }

    private static Character resolveChar(String value, Character defVal) {
        if (null == value) {
            return defVal;
        }
        switch (value.length()) {
            case 0: {
                return defVal;
            }
            case 1: {
                return Character.valueOf(value.charAt(0));
            }
        }
        if (value.startsWith("\\")) {
            Character c;
            if (value.length() == 2 && null != (c = PREDEFINED_CHARS.get(value))) {
                return c;
            }
            try {
                int i;
                String s = value.substring(1);
                if (s.startsWith("u")) {
                    int i2 = Integer.parseInt(s.substring(1), 16);
                    if (i2 > 65535 || i2 < 0) {
                        throw new IllegalArgumentException("Invalid character: " + value);
                    }
                    return Character.valueOf((char)i2);
                }
                if (s.length() > 3) {
                    throw new IllegalArgumentException("Invalid character: " + value);
                }
                if (s.length() == 3 && (i = Integer.parseInt(s.substring(0, 1))) > 3) {
                    throw new IllegalArgumentException("Invalid character: " + value);
                }
                i = Integer.parseInt(s, 8);
                return Character.valueOf((char)i);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid character: " + value);
            }
        }
        throw new IllegalArgumentException("Invalid character: " + value);
    }

    private static int _int(String s) {
        if ((s = s.trim()).contains(".")) {
            float f2 = Float.valueOf(s).floatValue();
            return Math.round(f2);
        }
        if (s.contains("*")) {
            S.List factors = S.fastSplit(s, "*");
            int n = 1;
            for (String factor : factors) {
                n *= StringValueResolver._int(factor);
            }
            return n;
        }
        return Integer.valueOf(s);
    }

    private static long _long(String s) {
        if ((s = s.trim()).contains(".")) {
            double d = Double.valueOf(s);
            return Math.round(d);
        }
        if (s.contains("*")) {
            S.List factors = S.fastSplit(s, "*");
            long n = 1L;
            for (String factor : factors) {
                n *= StringValueResolver._long(factor);
            }
            return n;
        }
        return Long.valueOf(s);
    }

    private static float _float(String s) {
        if ((s = s.trim()).contains("*")) {
            S.List factors = S.fastSplit(s, "*");
            float n = 1.0f;
            for (String factor : factors) {
                n *= StringValueResolver._float(factor);
            }
            return n;
        }
        return Float.valueOf(s).floatValue();
    }

    private static double _double(String s) {
        if ((s = s.trim()).contains("*")) {
            S.List factors = S.fastSplit(s, "*");
            double n = 1.0;
            for (String factor : factors) {
                n *= StringValueResolver._double(factor);
            }
            return n;
        }
        return Double.valueOf(s);
    }

    public static <T> void addPredefinedResolver(Class<T> type, StringValueResolver<T> resolver) {
        predefined.put(type, resolver);
    }

    public static Map<Class, StringValueResolver> predefined() {
        return C.Map(predefined);
    }

    public static <T> StringValueResolver<T> predefined(Class<T> type) {
        return predefined.get(type);
    }

    public static void main(String[] args) {
        System.out.println(_float.targetType());
        System.out.println(_String.targetType());
    }

    static {
        PREDEFINED_CHARS.put("\\b", Character.valueOf('\b'));
        PREDEFINED_CHARS.put("\\f", Character.valueOf('\f'));
        PREDEFINED_CHARS.put("\\n", Character.valueOf('\n'));
        PREDEFINED_CHARS.put("\\r", Character.valueOf('\r'));
        PREDEFINED_CHARS.put("\\t", Character.valueOf('\t'));
        PREDEFINED_CHARS.put("\\", Character.valueOf('\"'));
        PREDEFINED_CHARS.put("\\'", Character.valueOf('\''));
        PREDEFINED_CHARS.put("\\\\", Character.valueOf('\\'));
        _char = new StringValueResolver<Character>(){

            @Override
            public Character resolve(String value) {
                return StringValueResolver.resolveChar(value, Character.valueOf('\u0000'));
            }
        };
        _Char = new StringValueResolver<Character>(){

            @Override
            public Character resolve(String value) {
                return StringValueResolver.resolveChar(value, null);
            }
        };
        _charArray = new StringValueResolver<char[]>(){

            @Override
            public char[] resolve(String value) {
                return null == value ? new char[]{} : value.toCharArray();
            }
        };
        _byte = new StringValueResolver<Byte>(){

            @Override
            public Byte resolve(String value) {
                if (S.blank(value)) {
                    return (byte)0;
                }
                return Byte.parseByte(value);
            }
        };
        _Byte = new StringValueResolver<Byte>(){

            @Override
            public Byte resolve(String value) {
                if (S.blank(value)) {
                    return null;
                }
                return Byte.parseByte(value);
            }
        };
        _short = new StringValueResolver<Short>(){

            @Override
            public Short resolve(String value) {
                if (S.blank(value)) {
                    return (short)0;
                }
                return Short.valueOf(value);
            }
        };
        _Short = new StringValueResolver<Short>(){

            @Override
            public Short resolve(String value) {
                if (S.blank(value)) {
                    return null;
                }
                return Short.valueOf(value);
            }
        };
        _Number = new StringValueResolver<Number>(){

            @Override
            public Number resolve(String value) {
                if (S.blank(value)) {
                    return null;
                }
                if (S.isIntOrLong(value)) {
                    long l = Long.parseLong(value);
                    if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                        return (int)l;
                    }
                    return l;
                }
                return Double.parseDouble(value);
            }
        };
        _int = new StringValueResolver<Integer>(){

            @Override
            public Integer resolve(String value) {
                if (S.blank(value)) {
                    return 0;
                }
                return StringValueResolver._int(value);
            }
        };
        _Integer = new StringValueResolver<Integer>(){

            @Override
            public Integer resolve(String value) {
                if (S.blank(value)) {
                    return null;
                }
                return StringValueResolver._int(value);
            }
        };
        _long = new StringValueResolver<Long>(){

            @Override
            public Long resolve(String value) {
                if (S.blank(value)) {
                    return 0L;
                }
                return StringValueResolver._long(value);
            }
        };
        _Long = new StringValueResolver<Long>(){

            @Override
            public Long resolve(String value) {
                if (S.blank(value)) {
                    return null;
                }
                return StringValueResolver._long(value);
            }
        };
        _float = new StringValueResolver<Float>(){

            @Override
            public Float resolve(String value) {
                if (S.blank(value)) {
                    return Float.valueOf(0.0f);
                }
                float n = StringValueResolver._float(value);
                if (Float.isInfinite(n) || Float.isNaN(n)) {
                    throw new IllegalArgumentException("float value out of scope: " + value);
                }
                return Float.valueOf(n);
            }
        };
        _Float = new StringValueResolver<Float>(){

            @Override
            public Float resolve(String value) {
                if (S.blank(value)) {
                    return null;
                }
                float n = StringValueResolver._float(value);
                if (Float.isInfinite(n) || Float.isNaN(n)) {
                    throw new IllegalArgumentException("float value out of scope: " + value);
                }
                return Float.valueOf(n);
            }
        };
        _double = new StringValueResolver<Double>(){

            @Override
            public Double resolve(String value) {
                if (S.blank(value)) {
                    return 0.0;
                }
                double n = StringValueResolver._double(value);
                if (Double.isInfinite(n) || Double.isNaN(n)) {
                    throw new IllegalArgumentException("double value out of scope: " + value);
                }
                return n;
            }
        };
        _Double = new StringValueResolver<Double>(){

            @Override
            public Double resolve(String value) {
                if (S.blank(value)) {
                    return null;
                }
                double n = StringValueResolver._double(value);
                if (Double.isInfinite(n) || Double.isNaN(n)) {
                    throw new IllegalArgumentException("double value out of scope: " + value);
                }
                return n;
            }
        };
        _String = StringValueResolver.wrap(Lang.F.identity(), String.class);
        _Str = new StringValueResolver<Str>(){

            @Override
            public Str resolve(String value) {
                if (null == value) {
                    return null;
                }
                return S.str(value);
            }
        };
        _FastStr = new StringValueResolver<FastStr>(){

            @Override
            public FastStr resolve(String value) {
                if (null == value) {
                    return null;
                }
                return FastStr.of(value);
            }
        };
        _Locale = new StringValueResolver<Locale>(){

            @Override
            public Locale resolve(String value) {
                return Locale.forLanguageTag(value);
            }
        };
        predefined = C.newMap(Boolean.TYPE, _boolean, Boolean.class, _Boolean, Character.TYPE, _char, Character.class, _Char, Byte.TYPE, _byte, Byte.class, _Byte, Short.TYPE, _short, Short.class, _Short, Number.class, _Number, Integer.TYPE, _int, Integer.class, _Integer, Long.TYPE, _long, Long.class, _Long, Float.TYPE, _float, Float.class, _Float, Double.TYPE, _double, Double.class, _Double, String.class, _String, Locale.class, _Locale, Str.class, _Str, FastStr.class, _FastStr, char[].class, _charArray, BigInteger.class, new BigIntegerValueObjectCodec(), BigDecimal.class, new BigDecimalValueObjectCodec(), Keyword.class, new KeywordValueObjectCodec());
    }
}

