/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.osgl.util.C;
import org.osgl.util.ListBase;
import org.osgl.util.RandomAccessSubList;

class SubList<E>
extends ListBase<E>
implements C.List<E> {
    private ListBase<E> l;
    private int offset;
    private int size;
    private int expectedModCount;

    SubList(ListBase<E> list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.l = list;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
        this.expectedModCount = this.l.modCount();
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return this.l.features();
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        this.checkForComodification();
        return this.l.set(index + this.offset, element);
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        this.checkForComodification();
        return this.l.get(index + this.offset);
    }

    @Override
    public int size() {
        this.checkForComodification();
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.checkForComodification();
        this.l.add(index + this.offset, element);
        this.expectedModCount = this.l.modCount();
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        this.checkForComodification();
        Object result = this.l.remove(index + this.offset);
        this.expectedModCount = this.l.modCount();
        --this.size;
        ++this.modCount;
        return result;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.checkForComodification();
        this.l.removeRange2(fromIndex + this.offset, toIndex + this.offset);
        this.expectedModCount = this.l.modCount();
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this.checkForComodification();
        this.l.addAll(this.offset + index, c);
        this.expectedModCount = this.l.modCount();
        this.size += cSize;
        ++this.modCount;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        this.checkForComodification();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return new ListIterator<E>(){
            private ListIterator<E> i;
            {
                this.i = SubList.this.l.listIterator(index + SubList.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < SubList.this.size;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            @Override
            public E previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - SubList.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - SubList.this.offset;
            }

            @Override
            public void remove() {
                this.i.remove();
                SubList.this.expectedModCount = SubList.this.l.modCount();
                SubList.this.size--;
                SubList.this.modCount++;
            }

            @Override
            public void set(E e) {
                this.i.set(e);
            }

            @Override
            public void add(E e) {
                this.i.add(e);
                SubList.this.expectedModCount = SubList.this.l.modCount();
                SubList.this.size++;
                SubList.this.modCount++;
            }
        };
    }

    @Override
    public C.List<E> subList(int fromIndex, int toIndex) {
        if (this.is(C.Feature.RANDOM_ACCESS)) {
            return new RandomAccessSubList(this, fromIndex, toIndex);
        }
        return new SubList<E>(this, fromIndex, toIndex);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
        }
    }

    protected void checkForComodification() {
        if (this.l.modCount() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

