/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeReference<T> {
    static ConcurrentMap<Type, Type> classTypeCache = new ConcurrentHashMap<Type, Type>(16, 0.75f, 1);
    protected final Type type;
    public static final Type LIST_STRING = new TypeReference<List<String>>(){}.getType();

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        Type cachedType = (Type)classTypeCache.get(type);
        if (cachedType == null) {
            classTypeCache.putIfAbsent(type, type);
            cachedType = (Type)classTypeCache.get(type);
        }
        this.type = cachedType;
    }

    public Type getType() {
        return this.type;
    }

    public static Type listOf(Class<?> elementType) {
        return TypeReference.create(new Type[]{elementType}, List.class);
    }

    public static Type setOf(Class<?> elementType) {
        return TypeReference.create(new Type[]{elementType}, Set.class);
    }

    public static Type collectionOf(Class<?> elementType) {
        return TypeReference.create(new Type[]{elementType}, Collection.class);
    }

    public static Type mapOf(Class<?> keyType, Class<?> valType) {
        return TypeReference.create(new Type[]{keyType, valType}, Map.class);
    }

    public static Type IterableOf(Class<?> elementType) {
        return TypeReference.create(new Type[]{elementType}, Iterable.class);
    }

    private static Type create(Type[] actualTypeArguments, Type rawType) {
        return new ParameterizedTypeImpl(actualTypeArguments, null, rawType);
    }
}

