/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.osgl.$;
import org.osgl.util.IO;
import org.osgl.util.Output;
import org.osgl.util.WriterOutputStream;

public class WriterOutput
implements Output {
    private Writer w;

    public WriterOutput(Writer w) {
        this.w = $.requireNotNull(w);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        IO.close(this.w);
    }

    @Override
    public void flush() {
        IO.flush(this.w);
    }

    @Override
    public Output append(CharSequence csq) {
        IO.append(csq, this.w);
        return this;
    }

    @Override
    public Output append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public Output append(char c) {
        IO.write(c, this.w);
        return this;
    }

    @Override
    public Output append(byte[] bytes) {
        return this.append(new String(bytes));
    }

    @Override
    public Output append(byte[] bytes, int start, int end) {
        int len = end - start;
        byte[] ba = new byte[len];
        System.arraycopy(bytes, start, ba, 0, len);
        return this.append(ba);
    }

    @Override
    public Output append(byte b) {
        return this.append((char)b);
    }

    @Override
    public Output append(ByteBuffer buffer) {
        int len = buffer.limit();
        byte[] ba = new byte[len];
        buffer.get(ba);
        return this.append(ba);
    }

    @Override
    public OutputStream asOutputStream() {
        return new WriterOutputStream(this.w);
    }

    @Override
    public Writer asWriter() {
        return this.w;
    }
}

