/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.w3c.dom.Document;

public class XML {
    public static final Object HINT_PRETTY = new Object();
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private static final ThreadLocal<DocumentBuilder> builder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return builderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw E.invalidConfiguration(e, "error getting DocumentBuilder", new Object[0]);
            }
        }
    };
    private static final ThreadLocal<TransformerFactory> transformerFactory = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    };
    private static final ThreadLocal<Transformer> transformer = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return ((TransformerFactory)transformerFactory.get()).newTransformer();
            }
            catch (Exception e) {
                throw E.unexpected(e);
            }
        }
    };
    public static final Lang.TypeConverter<String, Document> STRING_TO_XML_DOCUMENT = Lang.TypeConverter.STRING_TO_XML_DOCUMENT;
    public static final Lang.TypeConverter<InputStream, Document> IS_TO_XML_DOCUMENT = Lang.TypeConverter.IS_TO_XML_DOCUMENT;
    public static final Lang.TypeConverter<Document, String> XML_DOCUMENT_TO_STRING = Lang.TypeConverter.XML_DOCUMENT_TO_STRING;

    public static void print(Document document, OutputStream os) {
        XML.print(document, false, os);
    }

    public static void print(Document document, boolean pretty, OutputStream os) {
        Transformer t = transformer.get();
        t.setOutputProperty("method", "xml");
        t.setOutputProperty("encoding", "UTF-8");
        if (pretty) {
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        try {
            t.transform(new DOMSource(document), new StreamResult(os));
        }
        catch (TransformerException e) {
            throw E.unexpected(e);
        }
        finally {
            t.reset();
        }
    }

    public static String toString(Document document, boolean pretty) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XML.print(document, pretty, os);
        byte[] ba = os.toByteArray();
        return $.convert(ba).toString();
    }

    public static String toString(Document document) {
        return XML.toString(document, false);
    }

    public static Document read(String content) {
        DocumentBuilder b = builder.get();
        try {
            Document document = b.parse(IO.inputStream(content));
            return document;
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
        finally {
            b.reset();
        }
    }

    public static Document read(InputStream is) {
        DocumentBuilder b = builder.get();
        try {
            Document document = b.parse(is);
            return document;
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
        finally {
            b.reset();
        }
    }

    public static Document read(Reader reader) {
        DocumentBuilder b = builder.get();
        try {
            Document document = b.parse($.convert(reader).to(InputStream.class));
            return document;
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
        finally {
            b.reset();
        }
    }

    public static Document read(URL url) {
        DocumentBuilder b = builder.get();
        try {
            Document document = b.parse(IO.inputStream(url));
            return document;
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
        finally {
            b.reset();
        }
    }

    public static Document read(File file) {
        DocumentBuilder b = builder.get();
        try {
            Document document = b.parse(file);
            return document;
        }
        catch (Exception e) {
            throw E.unexpected(e);
        }
        finally {
            b.reset();
        }
    }

    public static void init() {
    }
}

