/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.algo;

import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.S;

public abstract class StringSearch
implements Lang.Func3<char[], char[], Integer, Integer> {
    public abstract int search(char[] var1, char[] var2, int var3);

    @Override
    public final Integer apply(char[] text, char[] target, Integer from) throws NotAppliedException, Lang.Break {
        return this.search(text, target, from);
    }

    public static StringSearch wrap(final Lang.Func3<char[], char[], Integer, Integer> searchLogic) {
        return $.requireNotNull(searchLogic) instanceof StringSearch ? (StringSearch)searchLogic : new StringSearch(){

            @Override
            public int search(char[] text, char[] target, int from) {
                return (Integer)searchLogic.apply(text, target, from);
            }
        };
    }

    public static class SimpleStringSearch
    extends StringSearch {
        @Override
        public int search(char[] text, char[] target, int from) {
            int targetLen;
            int txtLen;
            if (from < 0) {
                from = 0;
            }
            if ((txtLen = text.length) - from < (targetLen = target.length)) {
                return -1;
            }
            return S.indexOf(text, 0, txtLen, target, 0, targetLen, from);
        }
    }
}

