/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.S;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlToJson
extends Lang.TypeConverter<Document, JSONObject> {
    public static final int HINT_MERGE_MAP = 4096;
    public static final String INNER_VALUE = "innerValue";

    @Override
    public JSONObject convert(Document document) {
        return this.convert(document, (Object)0);
    }

    @Override
    public JSONObject convert(Document document, Object hint) {
        Node root = XmlToJson.rootNode(document);
        if (null == root) {
            return new JSONObject();
        }
        int theHint = hint instanceof Integer ? (Integer)hint : 0;
        return this.convert(root.getChildNodes(), new JSONObject(), theHint);
    }

    private JSONObject convert(NodeList nodeList, JSONObject bag, int hint) {
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            this.merge(node, bag, hint);
        }
        return bag;
    }

    private void merge(Node node, JSONObject bag, int hint) {
        String nodeName = XmlToJson.nameOf(node);
        Object existing = bag.get((Object)nodeName);
        Object innerValue = this.convertNodeInner(node, hint);
        Object merged = XmlToJson.merge(innerValue, existing, hint);
        if (null != merged) {
            bag.put(nodeName, merged);
        }
    }

    private Object convertNodeInner(Node node, int hint) {
        boolean hasAttribute;
        NodeList children = node.getChildNodes();
        NamedNodeMap attributes = node.getAttributes();
        boolean hasChild = null != children && children.getLength() > 0;
        boolean bl = hasAttribute = null != attributes && attributes.getLength() > 0;
        if (!hasChild && !hasAttribute) {
            return null;
        }
        JSONObject convertedAttributes = this.convert(attributes);
        Object convertedChildren = this.convert(children, hint);
        if (null == convertedChildren) {
            return convertedAttributes;
        }
        if ($.bool(convertedAttributes)) {
            if (convertedChildren instanceof JSONObject) {
                convertedAttributes.putAll((Map)((JSONObject)convertedChildren));
            } else {
                convertedAttributes.put(INNER_VALUE, convertedChildren);
            }
            return convertedAttributes;
        }
        return convertedChildren;
    }

    private Object convert(NodeList children, int hint) {
        int len;
        int n = len = null == children ? 0 : children.getLength();
        if (0 == len) {
            return null;
        }
        Object prev = null;
        for (int i = 0; i < len; ++i) {
            Object cur = this.convert(children.item(i), hint);
            prev = XmlToJson.merge(cur, prev, hint);
        }
        return prev;
    }

    private Object convert(Node node, int hint) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                return XmlToJson.convert(node.getNodeValue());
            }
            case 1: {
                JSONObject bag = new JSONObject();
                bag.put(node.getNodeName(), this.convertNodeInner(node, hint));
                return bag;
            }
        }
        return null;
    }

    @Override
    private JSONObject convert(NamedNodeMap attributes) {
        int len;
        int n = len = null == attributes ? 0 : attributes.getLength();
        if (0 == len) {
            return null;
        }
        JSONObject bag = new JSONObject();
        for (int i = 0; i < len; ++i) {
            Node attribute = attributes.item(i);
            bag.put(attribute.getNodeName(), XmlToJson.convert(attribute.getNodeValue()));
        }
        return bag;
    }

    private static Object merge(Object value, Object existing, int hint) {
        if (null == existing) {
            return value;
        }
        if (null == value) {
            return existing;
        }
        if (XmlToJson.doMergeMap(hint)) {
            if (value instanceof JSONObject) {
                if (existing instanceof JSONObject) {
                    return XmlToJson.mergeMap((JSONObject)value, (JSONObject)existing);
                }
                JSONObject map = (JSONObject)value;
                Object innerValue = map.get((Object)INNER_VALUE);
                if (null == innerValue) {
                    innerValue = value;
                } else if (innerValue instanceof JSONArray) {
                    ((JSONArray)innerValue).add(existing);
                } else {
                    JSONArray array = new JSONArray();
                    array.add(existing);
                    array.add(innerValue);
                    innerValue = array;
                }
                if (innerValue instanceof JSONObject) {
                    map.putAll((Map)((JSONObject)innerValue));
                } else {
                    map.put(INNER_VALUE, innerValue);
                }
                return map;
            }
            if (existing instanceof JSONObject) {
                JSONObject map = (JSONObject)existing;
                Object innerValue = map.get((Object)INNER_VALUE);
                if (null == innerValue) {
                    innerValue = value;
                } else if (innerValue instanceof JSONArray) {
                    ((JSONArray)innerValue).add(value);
                } else {
                    JSONArray array = new JSONArray();
                    array.add(innerValue);
                    array.add(value);
                    innerValue = array;
                }
                if (innerValue instanceof JSONObject) {
                    map.putAll((Map)((JSONObject)innerValue));
                } else {
                    map.put(INNER_VALUE, innerValue);
                }
                return map;
            }
            if (existing instanceof JSONArray) {
                ((JSONArray)existing).add(value);
                return existing;
            }
            JSONArray array = new JSONArray();
            array.add(existing);
            array.add(value);
            return array;
        }
        if (existing instanceof List) {
            ((List)existing).add(value);
            return existing;
        }
        JSONArray list = new JSONArray();
        list.add(existing);
        list.add(value);
        return list;
    }

    private static JSONObject mergeMap(JSONObject value, JSONObject existing) {
        for (Map.Entry entry : value.entrySet()) {
            String key = (String)entry.getKey();
            Object valueValue = entry.getValue();
            Object existingValue = existing.get((Object)key);
            if (null != existingValue) {
                existing.put(key, XmlToJson.merge(valueValue, existingValue, 4096));
                continue;
            }
            existing.put(key, valueValue);
        }
        return existing;
    }

    private static String nameOf(Node node) {
        String name = node.getLocalName();
        if (null == name) {
            name = node.getNodeName();
        }
        return name;
    }

    private static Object convert(String s) {
        if (null == s) {
            return null;
        }
        if ("".equals(s = s.trim())) {
            return null;
        }
        if ("true".equals(s)) {
            return Boolean.TRUE;
        }
        if ("false".equals(s)) {
            return Boolean.FALSE;
        }
        if (S.isInt(s)) {
            if (9 >= s.length()) {
                return Integer.parseInt(s);
            }
            if (19 >= s.length()) {
                long l = Long.parseLong(s);
                if (l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                return l;
            }
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return new BigInteger(s);
            }
        }
        if (XmlToJson.isNumeric(s)) {
            return Double.parseDouble(s);
        }
        return s;
    }

    private static boolean isNumeric(String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        int dotCount = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (dotCount < 1 && c == '.') {
                ++dotCount;
                continue;
            }
            if (XmlToJson.isNumeric(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    private static Node rootNode(Document document) {
        NodeList children = document.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            return node;
        }
        return null;
    }

    public static boolean doMergeMap(int hint) {
        return (hint & 0x1000) != 0;
    }
}

