/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.InvalidArgException;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.LazySeq;
import org.osgl.util.N;
import org.osgl.util.Nil;

public class LazyRange<ELEMENT>
extends LazySeq<ELEMENT>
implements C.Range<ELEMENT>,
Serializable {
    private final ELEMENT to;
    private final Comparator<ELEMENT> order;
    private final Lang.Func2<ELEMENT, Integer, ELEMENT> step;
    protected final int ordering;
    private final int size;
    protected final Lang.F1<ELEMENT, ELEMENT> next;
    protected final Lang.F1<ELEMENT, ELEMENT> prev;

    public LazyRange(ELEMENT from, ELEMENT to, Lang.Func2<ELEMENT, Integer, ELEMENT> step) {
        this(from, to, Lang.F.NATURAL_ORDER, step);
    }

    public LazyRange(final ELEMENT from, final ELEMENT to, Comparator<ELEMENT> order, Lang.Func2<ELEMENT, Integer, ELEMENT> step) {
        E.NPE(from, to, order, step);
        this.ordering = N.sign(order.compare(from, to));
        boolean eq = $.eq(from, to);
        E.invalidArgIf(eq, "[from] shall not be equals to [to]", new Object[0]);
        ELEMENT next = step.apply(from, -this.ordering);
        int ordering2 = order.compare(from, next);
        if (N.sign(ordering2) != N.sign(this.ordering)) {
            E.invalidArg("step function doesn't align to the direction between [from] and [to]", new Object[0]);
        }
        if (from instanceof Number) {
            int n2;
            int unit;
            int n0 = ((Number)from).intValue();
            int n1 = ((Number)to).intValue();
            int distance = n1 - n0;
            int mod = distance % (unit = (n2 = ((Number)next).intValue()) - n0);
            this.size = mod > 0 ? (distance + mod) / unit - 1 : distance / unit;
        } else {
            this.size = -1;
        }
        this.to = to;
        this.head = from;
        this.order = order;
        this.step = step;
        Lang.F2<ELEMENT, Integer, ELEMENT> f2 = $.f2(this.step());
        this.next = f2.curry(-this.ordering);
        this.prev = f2.curry(this.ordering);
        this.tail = new Lang.F0<C.Sequence<ELEMENT>>(){

            @Override
            public C.Sequence<ELEMENT> apply() throws NotAppliedException, Lang.Break {
                if ($.eq(from, to)) {
                    return Nil.seq();
                }
                return LazyRange.this.of(LazyRange.this.next.apply(from), to);
            }
        };
        this.setFeature(C.Feature.LIMITED);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof C.Range) {
            C.Range that = (C.Range)obj;
            return $.eq(that.from(), this.from()) && $.eq(that.to(), this.to()) && $.eq(that.order(), this.order()) && $.eq(that.step(), this.step());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return $.hc(this.from(), this.to(), this.order(), this.step());
    }

    public String toString() {
        return "[" + this.from() + "," + this.to() + ")";
    }

    @Override
    public int size() throws UnsupportedOperationException {
        if (this.size < 0) {
            throw new UnsupportedOperationException();
        }
        return this.size;
    }

    protected LazyRange<ELEMENT> of(ELEMENT from, ELEMENT to) {
        return new LazyRange<ELEMENT>(from, to, this.order, this.step);
    }

    @Override
    public final ELEMENT from() {
        return (ELEMENT)this.head();
    }

    @Override
    public final ELEMENT to() {
        return this.to;
    }

    @Override
    public Comparator<ELEMENT> order() {
        return this.order;
    }

    @Override
    public Lang.Func2<ELEMENT, Integer, ELEMENT> step() {
        return this.step;
    }

    @Override
    public C.Range<ELEMENT> merge(C.Range<ELEMENT> r2) throws InvalidArgException {
        if ($.ne(this.step(), r2.step()) || $.ne(this.order(), r2.order())) {
            throw E.invalidArg("r2 and this range does not have the same step or order operator", new Object[0]);
        }
        int ordering2 = N.sign(this.order.compare(r2.from(), r2.to()));
        if (ordering2 != this.ordering) {
            throw E.invalidArg("r2 and this range doesn't have the same ordering direction", new Object[0]);
        }
        ELEMENT from1 = this.from();
        ELEMENT to1 = this.step().apply(this.to, -1);
        ELEMENT from2 = r2.from();
        ELEMENT to2 = r2.step().apply(r2.to(), -1);
        boolean fromInThis = this.contains(from2);
        boolean toInThis = this.contains(to2);
        if (fromInThis && toInThis) {
            return this;
        }
        boolean fromInThat = r2.contains(from1);
        boolean toInThat = r2.contains(to1);
        if (fromInThat && toInThat) {
            return r2;
        }
        if (fromInThis && toInThat || $.eq(this.to(), from2)) {
            return this.of(from1, r2.to());
        }
        if (toInThis && fromInThat || $.eq(from1, r2.to())) {
            return this.of(from2, this.to);
        }
        throw E.invalidArg("r2 and this range cannot be merged together", new Object[0]);
    }

    @Override
    public ELEMENT last() throws UnsupportedOperationException {
        return (ELEMENT)this.prev.apply(this.to);
    }

    @Override
    public C.Range<ELEMENT> tail() throws UnsupportedOperationException {
        Object from = this.next.apply(this.from());
        if ($.eq(from, this.to)) {
            return Nil.range();
        }
        return this.of(this.next.apply(this.from()), this.to);
    }

    @Override
    public C.Range<ELEMENT> head(int n) {
        return this.take(n);
    }

    @Override
    public C.Range<ELEMENT> tail(int n) throws UnsupportedOperationException {
        E.illegalArgumentIf(n <= 0, "n must be a positive int");
        return this.of(this.step().apply(this.to, -n), this.to);
    }

    @Override
    public C.Range<ELEMENT> take(int n) {
        E.invalidArgIf(n <= 0, "n must be a positive int", new Object[0]);
        ELEMENT from = this.from();
        return this.of(from, this.step().apply(from, n));
    }

    @Override
    public C.Range<ELEMENT> drop(int n) {
        E.invalidArgIf(n <= 0, "n must be a positive int", new Object[0]);
        ELEMENT from = this.from();
        return this.of(this.step().apply(from, n), this.to);
    }

    @Override
    public C.Range<ELEMENT> reverse() throws UnsupportedOperationException {
        return this.of(this.prev.apply(this.to), this.prev.apply(this.from()));
    }

    @Override
    public Iterator<ELEMENT> reverseIterator() {
        return this.reverse().iterator();
    }

    @Override
    public <R> R reduceRight(R identity, Lang.Func2<R, ELEMENT, R> accumulator) {
        return this.reverse().reduceLeft(identity, accumulator);
    }

    @Override
    public LazyRange<ELEMENT> accept(Lang.Visitor<? super ELEMENT> visitor) {
        super.accept(visitor);
        return this;
    }

    @Override
    public LazyRange<ELEMENT> forEach(Lang.Visitor<? super ELEMENT> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    @Override
    public LazyRange<ELEMENT> each(Lang.Visitor<? super ELEMENT> visitor) {
        return this.accept((Lang.Visitor)visitor);
    }

    @Override
    public LazyRange<ELEMENT> acceptLeft(Lang.Visitor<? super ELEMENT> visitor) {
        super.acceptLeft(visitor);
        return this;
    }

    @Override
    public LazyRange<ELEMENT> acceptRight(Lang.Visitor<? super ELEMENT> visitor) {
        this.reverse().acceptLeft(visitor);
        return this;
    }

    @Override
    public Lang.Option<ELEMENT> reduceRight(Lang.Func2<ELEMENT, ELEMENT, ELEMENT> accumulator) {
        return this.reverse().reduceLeft(accumulator);
    }

    @Override
    public Lang.Option<ELEMENT> findLast(Lang.Function<? super ELEMENT, Boolean> predicate) {
        return this.reverse().findFirst(predicate);
    }

    @Override
    public boolean contains(ELEMENT t) {
        E.NPE(t);
        if (0 == this.ordering) {
            return $.eq(this.to, t);
        }
        ELEMENT from = this.from();
        if ($.eq(from, t)) {
            return true;
        }
        int withFrom = this.order.compare(t, from);
        if (this.ordering < 0 && withFrom < 0) {
            return false;
        }
        int withTo = this.order.compare(t, this.to);
        return withFrom * withTo < 0;
    }

    @Override
    public boolean containsAll(C.Range<ELEMENT> range) {
        E.NPE(range);
        return this.contains(range.from()) && this.contains(this.prev.apply(range.to()));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy<ELEMENT>
    implements Serializable {
        ELEMENT from;
        ELEMENT to;
        Comparator<ELEMENT> order;
        Lang.Func2<ELEMENT, Integer, ELEMENT> step;
        private static final long serialVersionUID = 21864874113505L;

        SerializationProxy(LazyRange<ELEMENT> r) {
            this.from = r.from();
            this.to = r.to();
            this.order = ((LazyRange)r).order;
            this.step = ((LazyRange)r).step;
        }

        private Object readResolve() {
            return new LazyRange<ELEMENT>(this.from, this.to, this.order, this.step);
        }
    }
}

