/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.FastStr;
import org.osgl.util.ListBase;
import org.osgl.util.ListBuilder;
import org.osgl.util.Nil;

public abstract class StrBase<T extends StrBase<T>>
extends ListBase<Character>
implements RandomAccess,
CharSequence,
Serializable,
Comparable<T> {
    protected StrBase() {
    }

    protected abstract Class<T> _impl();

    protected abstract T _empty();

    public abstract T subList(int var1, int var2) throws StringIndexOutOfBoundsException;

    public abstract T insert(int var1, char var2) throws StringIndexOutOfBoundsException;

    public abstract T insert(int var1, Character var2) throws StringIndexOutOfBoundsException;

    public abstract T insert(int var1, Character ... var2) throws StringIndexOutOfBoundsException;

    public abstract T insert(int var1, char ... var2) throws StringIndexOutOfBoundsException;

    public abstract T insert(int var1, StrBase<?> var2) throws StringIndexOutOfBoundsException;

    public abstract T insert(int var1, String var2) throws StringIndexOutOfBoundsException;

    public abstract T remove(Lang.Function<? super Character, Boolean> var1);

    public abstract T takeWhile(Lang.Function<? super Character, Boolean> var1);

    public abstract T dropWhile(Lang.Function<? super Character, Boolean> var1);

    public abstract T reverse();

    public abstract T append(Collection<? extends Character> var1);

    public abstract T append(C.List<Character> var1);

    public abstract T append(char ... var1);

    public abstract T append(Character var1);

    public abstract T append(T var1);

    public abstract T append(String var1);

    public abstract T prepend(Collection<? extends Character> var1);

    public abstract T prepend(C.List<Character> var1);

    public abstract T prepend(char ... var1);

    public abstract T prepend(Character var1);

    public abstract T prepend(T var1);

    public abstract T prepend(String var1);

    public abstract T subSequence(int var1, int var2);

    public abstract T times(int var1);

    public abstract T padLeft(char var1, int var2);

    public abstract T lpad(char var1, int var2);

    public abstract T padLeft(int var1);

    public abstract T lpad(int var1);

    public abstract T padRight(char var1, int var2);

    public abstract T rpad(char var1, int var2);

    public abstract T padRight(int var1);

    public abstract T rpad(int var1);

    public abstract void getChars(int var1, int var2, char[] var3, int var4);

    public abstract byte[] getBytesAscII();

    public abstract byte[] getBytesUTF8();

    public abstract byte[] getBytes();

    public abstract byte[] getBytes(Charset var1);

    public abstract byte[] getBytes(String var1);

    public abstract FastStr toFastStr();

    public abstract boolean contentEquals(CharSequence var1);

    public abstract boolean contentEquals(T var1);

    public abstract boolean isBlank();

    public final int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    @Override
    public int indexOf(Object o) {
        if (this.getClass().isAssignableFrom(o.getClass())) {
            StrBase str = (StrBase)$.cast(o);
            return this.indexOf((T)str);
        }
        if (o instanceof CharSequence) {
            CharSequence str = (CharSequence)o;
            return this.indexOf(str);
        }
        if (o instanceof Character) {
            Character c = (Character)o;
            return this.indexOf(c.charValue());
        }
        if (o instanceof Integer) {
            Integer n = (Integer)o;
            return this.indexOf(n);
        }
        return -1;
    }

    public abstract int indexOf(int var1, int var2);

    public abstract int indexOf(CharSequence var1, int var2);

    public abstract int indexOf(T var1, int var2);

    public int indexOf(List<Character> list) {
        return this.indexOf(FastStr.of(list));
    }

    public int indexOf(List<Character> list, int startIndex) {
        return this.indexOf(FastStr.of(list), startIndex);
    }

    public final int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.size());
    }

    public final int lastIndexOf(CharSequence str) {
        return this.lastIndexOf(str, this.size() - 1);
    }

    @Override
    public final int lastIndexOf(T str) {
        return this.lastIndexOf(str, this.size() - 1);
    }

    public int lastIndexOf(List<Character> list) {
        return this.lastIndexOf(FastStr.of(list));
    }

    public int lastIndexOf(List<Character> list, int startIndex) {
        return this.lastIndexOf(FastStr.of(list), startIndex);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof String) {
            String str = (String)o;
            return this.lastIndexOf(str);
        }
        if (StrBase.class.isAssignableFrom(o.getClass())) {
            StrBase str = (StrBase)$.cast(o);
            return this.lastIndexOf((T)str);
        }
        if (o instanceof Character) {
            Character c = (Character)o;
            return this.lastIndexOf(c.charValue());
        }
        if (o instanceof Integer) {
            Integer n = (Integer)o;
            return this.lastIndexOf(n);
        }
        return -1;
    }

    public abstract int lastIndexOf(int var1, int var2);

    public abstract int lastIndexOf(CharSequence var1, int var2);

    public abstract int lastIndexOf(T var1, int var2);

    public abstract String substring(int var1);

    public abstract boolean equalsIgnoreCase(CharSequence var1);

    @Override
    public abstract int compareTo(CharSequence var1);

    public abstract int compareToIgnoreCase(T var1);

    public abstract int compareToIgnoreCase(CharSequence var1);

    public abstract boolean regionMatches(boolean var1, int var2, T var3, int var4, int var5);

    public abstract boolean regionMatches(boolean var1, int var2, CharSequence var3, int var4, int var5);

    public final boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public final boolean startsWith(T prefix) {
        return this.startsWith(prefix, 0);
    }

    public abstract boolean startsWith(T var1, int var2);

    public abstract boolean startsWith(CharSequence var1, int var2);

    public final boolean endsWith(CharSequence prefix) {
        return this.endsWith(prefix, 0);
    }

    public final boolean endsWith(T prefix) {
        return this.endsWith(prefix, 0);
    }

    public abstract boolean endsWith(T var1, int var2);

    public abstract boolean endsWith(CharSequence var1, int var2);

    public abstract String substring(int var1, int var2);

    public abstract T replace(char var1, char var2);

    public abstract T replace(CharSequence var1, CharSequence var2);

    public abstract T replaceAll(String var1, String var2);

    public abstract T replaceFirst(String var1, String var2);

    public abstract boolean matches(String var1);

    public abstract boolean contains(CharSequence var1);

    public abstract C.List<T> split(String var1, int var2);

    public abstract T toLowerCase(Locale var1);

    public abstract T toUpperCase(Locale var1);

    public abstract T trim();

    public abstract char[] charArray();

    public abstract String intern();

    public abstract T afterFirst(String var1);

    public abstract T afterFirst(T var1);

    public abstract T afterFirst(char var1);

    public abstract T afterLast(String var1);

    public abstract T afterLast(T var1);

    public abstract T afterLast(char var1);

    public abstract T beforeFirst(String var1);

    public abstract T beforeFirst(char var1);

    public abstract T beforeFirst(T var1);

    public abstract T beforeLast(String var1);

    public abstract T beforeLast(T var1);

    public abstract T beforeLast(char var1);

    public abstract T strip(String var1, String var2);

    public abstract T urlEncode();

    public abstract T decodeBASE64();

    public abstract T encodeBASE64();

    public abstract T capFirst();

    public abstract int count(String var1, boolean var2);

    public abstract int count(T var1, boolean var2);

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StrBase) {
            StrBase that = (StrBase)o;
            return that.contentEquals((T)this);
        }
        return false;
    }

    private T me() {
        return (T)this;
    }

    @Override
    protected EnumSet<C.Feature> initFeatures() {
        return EnumSet.of(C.Feature.READONLY, new C.Feature[]{C.Feature.LIMITED, C.Feature.ORDERED, C.Feature.IMMUTABLE, C.Feature.LAZY, C.Feature.PARALLEL, C.Feature.RANDOM_ACCESS});
    }

    public T lazy() {
        return this.me();
    }

    public T eager() {
        return this.me();
    }

    public T snapshot() {
        return this.me();
    }

    public T readOnly() {
        return this.me();
    }

    public T copy() {
        return this.me();
    }

    public final void copy(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    protected T setFeature(C.Feature feature) {
        return this.me();
    }

    public T parallel() {
        return this.me();
    }

    protected T unsetFeature(C.Feature feature) {
        return this.me();
    }

    @Override
    public final Character get(int index) {
        return Character.valueOf(this.charAt(index));
    }

    @Override
    public final int size() {
        return this.length();
    }

    @Override
    public final Character set(int index, Character element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, Character element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Character remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Character> listIterator(int index) {
        return new LstItr(index);
    }

    public T take(int n) {
        int sz = this.size();
        if (sz == 0) {
            return this._empty();
        }
        if (n == 0) {
            return this._empty();
        }
        if (n < 0) {
            if ((n = -n) >= sz) {
                return this.me();
            }
            return (T)this.drop(sz - n);
        }
        if (n >= sz) {
            return this.me();
        }
        return (T)this.subList(0, n);
    }

    public T head(int n) {
        return (T)this.take(n);
    }

    public T drop(int n) throws IndexOutOfBoundsException {
        int sz = this.size();
        if (n < 0) {
            if ((n = -n) >= sz) {
                return this._empty();
            }
            return (T)this.take(sz - n);
        }
        if (n == 0) {
            return this.me();
        }
        if (n > sz) {
            return this._empty();
        }
        return (T)this.subList(n, sz);
    }

    @Override
    public <R> C.List<R> map(Lang.Function<? super Character, ? extends R> mapper) {
        int sz = this.size();
        if (0 == sz) {
            return Nil.list();
        }
        ListBuilder lb = new ListBuilder(sz);
        this.forEach($.visitor($.f1(mapper).andThen(C.F.addTo(lb))));
        return lb.toList();
    }

    @Override
    public <R> C.List<R> flatMap(Lang.Function<? super Character, ? extends Iterable<? extends R>> mapper) {
        if (this.isEmpty()) {
            return Nil.list();
        }
        return super.flatMap(mapper);
    }

    public T filter(Lang.Function<? super Character, Boolean> predicate) {
        if (this.isEmpty()) {
            return this._empty();
        }
        return (T)this.remove(Lang.Predicate.negate(predicate));
    }

    public T accept(Lang.Visitor<? super Character> visitor) {
        super.accept(visitor);
        return this.me();
    }

    public T acceptLeft(Lang.Visitor<? super Character> visitor) {
        super.acceptLeft(visitor);
        return this.me();
    }

    public T acceptRight(Lang.Visitor<? super Character> visitor) {
        super.acceptRight(visitor);
        return this.me();
    }

    public T tail() {
        int sz = this.size();
        if (0 == sz) {
            throw new UnsupportedOperationException();
        }
        return (T)this.subList(1, sz);
    }

    public T tail(int n) {
        int sz = this.size();
        if (n < 0) {
            return (T)this.head(-n);
        }
        if (n == 0) {
            return this._empty();
        }
        if (n >= sz) {
            return this.me();
        }
        return (T)this.subList(sz - n, sz);
    }

    public String value() {
        return this.toString();
    }

    public String val() {
        return this.toString();
    }

    public final T substr(int beginIndex, int endIndex) {
        return (T)this.subList(beginIndex, endIndex);
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public T maxLength(int max) {
        if (this.isEmpty()) {
            return this._empty();
        }
        if (this.length() < max - 3) {
            return this.me();
        }
        return ((StrBase)this.subList(0, max)).append("...");
    }

    public T cutOff(int max) {
        return this.maxLength(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            return this.contentEquals((CharSequence)stringBuffer);
        }
    }

    public final boolean eq(CharSequence x) {
        return this.contentEquals(x);
    }

    public final boolean eq(T x) {
        return this.contentEquals(x);
    }

    public final boolean eq(StringBuffer stringBuffer) {
        return this.contentEquals(stringBuffer);
    }

    public final int pos(CharSequence x, int fromIndex) {
        return this.indexOf(x, fromIndex);
    }

    public final int pos(CharSequence x) {
        return this.indexOf(x);
    }

    @Override
    public final int indexOf(T x) {
        return this.indexOf(x, 0);
    }

    public final int indexOf(CharSequence str) {
        return this.indexOf(str, 0);
    }

    public final int pos(int ch) {
        return this.indexOf(ch, 0);
    }

    public final int pos(T x) {
        return this.indexOf(x, 0);
    }

    public final int pos(int ch, int fromIndex) {
        return this.indexOf(ch, fromIndex);
    }

    public final int pos(T x, int fromIndex) {
        return this.indexOf(x, fromIndex);
    }

    public final int rpos(int ch) {
        return this.lastIndexOf(ch, this.size() - 1);
    }

    public final int rpos(T x) {
        return this.lastIndexOf(x);
    }

    public final int rpos(CharSequence str, int fromIndex) {
        return this.lastIndexOf(str, fromIndex);
    }

    public final int rpos(T str, int fromIndex) {
        return this.lastIndexOf(str, fromIndex);
    }

    public final int rpos(CharSequence str) {
        return this.lastIndexOf(str, this.size() - 1);
    }

    public final int rpos(int ch, int fromIndex) {
        return this.lastIndexOf(ch, fromIndex);
    }

    public final boolean contains(char c) {
        return this.indexOf(c) > -1;
    }

    public final boolean regionMatches(int toffset, T other, int ooffset, int len) {
        return this.regionMatches(false, toffset, other, ooffset, len);
    }

    public final boolean regionMatches(int toffset, String other, int ooffset, int len) {
        return this.regionMatches(false, toffset, other, ooffset, len);
    }

    public final T substr(int beginIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        return beginIndex == 0 ? this.me() : this.substr(beginIndex, this.size());
    }

    public final T concat(String str) {
        return this.append(str);
    }

    public final T concat(T str) {
        return this.append(str);
    }

    public final C.List<T> split(String regex) {
        return this.split(regex, 0);
    }

    public final T toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public final T lower() {
        return this.toLowerCase();
    }

    public final T lower(Locale locale) {
        return this.toLowerCase(locale);
    }

    public final T toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public final T upper() {
        return this.toLowerCase();
    }

    public final T upper(Locale locale) {
        return this.toUpperCase(locale);
    }

    public final T before(String s) {
        return (T)this.beforeFirst((T)s);
    }

    public final T before(T s) {
        return this.beforeFirst(s);
    }

    public final T after(T s) {
        return this.afterLast(s);
    }

    public final T after(String s) {
        return (T)this.afterLast((T)s);
    }

    @Override
    public final int count(String s) {
        return this.count(s, false);
    }

    @Override
    public final int count(T s) {
        return this.count(s, false);
    }

    public final int countWithOverlap(String s) {
        return this.count(s, true);
    }

    public final int countWithOverlap(T s) {
        return this.count(s, true);
    }

    public final char[] toCharArray() {
        return this.charArray();
    }

    public static enum F {

        public Lang.Comparator<StrBase> NATURAL_ORDER = new Lang.Comparator<StrBase>(){

            @Override
            public int compare(StrBase o1, StrBase o2) {
                return o1.toFastStr().compareTo(o2.toFastStr());
            }
        };
        public Lang.Comparator<StrBase> REVERSE_ORDER = Lang.F.reverse(this.NATURAL_ORDER);
    }

    private class LstItr
    extends Itr
    implements ListIterator<Character> {
        LstItr() {
            this(0);
        }

        LstItr(int index) {
            if (index < 0 || index > this.len) {
                throw new IndexOutOfBoundsException();
            }
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public Character previous() {
            if (this.cursor < 0) {
                throw new NoSuchElementException();
            }
            --this.cursor;
            return Character.valueOf(StrBase.this.charAt(--this.cursor));
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(Character t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Character t) {
            throw new UnsupportedOperationException();
        }
    }

    private class Itr
    implements Iterator<Character> {
        protected int cursor = 0;
        protected final int len = StrBase.this.length();

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.len;
        }

        @Override
        public Character next() {
            if (this.cursor >= this.len) {
                throw new NoSuchElementException();
            }
            return Character.valueOf(StrBase.this.charAt(this.cursor++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

