/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.util.algo;

import java.util.Arrays;
import java.util.Comparator;
import org.osgl.Lang;
import org.osgl.util.algo.Algorithms;
import org.osgl.util.algo.ArrayInsertionSort;
import org.osgl.util.algo.ArraySort;
import org.osgl.util.algo.ArraySortBase;

public class ArrayMergeSort<T>
extends ArraySortBase<T>
implements ArraySort<T> {
    @Override
    protected T[] sort0(T[] ts, int from, int to, Comparator<T> comp, T[] newTs) {
        int delta = to - from;
        if (delta < 30) {
            ArrayInsertionSort<T> is = Algorithms.arrayInsertionSort();
            return is.sort0(ts, from, to, comp, newTs);
        }
        Object[] merged = ArrayMergeSort.mergeSort(ts, from, to, comp);
        System.arraycopy(merged, 0, newTs, 0, to - from);
        return newTs;
    }

    static <T> Object[] mergeSort(T[] ts, int from, int to, Comparator<T> comp) {
        int mid = from + to >>> 1;
        if (mid == from) {
            return new Object[]{ts[mid]};
        }
        Object[] left = ArrayMergeSort.mergeSort(ts, from, mid, comp);
        Object[] right = ArrayMergeSort.mergeSort(ts, mid, to, comp);
        int llen = left.length;
        int rlen = right.length;
        Object[] ret = new Object[llen + rlen];
        int l = 0;
        int r = 0;
        while (l < llen && r < rlen) {
            Object tl = left[l];
            Object tr = right[r];
            if (comp.compare(tl, tr) < 0) {
                ret[l + r] = tl;
                ++l;
                continue;
            }
            ret[l + r] = tr;
            ++r;
        }
        if (l < llen) {
            System.arraycopy(left, l, ret, r + l, llen - l);
        } else {
            System.arraycopy(right, r, ret, r + l, rlen - r);
        }
        return ret;
    }

    public static void main(String[] args) {
        Integer[] ia = new Integer[]{5, 4, 3, 2, 1};
        ArrayMergeSort<Integer> s = new ArrayMergeSort<Integer>();
        Object[] a = s.apply((T[])ia, 0, 5, Lang.F.NATURAL_ORDER);
        System.out.println(Arrays.toString(a));
    }
}

