/*
 * Decompiled with CFR 0.152.
 */
package osgl.ut;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;
import osgl.version.Version;

public abstract class TestBase
extends Assert {
    public static final Version VERSION = Version.of(TestBase.class);

    public static void yes(boolean condition, String message, Object ... messageArgs) {
        TestBase.assertTrue((String)TestBase.fmt(message, messageArgs), (boolean)condition);
    }

    public static void yes(boolean condition) {
        TestBase.assertTrue((boolean)condition);
    }

    public static <T> void yes(T actual, Matcher<T> matcher) {
        TestBase.assertThat(actual, matcher);
    }

    public static <T> void yes(T actual, Matcher<T> matcher, String message, Object ... messageArgs) {
        if (!matcher.matches(actual)) {
            TestBase.assertThat((String)TestBase.fmt(message, messageArgs), actual, matcher);
        }
    }

    public static void no(boolean condition) {
        TestBase.assertFalse((boolean)condition);
    }

    public static void no(boolean condition, String message, Object ... messageArgs) {
        TestBase.assertTrue((String)String.format(message, messageArgs), (!condition ? 1 : 0) != 0);
    }

    public static <T> void no(T actual, Matcher<T> matcher) {
        TestBase.assertThat(actual, (Matcher)Matchers.not(matcher));
    }

    public static <T> void no(T actual, Matcher<T> matcher, String message, Object ... messageArgs) {
        if (matcher.matches(actual)) {
            TestBase.assertThat((String)TestBase.fmt(message, messageArgs), actual, (Matcher)Matchers.not(matcher));
        }
    }

    public static void fail(String message, Object ... args) {
        TestBase.fail((String)TestBase.fmt(message, args));
    }

    public static void eq(Object expected, Object actual, String message, Object ... messageArgs) {
        if (null == expected) {
            TestBase.isNull(actual, message, messageArgs);
            return;
        }
        Class<?> expectedClass = expected.getClass();
        String userMessage = TestBase.fmt(message, messageArgs);
        if (expectedClass.isArray()) {
            Class<?> actualClass = actual.getClass();
            if (!expectedClass.equals(actualClass)) {
                if (null == message || "".equals(message.trim())) {
                    TestBase.fail("arrays type differed\nExpected: %s\nActual  : %s", expectedClass.getName(), actualClass.getName());
                } else {
                    TestBase.fail("%s: arrays type differed\nExpected: %s\nActual  : %s", userMessage, expectedClass.getName(), actualClass.getName());
                }
            }
            new ExactComparisonCriteria().arrayEquals(TestBase.fmt(message, messageArgs), expected, actual);
        } else {
            TestBase.assertEquals((String)TestBase.fmt(message, messageArgs), (Object)expected, (Object)actual);
        }
    }

    public static void eq(Object expected, Object actual) {
        if (null == expected) {
            TestBase.isNull(actual);
            return;
        }
        Class<?> expectedClass = expected.getClass();
        if (expectedClass.isArray()) {
            Class<?> actualClass = actual.getClass();
            if (!expectedClass.equals(actualClass)) {
                TestBase.fail("arrays type differed\nExpected: %s\nActual  : %s", expectedClass.getName(), actualClass.getName());
            }
            new ExactComparisonCriteria().arrayEquals(null, expected, actual);
        } else {
            TestBase.assertEquals(null, (Object)expected, (Object)actual);
        }
    }

    public static void eq(double[] expecteds, double[] actuals, double delta, String message, Object ... messageArgs) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(delta).arrayEquals(TestBase.fmt(message, messageArgs), (Object)expecteds, (Object)actuals);
    }

    public static void eq(double[] expecteds, double[] actuals, double delta) throws ArrayComparisonFailure {
        TestBase.assertArrayEquals((double[])expecteds, (double[])actuals, (double)delta);
    }

    public static void eq(float[] expecteds, float[] actuals, float delta, String message, Object ... messageArgs) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(delta).arrayEquals(TestBase.fmt(message, messageArgs), (Object)expecteds, (Object)actuals);
    }

    public static void eq(float[] expecteds, float[] actuals, float delta) throws ArrayComparisonFailure {
        TestBase.assertArrayEquals((float[])expecteds, (float[])actuals, (float)delta);
    }

    public static void eq(double expected, double actual, double delta, String message, Object ... messageArgs) {
        TestBase.assertEquals((String)TestBase.fmt(message, messageArgs), (double)expected, (double)actual, (double)delta);
    }

    public static void eq(double expected, double actual, double delta) {
        TestBase.assertEquals(null, (double)expected, (double)actual, (double)delta);
    }

    public static void ne(Object unexpected, Object actual, String message, Object ... messageArgs) {
        if (null == unexpected) {
            TestBase.notNull(actual, message, messageArgs);
            return;
        }
        Class<?> unexpectedClass = unexpected.getClass();
        String userMessage = TestBase.fmt(message, messageArgs);
        if (unexpectedClass.isArray()) {
            if (null == actual || !actual.getClass().isArray()) {
                return;
            }
            TestBase.arrayNotEquals(userMessage, unexpected, actual);
        } else {
            TestBase.assertNotEquals((String)userMessage, (Object)unexpected, (Object)actual);
        }
    }

    public static void ne(Object unexpected, Object actual) {
        if (null == unexpected) {
            TestBase.notNull(actual);
            return;
        }
        Class<?> unexpectedClass = unexpected.getClass();
        if (unexpectedClass.isArray()) {
            if (null == actual || !actual.getClass().isArray()) {
                return;
            }
            TestBase.arrayNotEquals(null, unexpected, actual);
        } else {
            TestBase.assertNotEquals(null, (Object)unexpected, (Object)actual);
        }
    }

    public static void ne(double[] unexpecteds, double[] actuals, double delta, String message, Object ... messageArgs) throws AssertionError {
        TestBase.arrayNotEquals(TestBase.fmt(message, messageArgs), unexpecteds, actuals, delta);
    }

    public static void ne(double[] unexpecteds, double[] actuals, double delta) throws AssertionError {
        TestBase.arrayNotEquals(null, unexpecteds, actuals, delta);
    }

    public static void ne(float[] unexpecteds, float[] actuals, float delta, String message, Object ... messageArgs) throws AssertionError {
        TestBase.arrayNotEquals(TestBase.fmt(message, messageArgs), unexpecteds, actuals, Float.valueOf(delta));
    }

    public static void ne(float[] unexpecteds, float[] actuals, float delta) throws AssertionError {
        TestBase.arrayNotEquals(null, unexpecteds, actuals, Float.valueOf(delta));
    }

    public static void ne(double unexpected, double actual, double delta, String message, Object ... messageArgs) {
        TestBase.assertNotEquals((String)TestBase.fmt(message, messageArgs), (double)unexpected, (double)actual, (double)delta);
    }

    public static void ne(double unexpected, double actual, double delta) {
        TestBase.assertNotEquals(null, (double)unexpected, (double)actual, (double)delta);
    }

    public static void notNull(Object object, String message, Object ... messageArgs) {
        TestBase.yes(object != null, message, messageArgs);
    }

    public static void notNull(Object object) {
        TestBase.assertNotNull(null, (Object)object);
    }

    public static void isNull(Object object, String message, Object ... messageArgs) {
        TestBase.assertTrue((String)TestBase.fmt(message, messageArgs), (object == null ? 1 : 0) != 0);
    }

    public static void isNull(Object object) {
        TestBase.assertNull(null, (Object)object);
    }

    public static void notEmpty(String str, String message, Object ... messageArgs) {
        TestBase.yes(null != str && !"".equals(str), message, messageArgs);
    }

    public static void notEmpty(String str) {
        TestBase.assertTrue((null != str && !"".equals(str) ? 1 : 0) != 0);
    }

    public static void notEmpty(Collection<?> col, String message, Object ... messageArgs) {
        TestBase.no(col.isEmpty(), message, messageArgs);
    }

    public static void notEmpty(Collection<?> col) {
        TestBase.assertFalse((boolean)col.isEmpty());
    }

    public static void notEmpty(Map<?, ?> map, String message, Object ... messageArgs) {
        TestBase.no(map.isEmpty(), message, messageArgs);
    }

    public static void notEmpty(Map<?, ?> map) {
        TestBase.assertFalse((boolean)map.isEmpty());
    }

    public static <T> void notEmpty(T[] array, String message, Object ... messageArgs) {
        TestBase.yes(array.length > 0, message, messageArgs);
    }

    public static <T> void notEmpty(T[] array) {
        TestBase.assertTrue((array.length > 0 ? 1 : 0) != 0);
    }

    public static void isEmpty(String str, String message, Object ... messageArgs) {
        TestBase.yes(null == str || "".equals(str), message, messageArgs);
    }

    public static void isEmpty(String str) {
        TestBase.assertTrue((null == str || "".equals(str) ? 1 : 0) != 0);
    }

    public static void isEmpty(Collection<?> col, String message, Object ... messageArgs) {
        TestBase.yes(col.isEmpty(), message, messageArgs);
    }

    public static void isEmpty(Collection<?> col) {
        TestBase.yes(col.isEmpty());
    }

    public static void isEmpty(Map<?, ?> map, String message, Object ... messageArgs) {
        TestBase.yes(map.isEmpty(), message, messageArgs);
    }

    public static void isEmpty(Map<?, ?> map) {
        TestBase.yes(map.isEmpty());
    }

    public static <T> void isEmpty(T[] array, String message, Object ... messageArgs) {
        TestBase.yes(array.length == 0, message, messageArgs);
    }

    public static <T> void isEmpty(T[] array) {
        TestBase.assertTrue((array.length == 0 ? 1 : 0) != 0);
    }

    public static void notBlank(String str, String message, Object ... messageArgs) {
        TestBase.yes(null != str && !"".equals(str.trim()), message, messageArgs);
    }

    public static void notBlank(String str) {
        TestBase.assertTrue((null != str && !"".equals(str.trim()) ? 1 : 0) != 0);
    }

    public static void isBlank(String str, String message, Object ... messageArgs) {
        TestBase.yes(null == str || "".equals(str.trim()), message, messageArgs);
    }

    public static void isBlank(String str) {
        TestBase.assertTrue((null == str || "".equals(str.trim()) ? 1 : 0) != 0);
    }

    public static void same(Object expected, Object actual, String message, Object ... messageArgs) {
        TestBase.assertSame((String)(TestBase.fmt(message, messageArgs) + ","), (Object)expected, (Object)actual);
    }

    public static void same(Object expected, Object actual) {
        TestBase.assertSame(null, (Object)expected, (Object)actual);
    }

    public static void notSame(Object unexpected, Object actual, String message, Object ... messageArgs) {
        TestBase.assertNotSame((String)(TestBase.fmt(message, messageArgs) + ","), (Object)unexpected, (Object)actual);
    }

    public static void notSame(Object unexpected, Object actual) {
        TestBase.assertNotSame(null, (Object)unexpected, (Object)actual);
    }

    private static String fmt(String message, Object ... messageArgs) {
        if (null == message) {
            return "";
        }
        return String.format(message, messageArgs);
    }

    private static void arrayNotEquals(String message, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        if (expecteds == actuals || Arrays.deepEquals(new Object[]{expecteds}, new Object[]{actuals})) {
            TestBase.fail((String)message);
        }
    }

    private static void arrayNotEquals(String message, Object expecteds, Object actuals, Object delta) {
        int actualLen;
        int expectedLen;
        if (expecteds == actuals || Arrays.deepEquals(new Object[]{expecteds}, new Object[]{actuals})) {
            TestBase.fail((String)message);
        }
        if ((expectedLen = Array.getLength(expecteds)) != (actualLen = Array.getLength(actuals))) {
            return;
        }
        for (int i = 0; i < expectedLen; ++i) {
            Number actualElement;
            Number expectedElement;
            if (delta instanceof Double) {
                expectedElement = (Double)Array.get(expecteds, i);
                actualElement = (Double)Array.get(actuals, i);
                if (!(Math.abs((Double)expectedElement - (Double)actualElement) > (Double)delta)) continue;
                return;
            }
            expectedElement = (Float)Array.get(expecteds, i);
            actualElement = (Float)Array.get(actuals, i);
            if (!(Math.abs(((Float)expectedElement).floatValue() - ((Float)actualElement).floatValue()) > ((Float)delta).floatValue())) continue;
            return;
        }
        TestBase.fail((String)message);
    }
}

