/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.osiam.client.exception.ConflictException;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.ForbiddenException;
import org.osiam.client.exception.NoResultException;
import org.osiam.client.exception.OsiamErrorMessage;
import org.osiam.client.exception.OsiamRequestException;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.resources.helper.UserDeserializer;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;

abstract class AbstractOsiamService<T extends Resource> {
    private static final String CONNECTION_SETUP_ERROR_STRING = "Cannot connect to server";
    protected final HttpGet webResource;
    private Class<T> type;
    private String typeName;
    private ObjectMapper mapper = new ObjectMapper();
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String BEARER = "Bearer ";
    private DefaultHttpClient httpclient;
    private ContentType contentType;
    private String endpoint;

    protected AbstractOsiamService(Builder builder) {
        SimpleModule userDeserializerModule = new SimpleModule("userDeserializerModule", Version.unknownVersion()).addDeserializer(User.class, (JsonDeserializer)new UserDeserializer(User.class));
        this.mapper.registerModule((Module)userDeserializerModule);
        this.contentType = ContentType.create((String)"application/json");
        this.webResource = builder.getWebResource();
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.typeName = this.type.getSimpleName();
        this.endpoint = builder.endpoint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T getResource(String id, AccessToken accessToken) {
        HttpResponse response;
        this.ensureReferenceIsNotNull(id, "The given id can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        this.httpclient = new DefaultHttpClient();
        try {
            URI uri = new URI(this.webResource.getURI() + "/" + id);
            HttpGet realWebResource = new HttpGet(uri);
            realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
            response = this.httpclient.execute((HttpUriRequest)realWebResource);
        }
        catch (IOException | URISyntaxException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        int httpStatus = response.getStatusLine().getStatusCode();
        if (httpStatus != 200) {
            String errorMessage;
            switch (httpStatus) {
                case 401: {
                    errorMessage = this.getErrorMessageUnauthorized(response);
                    throw new UnauthorizedException(errorMessage);
                }
                case 404: {
                    errorMessage = this.getErrorMessage(response, "No " + this.typeName + " with given id " + id);
                    throw new NoResultException(errorMessage);
                }
                case 403: {
                    errorMessage = this.getErrorMessageForbidden(accessToken, "get");
                    throw new ForbiddenException(errorMessage);
                }
            }
            errorMessage = this.getErrorMessageDefault(response, httpStatus);
            throw new OsiamRequestException(httpStatus, errorMessage);
        }
        try (InputStream content = response.getEntity().getContent();){
            T t = this.mapSingleResourceResponse(content);
            return t;
        }
        catch (IOException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
    }

    protected List<T> getAllResources(AccessToken accessToken) {
        return this.searchResources("count=2147483647", accessToken).getResources();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SCIMSearchResult<T> searchResources(String queryString, AccessToken accessToken) {
        HttpResponse response;
        this.ensureAccessTokenIsNotNull(accessToken);
        this.httpclient = new DefaultHttpClient();
        try {
            URI uri = new URI(this.webResource.getURI() + (queryString.isEmpty() ? "" : "?" + queryString));
            HttpGet realWebResource = new HttpGet(uri);
            realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
            realWebResource.setURI(uri);
            response = this.httpclient.execute((HttpUriRequest)realWebResource);
        }
        catch (IOException | URISyntaxException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        int httpStatus = response.getStatusLine().getStatusCode();
        if (httpStatus != 200) {
            String errorMessage;
            switch (httpStatus) {
                case 401: {
                    errorMessage = this.getErrorMessageUnauthorized(response);
                    throw new UnauthorizedException(errorMessage);
                }
                case 403: {
                    errorMessage = this.getErrorMessageForbidden(accessToken, "get");
                    throw new ForbiddenException(errorMessage);
                }
                case 409: {
                    errorMessage = this.getErrorMessage(response, "Unable to search with the search string '" + queryString + "': " + response.getStatusLine().getReasonPhrase());
                    throw new ConflictException(errorMessage);
                }
            }
            errorMessage = this.getErrorMessageDefault(response, httpStatus);
            throw new OsiamRequestException(httpStatus, errorMessage);
        }
        try (InputStream queryResult = response.getEntity().getContent();){
            JavaType queryResultType = TypeFactory.defaultInstance().constructParametricType(SCIMSearchResult.class, new Class[]{this.type});
            SCIMSearchResult sCIMSearchResult = (SCIMSearchResult)this.mapper.readValue(queryResult, queryResultType);
            return sCIMSearchResult;
        }
        catch (IOException e) {
            throw new ConnectionInitializationException("Unable to deserialize query result", e);
        }
    }

    protected SCIMSearchResult<T> searchResources(Query query, AccessToken accessToken) {
        if (query == null) {
            throw new IllegalArgumentException("The given queryBuilder can't be null.");
        }
        return this.searchResources(query.toString(), accessToken);
    }

    protected void deleteResource(String id, AccessToken accessToken) {
        HttpResponse response;
        this.ensureReferenceIsNotNull(id, "The given id can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        this.httpclient = new DefaultHttpClient();
        try {
            URI uri = new URI(this.webResource.getURI() + "/" + id);
            HttpDelete realWebResource = new HttpDelete(uri);
            realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
            response = this.httpclient.execute((HttpUriRequest)realWebResource);
        }
        catch (IOException | URISyntaxException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        int httpStatus = response.getStatusLine().getStatusCode();
        if (httpStatus != 200) {
            switch (httpStatus) {
                case 401: {
                    String errorMessage = this.getErrorMessageUnauthorized(response);
                    throw new UnauthorizedException(errorMessage);
                }
                case 404: {
                    String errorMessage = this.getErrorMessage(response, "No " + this.typeName + " with given id " + id);
                    throw new NoResultException(errorMessage);
                }
                case 409: {
                    String errorMessage = this.getErrorMessage(response, "Unable to delete: " + response.getStatusLine().getReasonPhrase());
                    throw new ConflictException(errorMessage);
                }
                case 403: {
                    String errorMessage = this.getErrorMessageForbidden(accessToken, "delete");
                    throw new ForbiddenException(errorMessage);
                }
            }
            String errorMessage = this.getErrorMessageDefault(response, httpStatus);
            throw new OsiamRequestException(httpStatus, errorMessage);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T createResource(T resource, AccessToken accessToken) {
        HttpResponse response;
        this.ensureReferenceIsNotNull(resource, "The given " + this.typeName + " can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        HttpPost realWebResource = new HttpPost(this.webResource.getURI());
        realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
        this.httpclient = new DefaultHttpClient();
        try {
            String userAsString = this.mapper.writeValueAsString(resource);
            realWebResource.setEntity((HttpEntity)new StringEntity(userAsString, this.contentType));
            response = this.httpclient.execute((HttpUriRequest)realWebResource);
        }
        catch (IOException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        int httpStatus = response.getStatusLine().getStatusCode();
        if (httpStatus != 201) {
            switch (httpStatus) {
                case 401: {
                    String errorMessage = this.getErrorMessageUnauthorized(response);
                    throw new UnauthorizedException(errorMessage);
                }
                case 409: {
                    String errorMessage = this.getErrorMessage(response, "Unable to save");
                    throw new ConflictException(errorMessage);
                }
                case 403: {
                    String errorMessage = this.getErrorMessageForbidden(accessToken, "create");
                    throw new ForbiddenException(errorMessage);
                }
            }
            String errorMessage = this.getErrorMessageDefault(response, httpStatus);
            throw new OsiamRequestException(httpStatus, errorMessage);
        }
        try (InputStream content = response.getEntity().getContent();){
            T t = this.mapSingleResourceResponse(content);
            return t;
        }
        catch (IOException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
    }

    protected T updateResource(String id, T resource, AccessToken accessToken) {
        HttpPatch realWebResource = new HttpPatch(this.webResource.getURI() + "/" + id);
        return this.modifyResource(id, resource, accessToken, (HttpEntityEnclosingRequestBase)realWebResource);
    }

    protected T replaceResource(String id, T resource, AccessToken accessToken) {
        HttpPut realWebResource = new HttpPut(this.webResource.getURI() + "/" + id);
        return this.modifyResource(id, resource, accessToken, (HttpEntityEnclosingRequestBase)realWebResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T modifyResource(String id, T resource, AccessToken accessToken, HttpEntityEnclosingRequestBase realWebResource) {
        HttpResponse response;
        this.ensureReferenceIsNotNull(resource, "The given " + this.typeName + " can't be null.");
        this.ensureAccessTokenIsNotNull(accessToken);
        this.ensureReferenceIsNotNull(id, "The given id can't be null.");
        realWebResource.addHeader(AUTHORIZATION, BEARER + accessToken.getToken());
        this.httpclient = new DefaultHttpClient();
        try {
            String userAsString = this.mapper.writeValueAsString(resource);
            realWebResource.setEntity((HttpEntity)new StringEntity(userAsString, this.contentType));
            response = this.httpclient.execute((HttpUriRequest)realWebResource);
        }
        catch (IOException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        int httpStatus = response.getStatusLine().getStatusCode();
        if (httpStatus != 200) {
            switch (httpStatus) {
                case 401: {
                    String errorMessage = this.getErrorMessageUnauthorized(response);
                    throw new UnauthorizedException(errorMessage);
                }
                case 400: {
                    String errorMessage = this.getErrorMessage(response, "Wrong " + this.typeName + ". Unable to update");
                    throw new ConflictException(errorMessage);
                }
                case 409: {
                    String errorMessage = this.getErrorMessage(response, this.typeName + " with Conflicts. Unable to update");
                    throw new ConflictException(errorMessage);
                }
                case 404: {
                    String errorMessage = this.getErrorMessage(response, "A " + this.typeName + " with the id " + id + " could be found to be updated.");
                    throw new NoResultException(errorMessage);
                }
                case 403: {
                    String errorMessage = this.getErrorMessageForbidden(accessToken, "update");
                    throw new ForbiddenException(errorMessage);
                }
            }
            String errorMessage = this.getErrorMessageDefault(response, httpStatus);
            throw new OsiamRequestException(httpStatus, errorMessage);
        }
        try (InputStream content = response.getEntity().getContent();){
            T t = this.mapSingleResourceResponse(content);
            return t;
        }
        catch (IOException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
    }

    private void ensureAccessTokenIsNotNull(AccessToken accessToken) {
        this.ensureReferenceIsNotNull(accessToken, "The given accessToken can't be null.");
    }

    private void ensureReferenceIsNotNull(Object reference, String message) {
        if (reference == null) {
            throw new IllegalArgumentException(message);
        }
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    private String getErrorMessageForbidden(AccessToken accessToken, String process) {
        return "Insufficient scope (" + accessToken.getScope() + ") to " + process + " this " + this.typeName + ".";
    }

    private String getErrorMessageUnauthorized(HttpResponse httpResponse) {
        return this.getErrorMessage(httpResponse, "You are not authorized to access OSIAM. Please make sure your access token is valid");
    }

    private String getErrorMessageDefault(HttpResponse httpResponse, int httpStatus) {
        return this.getErrorMessage(httpResponse, String.format("Unable to setup connection (HTTP Status Code: %d)", httpStatus));
    }

    protected String getErrorMessage(HttpResponse httpResponse, String defaultErrorMessage) {
        String errorMessage;
        try (InputStream content = httpResponse.getEntity().getContent();){
            OsiamErrorMessage error = (OsiamErrorMessage)this.mapper.readValue(content, OsiamErrorMessage.class);
            errorMessage = error.getDescription();
        }
        catch (Exception e) {
            errorMessage = defaultErrorMessage;
        }
        if (errorMessage == null) {
            errorMessage = defaultErrorMessage;
        }
        return errorMessage;
    }

    protected T mapSingleResourceResponse(InputStream content) throws IOException {
        return (T)((Resource)this.mapper.readValue(content, this.type));
    }

    protected static class Builder<T> {
        private String endpoint;
        private Class<T> type;
        private String typeName;

        protected Builder(String endpoint) {
            this.endpoint = endpoint;
            this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.typeName = this.type.getSimpleName();
        }

        protected HttpGet getWebResource() {
            HttpGet webResource;
            try {
                webResource = new HttpGet(new URI(this.endpoint + "/" + this.typeName + "s"));
                webResource.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            }
            catch (URISyntaxException e) {
                throw new ConnectionInitializationException("Unable to setup connection " + this.endpoint + "is not a valid URI.", e);
            }
            return webResource;
        }
    }
}

