/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DefaultHttpClient;
import org.osiam.client.AbstractOsiamService;
import org.osiam.client.exception.ConflictException;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.ForbiddenException;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.client.update.UpdateUser;
import org.osiam.client.user.BasicUser;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;

public final class OsiamUserService
extends AbstractOsiamService<User> {
    private OsiamUserService(Builder builder) {
        super(builder);
    }

    public User getUser(String id, AccessToken accessToken) {
        return (User)this.getResource(id, accessToken);
    }

    public BasicUser getCurrentUserBasic(AccessToken accessToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The given accessToken can't be null.");
        }
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            URI uri = new URI(this.getMeWebResource().getURI().toString());
            HttpGet realWebResource = new HttpGet(uri);
            realWebResource.addHeader("Authorization", "Bearer " + accessToken.getToken());
            HttpResponse response = httpclient.execute((HttpUriRequest)realWebResource);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                switch (httpStatus) {
                    case 401: {
                        String errorMessage = this.getErrorMessage(response, "You are not authorized to access OSIAM. Please make sure your access token is valid");
                        throw new UnauthorizedException(errorMessage);
                    }
                    case 403: {
                        String errorMessage = "Insufficient scope (" + accessToken.getScope() + ") to retrieve the actual User.";
                        throw new ForbiddenException(errorMessage);
                    }
                    case 409: {
                        String errorMessage = this.getErrorMessage(response, "Unable to retrieve the actual User.");
                        throw new ConflictException(errorMessage);
                    }
                }
                String errorMessage = this.getErrorMessage(response, String.format("Unable to setup connection (HTTP Status Code: %d)", httpStatus));
                throw new ConnectionInitializationException(errorMessage);
            }
            InputStream content = response.getEntity().getContent();
            BasicUser basicUser = (BasicUser)new ObjectMapper().readValue(content, BasicUser.class);
            return basicUser;
        }
        catch (IOException | URISyntaxException e) {
            throw new ConnectionInitializationException("Unable to setup connection", e);
        }
    }

    public User getCurrentUser(AccessToken accessToken) {
        BasicUser basicUser = this.getCurrentUserBasic(accessToken);
        return (User)this.getResource(basicUser.getId(), accessToken);
    }

    protected HttpGet getMeWebResource() {
        HttpGet webResource;
        try {
            webResource = new HttpGet(new URI(this.getEndpoint() + "/me"));
            webResource.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (URISyntaxException e) {
            throw new ConnectionInitializationException("Unable to setup connection " + this.getEndpoint() + "is not a valid URI.", e);
        }
        return webResource;
    }

    public List<User> getAllUsers(AccessToken accessToken) {
        return super.getAllResources(accessToken);
    }

    public SCIMSearchResult<User> searchUsers(String queryString, AccessToken accessToken) {
        return super.searchResources(queryString, accessToken);
    }

    public SCIMSearchResult<User> searchUsers(Query query, AccessToken accessToken) {
        return super.searchResources(query, accessToken);
    }

    public void deleteUser(String id, AccessToken accessToken) {
        this.deleteResource(id, accessToken);
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.createResource(user, accessToken);
    }

    public User updateUser(String id, UpdateUser updateUser, AccessToken accessToken) {
        if (updateUser == null) {
            throw new IllegalArgumentException("The given updateUser can't be null.");
        }
        return this.updateResource(id, updateUser.getScimConformUpdateUser(), accessToken);
    }

    public User updateUser(String uuid, User user, AccessToken accessToken) {
        if (user == null) {
            throw new IllegalArgumentException("The given User can't be null.");
        }
        if (uuid == null || uuid.isEmpty()) {
            throw new IllegalArgumentException("The given User ID can't be null or empty.");
        }
        return this.updateResource(uuid, user, accessToken);
    }

    public User replaceUser(User user, AccessToken accessToken) {
        if (user == null) {
            throw new IllegalArgumentException("The given User can't be null.");
        }
        if (user.getId() == null || user.getId().isEmpty()) {
            throw new IllegalArgumentException("The given User ID can't be null or empty.");
        }
        return this.replaceResource(user.getId(), user, accessToken);
    }

    public static class Builder
    extends AbstractOsiamService.Builder<User> {
        public Builder(String endpoint) {
            super(endpoint);
        }

        public OsiamUserService build() {
            return new OsiamUserService(this);
        }
    }
}

