/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.update;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osiam.client.query.metamodel.User_;
import org.osiam.resources.scim.Address;
import org.osiam.resources.scim.Email;
import org.osiam.resources.scim.Entitlement;
import org.osiam.resources.scim.Im;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.Name;
import org.osiam.resources.scim.PhoneNumber;
import org.osiam.resources.scim.Photo;
import org.osiam.resources.scim.Role;
import org.osiam.resources.scim.User;
import org.osiam.resources.scim.X509Certificate;

public final class UpdateUser {
    private User user;

    private UpdateUser(Builder builder) {
        this.user = builder.updateUser.build();
    }

    public User getScimConformUpdateUser() {
        return this.user;
    }

    public static class Builder {
        private String userName;
        private String nickName;
        private String externalId;
        private String locale;
        private String password;
        private String preferredLanguage;
        private String profileUrl;
        private String timezone;
        private String title;
        private Name name;
        private String userType;
        private String displayName;
        private Boolean active;
        private User.Builder updateUser = null;
        private Set<String> deleteFields = new HashSet<String>();
        private List<Email> emails = new ArrayList<Email>();
        private List<Im> ims = new ArrayList<Im>();
        private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
        private List<Address> addresses = new ArrayList<Address>();
        private List<Entitlement> entitlements = new ArrayList<Entitlement>();
        private List<Photo> photos = new ArrayList<Photo>();
        private List<Role> roles = new ArrayList<Role>();
        private List<X509Certificate> certificates = new ArrayList<X509Certificate>();
        private static final String DELETE = "delete";

        public Builder updateUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder addAddress(Address address) {
            this.addresses.add(address);
            return this;
        }

        public Builder deleteAddress(Address address) {
            Address deleteAddress = new Address.Builder(address).setOperation(DELETE).build();
            this.addresses.add(deleteAddress);
            return this;
        }

        public Builder deleteAddresses() {
            this.deleteFields.add("addresses");
            return this;
        }

        public Builder updateAddress(Address oldAttribute, Address newAttribute) {
            this.deleteAddress(oldAttribute);
            this.addAddress(newAttribute);
            return this;
        }

        public Builder deleteNickName() {
            this.deleteFields.add(User_.nickName.toString());
            return this;
        }

        public Builder updateNickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public Builder deleteExternalId() {
            this.deleteFields.add(User_.externalId.toString());
            return this;
        }

        public Builder updateExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder deleteLocal() {
            this.deleteFields.add(User_.locale.toString());
            return this;
        }

        public Builder updateLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder updatePassword(String password) {
            this.password = password;
            return this;
        }

        public Builder deletePreferredLanguage() {
            this.deleteFields.add(User_.preferredLanguage.toString());
            return this;
        }

        public Builder updatePreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public Builder deleteProfileUrl() {
            this.deleteFields.add(User_.profileUrl.toString());
            return this;
        }

        public Builder updateProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public Builder deleteTimezone() {
            this.deleteFields.add(User_.timezone.toString());
            return this;
        }

        public Builder updateTimezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder deleteTitle() {
            this.deleteFields.add(User_.title.toString());
            return this;
        }

        public Builder updateTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder deleteName() {
            this.deleteFields.add("name");
            return this;
        }

        public Builder updateName(Name name) {
            this.name = name;
            return this;
        }

        public Builder deleteUserType() {
            this.deleteFields.add(User_.userType.toString());
            return this;
        }

        public Builder updateUserType(String userType) {
            this.userType = userType;
            return this;
        }

        public Builder deleteDisplayName() {
            this.deleteFields.add(User_.displayName.toString());
            return this;
        }

        public Builder updateDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder deleteEmails() {
            this.deleteFields.add("emails");
            return this;
        }

        public Builder deleteEmail(Email email) {
            Email deleteEmail = new Email.Builder().setValue(email.getValue()).setType(email.getType()).setOperation(DELETE).build();
            this.emails.add(deleteEmail);
            return this;
        }

        public Builder addEmail(Email email) {
            this.emails.add(email);
            return this;
        }

        public Builder updateEmail(Email oldAttribute, Email newAttribute) {
            this.deleteEmail(oldAttribute);
            this.addEmail(newAttribute);
            return this;
        }

        public Builder deleteX509Certificates() {
            this.deleteFields.add("x509Certificates");
            return this;
        }

        public Builder deleteX509Certificate(X509Certificate certificate) {
            X509Certificate deleteCertificates = new X509Certificate.Builder().setValue(certificate.getValue()).setOperation(DELETE).build();
            this.certificates.add(deleteCertificates);
            return this;
        }

        public Builder addX509Certificate(X509Certificate certificate) {
            this.certificates.add(certificate);
            return this;
        }

        public Builder updateX509Certificate(X509Certificate oldAttribute, X509Certificate newAttribute) {
            this.deleteX509Certificate(oldAttribute);
            this.addX509Certificate(newAttribute);
            return this;
        }

        public Builder deleteRoles() {
            this.deleteFields.add("roles");
            return this;
        }

        public Builder deleteRole(Role role) {
            Role deleteRole = new Role.Builder().setValue(role.getValue()).setOperation(DELETE).build();
            this.roles.add(deleteRole);
            return this;
        }

        public Builder deleteRole(String role) {
            Role deleteRole = new Role.Builder().setValue(role).setOperation(DELETE).build();
            this.roles.add(deleteRole);
            return this;
        }

        public Builder addRole(Role role) {
            this.roles.add(role);
            return this;
        }

        public Builder updateRole(Role oldAttribute, Role newAttribute) {
            this.deleteRole(oldAttribute);
            this.addRole(newAttribute);
            return this;
        }

        public Builder deleteIms() {
            this.deleteFields.add("ims");
            return this;
        }

        public Builder deleteIms(Im ims) {
            Im deleteIms = new Im.Builder().setValue(ims.getValue()).setType(ims.getType()).setOperation(DELETE).build();
            this.ims.add(deleteIms);
            return this;
        }

        public Builder addIms(Im ims) {
            this.ims.add(ims);
            return this;
        }

        public Builder updateIms(Im oldAttribute, Im newAttribute) {
            this.deleteIms(oldAttribute);
            this.addIms(newAttribute);
            return this;
        }

        public Builder addPhoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumbers.add(phoneNumber);
            return this;
        }

        public Builder deletePhoneNumber(PhoneNumber phoneNumber) {
            PhoneNumber deletePhoneNumber = new PhoneNumber.Builder().setValue(phoneNumber.getValue()).setType(phoneNumber.getType()).setOperation(DELETE).build();
            this.phoneNumbers.add(deletePhoneNumber);
            return this;
        }

        public Builder deletePhoneNumbers() {
            this.deleteFields.add("phoneNumbers");
            return this;
        }

        public Builder updatePhoneNumber(PhoneNumber oldAttribute, PhoneNumber newAttribute) {
            this.deletePhoneNumber(oldAttribute);
            this.addPhoneNumber(newAttribute);
            return this;
        }

        public Builder addPhoto(Photo photo) {
            this.photos.add(photo);
            return this;
        }

        public Builder deletePhoto(Photo photo) {
            Photo deletePhoto = new Photo.Builder().setValue(photo.getValue()).setType(photo.getType()).setOperation(DELETE).build();
            this.photos.add(deletePhoto);
            return this;
        }

        public Builder deletePhotos() {
            this.deleteFields.add("photos");
            return this;
        }

        public Builder updatePhotos(Photo oldAttribute, Photo newAttribute) {
            this.deletePhoto(oldAttribute);
            this.addPhoto(newAttribute);
            return this;
        }

        public Builder deleteEntitlements() {
            this.deleteFields.add("entitlements");
            return this;
        }

        public Builder deleteEntitlement(Entitlement entitlement) {
            Entitlement deleteEntitlement = new Entitlement.Builder().setValue(entitlement.getValue()).setType(entitlement.getType()).setOperation(DELETE).build();
            this.entitlements.add(deleteEntitlement);
            return this;
        }

        public Builder addEntitlement(Entitlement entitlement) {
            this.entitlements.add(entitlement);
            return this;
        }

        public Builder updateEntitlement(Entitlement oldAttribute, Entitlement newAttribute) {
            this.deleteEntitlement(oldAttribute);
            this.addEntitlement(newAttribute);
            return this;
        }

        public Builder updateActive(boolean active) {
            this.active = active;
            return this;
        }

        public UpdateUser build() {
            this.updateUser = this.userName == null || this.userName.isEmpty() ? new User.Builder() : new User.Builder(this.userName);
            if (this.nickName != null) {
                this.updateUser.setNickName(this.nickName);
            }
            if (this.externalId != null) {
                this.updateUser.setExternalId(this.externalId);
            }
            if (this.locale != null) {
                this.updateUser.setLocale(this.locale);
            }
            if (this.password != null) {
                this.updateUser.setPassword(this.password);
            }
            if (this.preferredLanguage != null) {
                this.updateUser.setPreferredLanguage(this.preferredLanguage);
            }
            if (this.profileUrl != null) {
                this.updateUser.setProfileUrl(this.profileUrl);
            }
            if (this.timezone != null) {
                this.updateUser.setTimezone(this.timezone);
            }
            if (this.title != null) {
                this.updateUser.setTitle(this.title);
            }
            if (this.name != null) {
                this.updateUser.setName(this.name);
            }
            if (this.userType != null) {
                this.updateUser.setUserType(this.userType);
            }
            if (this.displayName != null) {
                this.updateUser.setDisplayName(this.displayName);
            }
            if (this.active != null) {
                this.updateUser.setActive(this.active);
            }
            if (this.deleteFields.size() > 0) {
                Meta meta = new Meta.Builder().setAttributes(this.deleteFields).build();
                this.updateUser.setMeta(meta);
            }
            if (this.emails.size() > 0) {
                this.updateUser.setEmails(this.emails);
            }
            if (this.phoneNumbers.size() > 0) {
                this.updateUser.setPhoneNumbers(this.phoneNumbers);
            }
            if (this.addresses.size() > 0) {
                this.updateUser.setAddresses(this.addresses);
            }
            if (this.entitlements.size() > 0) {
                this.updateUser.setEntitlements(this.entitlements);
            }
            if (this.ims.size() > 0) {
                this.updateUser.setIms(this.ims);
            }
            if (this.photos.size() > 0) {
                this.updateUser.setPhotos(this.photos);
            }
            if (this.roles.size() > 0) {
                this.updateUser.setRoles(this.roles);
            }
            if (this.certificates.size() > 0) {
                this.updateUser.setX509Certificates(this.certificates);
            }
            return new UpdateUser(this);
        }
    }
}

