/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import org.osiam.resources.helper.JsonDateSerializer;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(value={"link", "gender", "timezone", "verified"})
public class BasicUser {
    private String id;
    private String name;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    private String userName;
    private String email;
    private String locale;
    @JsonProperty(value="updated_time")
    @JsonSerialize(using=JsonDateSerializer.class)
    private Date updatedTime;

    private BasicUser() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public String getFirstName() {
        if (this.firstName == null) {
            this.firstName = "";
        }
        return this.firstName;
    }

    public String getLastName() {
        if (this.lastName == null) {
            this.lastName = "";
        }
        return this.lastName;
    }

    public String getEmail() {
        if (this.email == null) {
            this.email = "";
        }
        return this.email;
    }

    public String getUserName() {
        return this.userName;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getLocale() {
        if (this.locale == null) {
            this.locale = "";
        }
        return this.locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.updatedTime == null ? 0 : this.updatedTime.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicUser other = (BasicUser)obj;
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.updatedTime == null ? other.updatedTime != null : !this.updatedTime.equals(other.updatedTime)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

