/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.query;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.osiam.client.exception.InvalidAttributeException;
import org.osiam.client.query.SortOrder;
import org.osiam.client.query.metamodel.Attribute;
import org.osiam.client.query.metamodel.Comparison;
import org.osiam.resources.scim.Email;
import org.osiam.resources.scim.MemberRef;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.Name;
import org.osiam.resources.scim.Resource;

public class Query {
    private static final int DEFAULT_COUNT = 100;
    private static final int DEFAULT_INDEX = 1;
    private static final Pattern INDEX_PATTERN = Pattern.compile("startIndex=(\\d+)&?");
    private static final Pattern COUNT_PATTERN = Pattern.compile("count=(\\d+)&?");
    private final String queryString;
    private Matcher indexMatcher;
    private Matcher countMatcher;

    public Query(String queryString) {
        this.queryString = queryString;
        this.indexMatcher = INDEX_PATTERN.matcher(queryString);
        this.countMatcher = COUNT_PATTERN.matcher(queryString);
    }

    public int getCountPerPage() {
        if (this.queryStringContainsCount()) {
            return Integer.parseInt(this.countMatcher.group(1));
        }
        return 100;
    }

    public int getStartIndex() {
        if (this.queryStringContainsIndex()) {
            return Integer.parseInt(this.indexMatcher.group(1));
        }
        return 1;
    }

    public Query nextPage() {
        String nextIndex = "startIndex=" + (this.getCountPerPage() + this.getStartIndex());
        if (this.queryStringContainsIndex()) {
            return new Query(this.indexMatcher.replaceFirst(nextIndex));
        }
        return new Query(this.queryString + "&" + nextIndex);
    }

    public Query previousPage() {
        if (this.getStartIndex() <= 1) {
            throw new IllegalStateException("StartIndex < 1 is not possible.");
        }
        int newIndex = this.getStartIndex() - this.getCountPerPage();
        if (newIndex < 1) {
            newIndex = 1;
        }
        return new Query(this.indexMatcher.replaceFirst("startIndex=" + newIndex));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Query query = (Query)other;
        return this.queryString.equals(query.queryString);
    }

    public int hashCode() {
        return this.queryString.hashCode();
    }

    public String toString() {
        return this.queryString;
    }

    private boolean queryStringContainsIndex() {
        return this.indexMatcher.find(0);
    }

    private boolean queryStringContainsCount() {
        return this.countMatcher.find(0);
    }

    private static List<String> getAllClassFields(Class<?> clazz) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Field actField : clazz.getDeclaredFields()) {
            fields.add(actField.getName());
        }
        Query.addFieldsFromSuperClass(fields, clazz.getSuperclass());
        return fields;
    }

    private static void addFieldsFromSuperClass(List<String> fields, Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        for (Field actField : clazz.getDeclaredFields()) {
            fields.add(actField.getName());
        }
        Query.addFieldsFromSuperClass(fields, clazz.getSuperclass());
    }

    public static final class Filter {
        private Class<?> clazz;
        private StringBuilder filterBuilder = new StringBuilder();

        public Filter(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Filter(Class<?> clazz, Filter filter) {
            this.clazz = clazz;
            this.filterBuilder.append(" (").append(filter.toString()).append(")");
        }

        public Filter(Class<?> clazz, Comparison comparison) {
            this.clazz = clazz;
            this.query(comparison);
        }

        public Filter and(Comparison comparison) {
            this.filterBuilder.append(" and ");
            return this.query(comparison);
        }

        public Filter and(Filter innerFilter) {
            if (innerFilter.toString().startsWith("not (")) {
                this.filterBuilder.append(" and ").append(innerFilter.toString());
            } else {
                this.filterBuilder.append(" and (").append(innerFilter.toString()).append(")");
            }
            return this;
        }

        public Filter or(Comparison comparison) {
            this.filterBuilder.append(" or ");
            return this.query(comparison);
        }

        public Filter or(Filter innerFilter) {
            if (innerFilter.toString().startsWith("not (")) {
                this.filterBuilder.append(" or ").append(innerFilter.toString());
            } else {
                this.filterBuilder.append(" or (").append(innerFilter.toString()).append(")");
            }
            return this;
        }

        public Filter not(Comparison comparison) {
            this.filterBuilder.append("not (");
            this.query(comparison);
            this.filterBuilder.append(")");
            return this;
        }

        public Filter not(Filter innerFilter) {
            this.filterBuilder.append("not (").append(innerFilter.toString()).append(")");
            return this;
        }

        private boolean isAttributeValid(Comparison comparison) {
            String attribute = comparison.toString().substring(0, comparison.toString().indexOf(" "));
            return Builder.isAttributeValid(attribute, this.clazz);
        }

        public String toString() {
            return this.filterBuilder.toString();
        }

        private Filter query(Comparison comparison) {
            if (!this.isAttributeValid(comparison)) {
                throw new InvalidAttributeException("Querying for this attribute is not supported");
            }
            this.filterBuilder.append(comparison.toString());
            return this;
        }
    }

    public static final class Builder {
        private Class<? extends Resource> clazz;
        private String filter;
        private String sortBy;
        private SortOrder sortOrder;
        private int startIndex = 1;
        private int countPerPage = 100;

        public Builder(Class<? extends Resource> clazz) {
            this.clazz = clazz;
        }

        public Builder setFilter(Filter filter) {
            this.filter = filter.toString();
            return this;
        }

        public Builder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder setSortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder setCountPerPage(int count) {
            this.countPerPage = count;
            return this;
        }

        public Builder setSortBy(Attribute attribute) {
            if (!this.isAttributeValid(attribute.toString())) {
                throw new InvalidAttributeException("Sorting for this attribute is not supported");
            }
            this.sortBy = attribute.toString();
            return this;
        }

        public Query build() {
            StringBuilder builder = new StringBuilder();
            if (this.filter != null) {
                try {
                    this.ensureQueryParamIsSeparated(builder);
                    builder.append("filter=").append(URLEncoder.encode(this.filter, Charsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.sortBy != null) {
                this.ensureQueryParamIsSeparated(builder);
                builder.append("sortBy=").append(this.sortBy);
            }
            if (this.sortOrder != null) {
                this.ensureQueryParamIsSeparated(builder);
                builder.append("sortOrder=").append((Object)this.sortOrder);
            }
            if (this.countPerPage != 100) {
                this.ensureQueryParamIsSeparated(builder);
                builder.append("count=").append(this.countPerPage);
            }
            if (this.startIndex != 1) {
                this.ensureQueryParamIsSeparated(builder);
                builder.append("startIndex=").append(this.startIndex);
            }
            return new Query(builder.toString());
        }

        private void ensureQueryParamIsSeparated(StringBuilder builder) {
            if (builder.length() != 0) {
                builder.append("&");
            }
        }

        private boolean isAttributeValid(String attribute) {
            return Builder.isAttributeValid(attribute, this.clazz);
        }

        private static boolean isAttributeValid(String attribute, Class<?> clazz) {
            String compositeField = "";
            if (attribute.contains(".")) {
                compositeField = attribute.substring(attribute.indexOf(46) + 1);
            }
            if (attribute.startsWith("meta.")) {
                return Builder.isAttributeValid(compositeField, Meta.class);
            }
            if (attribute.startsWith("emails.")) {
                return Builder.isAttributeValid(compositeField, Email.class);
            }
            if (attribute.startsWith("name.")) {
                return Builder.isAttributeValid(compositeField, Name.class);
            }
            if (attribute.startsWith("groups.") || attribute.startsWith("members.")) {
                return Builder.isAttributeValid(compositeField, MemberRef.class);
            }
            List fields = Query.getAllClassFields(clazz);
            return fields.contains(attribute);
        }
    }
}

