/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.osiam.client.AbstractOsiamService;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.NoResultException;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.client.query.QueryResult;
import org.osiam.client.update.UpdateUser;
import org.osiam.resources.scim.User;

public final class OsiamUserService
extends AbstractOsiamService<User> {
    private OsiamUserService(HttpGet userWebResource) {
        super(userWebResource);
    }

    public User getUser(UUID id, AccessToken accessToken) {
        return (User)this.getResource(id, accessToken);
    }

    public User getMe(AccessToken accessToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The given accessToken can't be null.");
        }
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet realWebresource = this.createRealWebResource(accessToken);
            realWebresource.setURI(new URI(this.getUri() + "/me"));
            HttpResponse response = httpclient.execute((HttpUriRequest)realWebresource);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                switch (httpStatus) {
                    case 401: {
                        String errorMessage = this.getErrorMessage(response, "You are not authorized to access OSIAM. Please make sure your access token is valid");
                        throw new UnauthorizedException(errorMessage);
                    }
                    case 404: {
                        String errorMessage = this.getErrorMessage(response, "No User could be found, who holds the supplied access token");
                        throw new NoResultException(errorMessage);
                    }
                }
                String errorMessage = this.getErrorMessage(response, String.format("Unable to setup connection (HTTP Status Code: %d)", httpStatus));
                throw new ConnectionInitializationException(errorMessage);
            }
            InputStream content = response.getEntity().getContent();
            User user = (User)this.mapSingleResourceResponse(content);
            return user;
        }
        catch (IOException | URISyntaxException e) {
            throw new ConnectionInitializationException("Unable to setup connection", e);
        }
    }

    public QueryResult<User> getAllUsers(AccessToken accessToken) {
        return super.getAllResources(accessToken);
    }

    public QueryResult<User> searchUsers(String queryString, AccessToken accessToken) {
        return super.searchResources(queryString, accessToken);
    }

    public QueryResult<User> searchUsers(Query query, AccessToken accessToken) {
        return super.searchResources(query, accessToken);
    }

    public void deleteUser(UUID id, AccessToken accessToken) {
        this.deleteResource(id, accessToken);
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.createResource(user, accessToken);
    }

    public User updateUser(UUID id, UpdateUser updateUser, AccessToken accessToken) {
        if (updateUser == null) {
            throw new IllegalArgumentException("The given updateUser can't be null.");
        }
        return this.updateResource(id, updateUser.getUserToUpdate(), accessToken);
    }

    public static class Builder
    extends AbstractOsiamService.Builder<User> {
        public Builder(String endpoint) {
            super(endpoint);
        }

        public OsiamUserService build() {
            return new OsiamUserService(super.getWebResource());
        }
    }
}

