/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.connector;

import java.util.UUID;
import org.osiam.client.OsiamGroupService;
import org.osiam.client.OsiamUserService;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.AuthService;
import org.osiam.client.oauth.GrantType;
import org.osiam.client.query.Query;
import org.osiam.client.query.QueryResult;
import org.osiam.client.update.UpdateGroup;
import org.osiam.client.update.UpdateUser;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.User;

public final class OsiamConnector {
    private String clientId;
    private String clientSecret;
    private GrantType grantType;
    private String username;
    private String password;
    private String endpoint;
    private AuthService authService;
    private OsiamUserService userService;
    private OsiamGroupService groupService;

    private OsiamConnector(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.grantType = builder.grantType;
        this.username = builder.username;
        this.password = builder.password;
        this.endpoint = builder.endpoint;
    }

    private AuthService authService() {
        if (this.authService == null) {
            AuthService.Builder builder = new AuthService.Builder(this.endpoint);
            if (this.clientId != null) {
                builder = builder.setClientId(this.clientId);
            }
            if (this.clientSecret != null) {
                builder = builder.setClientSecret(this.clientSecret);
            }
            if (this.grantType != null) {
                builder = builder.setGrantType(this.grantType);
            }
            if (this.password != null) {
                builder = builder.setPassword(this.password);
            }
            if (this.username != null) {
                builder = builder.setUsername(this.username);
            }
            this.authService = builder.build();
        }
        return this.authService;
    }

    private OsiamUserService userService() {
        if (this.userService == null) {
            this.userService = new OsiamUserService.Builder(this.endpoint).build();
        }
        return this.userService;
    }

    private OsiamGroupService groupService() {
        if (this.groupService == null) {
            this.groupService = new OsiamGroupService.Builder(this.endpoint).build();
        }
        return this.groupService;
    }

    public User getUser(UUID id, AccessToken accessToken) {
        return this.userService().getUser(id, accessToken);
    }

    public QueryResult<User> getAllUsers(AccessToken accessToken) {
        return this.userService().getAllUsers(accessToken);
    }

    public QueryResult<User> searchUsers(String queryString, AccessToken accessToken) {
        return this.userService().searchUsers(queryString, accessToken);
    }

    public QueryResult<User> searchUsers(Query query, AccessToken accessToken) {
        return this.userService().searchUsers(query, accessToken);
    }

    public User getMe(AccessToken accessToken) {
        return this.userService().getMe(accessToken);
    }

    public Group getGroup(UUID id, AccessToken accessToken) {
        return this.groupService().getGroup(id, accessToken);
    }

    public QueryResult<Group> getAllGroups(AccessToken accessToken) {
        return this.groupService().getAllGroups(accessToken);
    }

    public QueryResult<Group> searchGroups(String queryString, AccessToken accessToken) {
        return this.groupService().searchGroups(queryString, accessToken);
    }

    public QueryResult<Group> searchGroups(Query query, AccessToken accessToken) {
        return this.groupService().searchGroups(query, accessToken);
    }

    public AccessToken retrieveAccessToken() {
        return this.authService().retrieveAccessToken();
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.userService().createUser(user, accessToken);
    }

    public Group createGroup(Group group, AccessToken accessToken) {
        return this.groupService().createGroup(group, accessToken);
    }

    public void deleteGroup(UUID id, AccessToken accessToken) {
        this.groupService().deleteGroup(id, accessToken);
    }

    public void deleteUser(UUID id, AccessToken accessToken) {
        this.userService().deleteUser(id, accessToken);
    }

    public User updateUser(UUID id, UpdateUser updateUser, AccessToken accessToken) {
        return this.userService.updateUser(id, updateUser, accessToken);
    }

    public Group updateGroup(UUID id, UpdateGroup updateGroup, AccessToken accessToken) {
        return this.groupService.updateGroup(id, updateGroup, accessToken);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private GrantType grantType;
        private String username;
        private String password;
        private String endpoint;

        public Builder(String endpoint) {
            this.endpoint = endpoint;
        }

        public Builder setGrantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public OsiamConnector build() {
            return new OsiamConnector(this);
        }
    }
}

