/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jackson.map.ObjectMapper;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.GrantType;

public final class AuthService {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final HttpPost post;
    private final String clientId;
    private final String endpoint;

    private AuthService(Builder builder) {
        this.post = new HttpPost(builder.endpoint);
        this.post.setHeaders(builder.headers);
        this.post.setEntity(builder.body);
        this.clientId = builder.clientId;
        this.endpoint = builder.endpoint;
    }

    private HttpResponse performRequest() {
        HttpResponse response;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            response = defaultHttpClient.execute((HttpUriRequest)this.post);
        }
        catch (IOException e) {
            throw new ConnectionInitializationException("Unable to perform Request ", e);
        }
        return response;
    }

    public AccessToken retrieveAccessToken() {
        AccessToken accessToken;
        HttpResponse response = this.performRequest();
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            switch (status) {
                case 400: {
                    throw new ConnectionInitializationException("Unable to create Connection. Please make sure that you have the correct grants.");
                }
                case 401: {
                    StringBuilder errorMessage = new StringBuilder("You are not authorized to directly retrieve a access token.");
                    if (response.toString().contains(this.clientId + " not found")) {
                        errorMessage.append(" Unknown client-id");
                    } else {
                        errorMessage.append(" Invalid client secret");
                    }
                    throw new UnauthorizedException(errorMessage.toString());
                }
                case 404: {
                    throw new ConnectionInitializationException("Unable to find the given OSIAM service (" + this.endpoint + ")");
                }
            }
            throw new ConnectionInitializationException(String.format("Unable to setup connection (HTTP Status Code: %d)", status));
        }
        try {
            InputStream content = response.getEntity().getContent();
            ObjectMapper mapper = new ObjectMapper();
            accessToken = (AccessToken)mapper.readValue(content, AccessToken.class);
        }
        catch (IOException e) {
            throw new ConnectionInitializationException("Unable to retrieve access token: IOException", e);
        }
        return accessToken;
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private GrantType grantType;
        private Header[] headers;
        private static final String DEFAULT_SCOPE = "GET POST PUT PATCH DELETE";
        private Map<String, String> requestParameters = new HashMap<String, String>();
        private String endpoint;
        private HttpEntity body;

        public Builder(String endpoint) {
            this.requestParameters.put("scope", DEFAULT_SCOPE);
            this.endpoint = endpoint + "/oauth/token";
        }

        public Builder setGrantType(GrantType grantType) {
            if (!grantType.equals((Object)GrantType.PASSWORD)) {
                throw new UnsupportedOperationException(grantType.getUrlParam() + " grant type not supported at this time");
            }
            this.grantType = grantType;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setUsername(String username) {
            this.requestParameters.put("username", username);
            return this;
        }

        public Builder setPassword(String password) {
            this.requestParameters.put("password", password);
            return this;
        }

        public AuthService build() {
            if (this.clientId == null || this.clientSecret == null) {
                throw new ConnectionInitializationException("The provided client credentials are incomplete.");
            }
            if (this.grantType == null) {
                throw new ConnectionInitializationException("The grant type is not set.");
            }
            if (!(!this.grantType.equals((Object)GrantType.PASSWORD) || this.requestParameters.containsKey("username") && this.requestParameters.containsKey("password"))) {
                throw new ConnectionInitializationException("The grant type 'password' requires username and password");
            }
            this.requestParameters.put("grant_type", this.grantType.getUrlParam());
            this.body = this.buildBody();
            this.headers = this.buildHead();
            return new AuthService(this);
        }

        private String encodeClientCredentials(String clientId, String clientSecret) {
            String clientCredentials = clientId + ":" + clientSecret;
            return new String(Base64.encodeBase64((byte[])clientCredentials.getBytes(CHARSET)), CHARSET);
        }

        private Header[] buildHead() {
            String authHeaderValue = "Basic " + this.encodeClientCredentials(this.clientId, this.clientSecret);
            BasicHeader authHeader = new BasicHeader("Authorization", authHeaderValue);
            return new Header[]{authHeader};
        }

        private HttpEntity buildBody() {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            for (String key : this.requestParameters.keySet()) {
                nameValuePairs.add(new BasicNameValuePair(key, this.requestParameters.get(key)));
            }
            try {
                return new UrlEncodedFormEntity(nameValuePairs);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConnectionInitializationException("Unable to Build Request in this encoding.", e);
            }
        }
    }
}

