/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.query.metamodel;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osiam.client.query.metamodel.Attribute;
import org.osiam.client.query.metamodel.Comparison;

public class DateAttribute
extends Attribute {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");

    DateAttribute(String value) {
        this.value = value;
    }

    public Comparison equalTo(DateTime filter) {
        return new Comparison(this.value + " eq \"" + DATE_FORMAT.print((ReadableInstant)filter) + "\"");
    }

    public Comparison present() {
        return new Comparison(this.value + " pr ");
    }

    public Comparison greaterThan(DateTime filter) {
        return new Comparison(this.value + " gt \"" + DATE_FORMAT.print((ReadableInstant)filter) + "\"");
    }

    public Comparison greaterEquals(DateTime filter) {
        return new Comparison(this.value + " ge \"" + DATE_FORMAT.print((ReadableInstant)filter) + "\"");
    }

    public Comparison lessThan(DateTime filter) {
        return new Comparison(this.value + " lt \"" + DATE_FORMAT.print((ReadableInstant)filter) + "\"");
    }

    public Comparison lessEquals(DateTime filter) {
        return new Comparison(this.value + " le \"" + DATE_FORMAT.print((ReadableInstant)filter) + "\"");
    }
}

