/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.update;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.osiam.client.query.metamodel.User_;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.MultiValuedAttribute;

public class UpdateGroup {
    private Group group;

    private UpdateGroup(Builder builder) {
        this.group = builder.updateGroup.build();
    }

    public Group getGroupToUpdate() {
        return this.group;
    }

    public static class Builder {
        private Group.Builder updateGroup = null;
        private Set<String> deleteFields = new HashSet<String>();
        private static final String DELETE = "delete";
        private Set<MultiValuedAttribute> members = new HashSet<MultiValuedAttribute>();

        public Builder() {
            this.updateGroup = new Group.Builder();
        }

        public Builder deleteExternalId() {
            this.deleteFields.add(User_.externalId.toString());
            return this;
        }

        public Builder updateExternalId(String externalID) {
            this.updateGroup.setExternalId(externalID);
            return this;
        }

        public Builder updateDisplayName(String displayName) {
            this.updateGroup.setDisplayName(displayName);
            return this;
        }

        public Builder deleteMembers() {
            this.deleteFields.add("members");
            return this;
        }

        public Builder deleteMember(UUID memberId) {
            MultiValuedAttribute deleteGroup = new MultiValuedAttribute.Builder().setValue((Object)memberId.toString()).setOperation(DELETE).build();
            this.members.add(deleteGroup);
            return this;
        }

        public Builder addMember(UUID memberId) {
            MultiValuedAttribute newGroup = new MultiValuedAttribute.Builder().setValue((Object)memberId.toString()).build();
            this.members.add(newGroup);
            return this;
        }

        public UpdateGroup build() {
            if (this.deleteFields.size() > 0) {
                Meta meta = new Meta.Builder().setAttributes(this.deleteFields).build();
                this.updateGroup.setMeta(meta);
            }
            if (this.members.size() > 0) {
                this.updateGroup.setMembers(this.members);
            }
            return new UpdateGroup(this);
        }
    }
}

