/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.update;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.osiam.client.query.metamodel.User_;
import org.osiam.resources.scim.Address;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.MultiValuedAttribute;
import org.osiam.resources.scim.Name;
import org.osiam.resources.scim.User;

public final class UpdateUser {
    private User user;

    private UpdateUser(Builder builder) {
        this.user = builder.updateUser.build();
    }

    public User getUserToUpdate() {
        return this.user;
    }

    public static class Builder {
        private User.Builder updateUser = null;
        private Set<String> deleteFields = new HashSet<String>();
        private List<MultiValuedAttribute> emails = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> ims = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> groups = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> phoneNumbers = new ArrayList<MultiValuedAttribute>();
        private List<Address> addresses = new ArrayList<Address>();
        private List<MultiValuedAttribute> entitlements = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> photos = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> roles = new ArrayList<MultiValuedAttribute>();
        private List<MultiValuedAttribute> certificates = new ArrayList<MultiValuedAttribute>();
        private static final String DELETE = "delete";

        public Builder() {
            this.updateUser = new User.Builder();
        }

        public Builder(String userName) {
            this.updateUser = new User.Builder(userName);
        }

        public Builder addAddress(Address address) {
            this.addresses.add(address);
            return this;
        }

        public Builder deleteAddress(Address address) {
            return this;
        }

        public Builder deleteAddresses() {
            this.deleteFields.add("addresses");
            return this;
        }

        public Builder deleteNickName() {
            this.deleteFields.add(User_.nickName.toString());
            return this;
        }

        public Builder updateNickName(String nickName) {
            this.updateUser.setNickName(nickName);
            return this;
        }

        public Builder deleteExternalId() {
            this.deleteFields.add(User_.externalId.toString());
            return this;
        }

        public Builder updateExternalId(String externalID) {
            this.updateUser.setExternalId(externalID);
            return this;
        }

        public Builder deleteLocal() {
            this.deleteFields.add(User_.locale.toString());
            return this;
        }

        public Builder updateLocal(String locale) {
            this.updateUser.setLocale(locale);
            return this;
        }

        public Builder updatePassword(String password) {
            this.updateUser.setPassword(password);
            return this;
        }

        public Builder deletePreferredLanguage() {
            this.deleteFields.add(User_.preferredLanguage.toString());
            return this;
        }

        public Builder updatePreferredLanguage(String preferredLanguage) {
            this.updateUser.setPreferredLanguage(preferredLanguage);
            return this;
        }

        public Builder deleteProfileUrl() {
            this.deleteFields.add(User_.profileUrl.toString());
            return this;
        }

        public Builder updateProfileUrl(String profileUrl) {
            this.updateUser.setProfileUrl(profileUrl);
            return this;
        }

        public Builder deleteTimezone() {
            this.deleteFields.add(User_.timezone.toString());
            return this;
        }

        public Builder updateTimezone(String timezone) {
            this.updateUser.setTimezone(timezone);
            return this;
        }

        public Builder deleteTitle() {
            this.deleteFields.add(User_.title.toString());
            return this;
        }

        public Builder updateTitle(String title) {
            this.updateUser.setTitle(title);
            return this;
        }

        public Builder deleteName() {
            this.deleteFields.add("name");
            return this;
        }

        public Builder updateName(Name name) {
            this.updateUser.setName(name);
            return this;
        }

        public Builder deleteUserType() {
            this.deleteFields.add(User_.userType.toString());
            return this;
        }

        public Builder updateUserType(String userType) {
            this.updateUser.setUserType(userType);
            return this;
        }

        public Builder deleteDisplayName() {
            this.deleteFields.add(User_.displayName.toString());
            return this;
        }

        public Builder updateDisplayName(String displayName) {
            this.updateUser.setDisplayName(displayName);
            return this;
        }

        public Builder deleteEmails() {
            this.deleteFields.add("emails");
            return this;
        }

        public Builder deleteEmail(String email) {
            MultiValuedAttribute deleteEmail = new MultiValuedAttribute.Builder().setValue((Object)email).setOperation(DELETE).build();
            this.emails.add(deleteEmail);
            return this;
        }

        public Builder addOrUpdateEmail(MultiValuedAttribute email) {
            this.emails.add(email);
            return this;
        }

        public Builder deleteX509Certificates() {
            this.deleteFields.add("x509Certificates");
            return this;
        }

        public Builder deleteX509Certificate(String certificate) {
            MultiValuedAttribute deleteCertificates = new MultiValuedAttribute.Builder().setValue((Object)certificate).setOperation(DELETE).build();
            this.certificates.add(deleteCertificates);
            return this;
        }

        public Builder addOrUpdateX509Certificate(MultiValuedAttribute certificate) {
            this.certificates.add(certificate);
            return this;
        }

        public Builder deleteRoles() {
            this.deleteFields.add("roles");
            return this;
        }

        public Builder deleteRole(String role) {
            MultiValuedAttribute deleteRole = new MultiValuedAttribute.Builder().setValue((Object)role).setOperation(DELETE).build();
            this.roles.add(deleteRole);
            return this;
        }

        public Builder addOrUpdateRole(MultiValuedAttribute role) {
            this.roles.add(role);
            return this;
        }

        public Builder deleteIms() {
            this.deleteFields.add("ims");
            return this;
        }

        public Builder deleteIms(String ims) {
            MultiValuedAttribute deleteIms = new MultiValuedAttribute.Builder().setValue((Object)ims).setOperation(DELETE).build();
            this.ims.add(deleteIms);
            return this;
        }

        public Builder addOrUpdatesIms(MultiValuedAttribute ims) {
            this.ims.add(ims);
            return this;
        }

        public Builder addOrUpdatesPhoneNumber(MultiValuedAttribute phoneNumber) {
            this.phoneNumbers.add(phoneNumber);
            return this;
        }

        public Builder deletePhoneNumber(String phoneNumber) {
            MultiValuedAttribute deletePhoneNumber = new MultiValuedAttribute.Builder().setValue((Object)phoneNumber).setOperation(DELETE).build();
            this.phoneNumbers.add(deletePhoneNumber);
            return this;
        }

        public Builder deletePhoneNumbers() {
            this.deleteFields.add("phonenumbers");
            return this;
        }

        public Builder addOrUpdatesPhoto(MultiValuedAttribute photo) {
            this.photos.add(photo);
            return this;
        }

        public Builder deletePhoto(String photoUri) {
            MultiValuedAttribute deletePhoto = new MultiValuedAttribute.Builder().setValue((Object)photoUri).setOperation(DELETE).build();
            this.photos.add(deletePhoto);
            return this;
        }

        public Builder deletePhotos() {
            this.deleteFields.add("photos");
            return this;
        }

        public Builder deleteEntitlements() {
            this.deleteFields.add("entitlements");
            return this;
        }

        public Builder deleteEntitlement(String entitlement) {
            MultiValuedAttribute deleteEntitlement = new MultiValuedAttribute.Builder().setValue((Object)entitlement).setOperation(DELETE).build();
            this.entitlements.add(deleteEntitlement);
            return this;
        }

        public Builder addOrUpdatesEntitlement(MultiValuedAttribute entitlement) {
            this.entitlements.add(entitlement);
            return this;
        }

        public Builder deleteGroups() {
            this.deleteFields.add("groups");
            return this;
        }

        public Builder deleteGroup(UUID groupId) {
            MultiValuedAttribute deleteGroup = new MultiValuedAttribute.Builder().setValue((Object)groupId.toString()).setOperation(DELETE).build();
            this.groups.add(deleteGroup);
            return this;
        }

        public Builder addOrUpdateGroupMembership(MultiValuedAttribute groupMembership) {
            this.groups.add(groupMembership);
            return this;
        }

        public Builder setActive(boolean active) {
            this.updateUser.setActive(Boolean.valueOf(active));
            return this;
        }

        public UpdateUser build() {
            if (this.deleteFields.size() > 0) {
                Meta meta = new Meta.Builder().setAttributes(this.deleteFields).build();
                this.updateUser.setMeta(meta);
            }
            if (this.emails.size() > 0) {
                this.updateUser.setEmails(this.emails);
            }
            if (this.phoneNumbers.size() > 0) {
                this.updateUser.setPhoneNumbers(this.phoneNumbers);
            }
            if (this.addresses.size() > 0) {
                this.updateUser.setAddresses(this.addresses);
            }
            if (this.entitlements.size() > 0) {
                this.updateUser.setEntitlements(this.entitlements);
            }
            if (this.ims.size() > 0) {
                this.updateUser.setIms(this.ims);
            }
            if (this.photos.size() > 0) {
                this.updateUser.setPhotos(this.photos);
            }
            if (this.roles.size() > 0) {
                this.updateUser.setRoles(this.roles);
            }
            if (this.certificates.size() > 0) {
                this.updateUser.setX509Certificates(this.certificates);
            }
            return new UpdateUser(this);
        }
    }
}

