/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client.oauth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.osiam.client.helper.ScopeDeserializer;
import org.osiam.client.helper.ScopeSerializer;
import org.osiam.client.oauth.Scope;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessToken {
    @JsonProperty(value="access_token")
    private String token;
    @JsonProperty(value="expires_at")
    private Date expiresAt;
    @JsonSerialize(using=ScopeSerializer.class)
    @JsonDeserialize(using=ScopeDeserializer.class)
    @JsonProperty(value="scope")
    private Set<Scope> scopes = new HashSet<Scope>();
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="refresh_token_expires_at")
    private Date refreshTokenExpiresAt;
    @JsonProperty(value="token_type")
    private String type;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="user_name")
    private String userName;

    private AccessToken() {
    }

    private AccessToken(Builder builder) {
        this.token = builder.token;
        this.expiresAt = builder.expiresAt;
        this.scopes = builder.scopes;
        this.refreshToken = builder.refreshToken;
        this.refreshTokenExpiresAt = builder.refreshTokenExpiresAt;
        this.type = builder.type;
        this.clientId = builder.clientId;
        this.userId = builder.userId;
        this.userName = builder.userName;
    }

    public String getToken() {
        return this.token;
    }

    public Date getExpiresAt() {
        if (this.expiresAt != null) {
            return new Date(this.expiresAt.getTime());
        }
        return null;
    }

    public boolean isExpired() {
        return this.expiresAt.before(new Date());
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Date getRefreshTokenExpiresAt() {
        if (this.refreshTokenExpiresAt != null) {
            return new Date(this.refreshTokenExpiresAt.getTime());
        }
        return null;
    }

    public boolean isRefreshTokenExpired() {
        return this.refreshTokenExpiresAt.before(new Date());
    }

    public String getType() {
        return this.type;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isClientOnly() {
        return Strings.isNullOrEmpty((String)this.userName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)obj;
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    public String toString() {
        return "AccessToken [token=" + this.token + ", expiresAt=" + this.expiresAt + ", scopes=" + this.scopes + ", refreshTokenId=" + this.refreshToken + ", refreshTokenExpiresAt=" + this.refreshTokenExpiresAt + ", clientId=" + this.clientId + ", userId=" + this.userId + ", userName=" + this.userName + "]";
    }

    public static class Builder {
        private String token;
        private Date expiresAt = new Date(Long.MIN_VALUE);
        private Set<Scope> scopes = new HashSet<Scope>();
        private String refreshToken = "";
        private Date refreshTokenExpiresAt = new Date(Long.MIN_VALUE);
        private String type = "";
        private String clientId = "";
        private String userId = "";
        private String userName = "";

        public Builder(String token) {
            this.token = token;
            if (Strings.isNullOrEmpty((String)token)) {
                throw new IllegalArgumentException("token must not be null or empty.");
            }
        }

        public Builder setExpiresAt(Date expireDate) {
            if (expireDate != null) {
                this.expiresAt = new Date(expireDate.getTime());
            }
            return this;
        }

        public Builder addScope(Scope scope) {
            this.scopes.add(scope);
            return this;
        }

        public Builder addScopes(Set<Scope> scopes) {
            for (Scope scope : scopes) {
                this.addScope(scope);
            }
            return this;
        }

        public Builder setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder setRefreshTokenExpiresAt(Date expireDate) {
            if (expireDate != null) {
                this.refreshTokenExpiresAt = new Date(expireDate.getTime());
            }
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public AccessToken build() {
            return new AccessToken(this);
        }
    }
}

