/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.jersey.model.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osiam.bundled.javax.annotation.Priority;
import org.osiam.bundled.javax.ws.rs.ConstrainedTo;
import org.osiam.bundled.javax.ws.rs.RuntimeType;
import org.osiam.bundled.javax.ws.rs.core.Configuration;
import org.osiam.bundled.javax.ws.rs.core.Feature;
import org.osiam.bundled.javax.ws.rs.core.FeatureContext;
import org.osiam.bundled.jersey.repackaged.com.google.common.base.Function;
import org.osiam.bundled.jersey.repackaged.com.google.common.base.Predicate;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.Collections2;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.Lists;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.Sets;
import org.osiam.bundled.org.glassfish.hk2.api.DynamicConfiguration;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceLocator;
import org.osiam.bundled.org.glassfish.hk2.utilities.Binder;
import org.osiam.bundled.org.glassfish.jersey.ExtendedConfig;
import org.osiam.bundled.org.glassfish.jersey.internal.LocalizationMessages;
import org.osiam.bundled.org.glassfish.jersey.internal.ServiceFinder;
import org.osiam.bundled.org.glassfish.jersey.internal.inject.Injections;
import org.osiam.bundled.org.glassfish.jersey.internal.inject.Providers;
import org.osiam.bundled.org.glassfish.jersey.internal.spi.AutoDiscoverable;
import org.osiam.bundled.org.glassfish.jersey.internal.spi.ForcedAutoDiscoverable;
import org.osiam.bundled.org.glassfish.jersey.internal.util.PropertiesHelper;
import org.osiam.bundled.org.glassfish.jersey.model.ContractProvider;
import org.osiam.bundled.org.glassfish.jersey.model.internal.ComponentBag;
import org.osiam.bundled.org.glassfish.jersey.model.internal.FeatureContextWrapper;
import org.osiam.bundled.org.glassfish.jersey.process.Inflector;

public class CommonConfig
implements FeatureContext,
ExtendedConfig {
    private static final Logger LOGGER = Logger.getLogger(CommonConfig.class.getName());
    private static final Function<Object, Binder> CAST_TO_BINDER = new Function<Object, Binder>(){

        @Override
        public Binder apply(Object input) {
            return (Binder)Binder.class.cast(input);
        }
    };
    private final RuntimeType type;
    private final Map<String, Object> properties;
    private final Map<String, Object> immutablePropertiesView;
    private final Collection<String> immutablePropertyNames;
    private final ComponentBag componentBag;
    private final List<FeatureRegistration> newFeatureRegistrations;
    private final Set<Class<? extends Feature>> enabledFeatureClasses;
    private final Set<Feature> enabledFeatures;
    private boolean disableMetaProviderConfiguration;

    public CommonConfig(RuntimeType type, Predicate<ContractProvider> registrationStrategy) {
        this.type = type;
        this.properties = new HashMap<String, Object>();
        this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
        this.immutablePropertyNames = Collections.unmodifiableCollection(this.properties.keySet());
        this.componentBag = ComponentBag.newInstance(registrationStrategy);
        this.newFeatureRegistrations = new LinkedList<FeatureRegistration>();
        this.enabledFeatureClasses = Sets.newIdentityHashSet();
        this.enabledFeatures = Sets.newHashSet();
        this.disableMetaProviderConfiguration = false;
    }

    public CommonConfig(CommonConfig config) {
        this.type = config.type;
        this.properties = new HashMap<String, Object>(config.properties.size());
        this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
        this.immutablePropertyNames = Collections.unmodifiableCollection(this.properties.keySet());
        this.componentBag = config.componentBag.copy();
        this.newFeatureRegistrations = Lists.newLinkedList();
        this.enabledFeatureClasses = Sets.newIdentityHashSet();
        this.enabledFeatures = Sets.newHashSet();
        this.copy(config, false);
    }

    private void copy(CommonConfig config, boolean loadComponentBag) {
        this.properties.clear();
        this.properties.putAll(config.properties);
        this.newFeatureRegistrations.clear();
        this.newFeatureRegistrations.addAll(config.newFeatureRegistrations);
        this.enabledFeatureClasses.clear();
        this.enabledFeatureClasses.addAll(config.enabledFeatureClasses);
        this.enabledFeatures.clear();
        this.enabledFeatures.addAll(config.enabledFeatures);
        this.disableMetaProviderConfiguration = config.disableMetaProviderConfiguration;
        if (loadComponentBag) {
            this.componentBag.loadFrom(config.componentBag);
        }
    }

    @Override
    public ExtendedConfig getConfiguration() {
        return this;
    }

    @Override
    public RuntimeType getRuntimeType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.immutablePropertiesView;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean isProperty(String name) {
        return PropertiesHelper.isProperty(this.getProperty(name));
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.immutablePropertyNames;
    }

    @Override
    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.enabledFeatureClasses.contains(featureClass);
    }

    @Override
    public boolean isEnabled(Feature feature) {
        return this.enabledFeatures.contains(feature);
    }

    @Override
    public boolean isRegistered(Object component) {
        return this.componentBag.getInstances().contains(component);
    }

    @Override
    public boolean isRegistered(Class<?> componentClass) {
        return this.componentBag.getRegistrations().contains(componentClass);
    }

    @Override
    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        ContractProvider model = this.componentBag.getModel(componentClass);
        return model == null ? Collections.emptyMap() : model.getContractMap();
    }

    @Override
    public Set<Class<?>> getClasses() {
        return this.componentBag.getClasses();
    }

    @Override
    public Set<Object> getInstances() {
        return this.componentBag.getInstances();
    }

    public final ComponentBag getComponentBag() {
        return this.componentBag;
    }

    protected Inflector<ContractProvider.Builder, ContractProvider> getModelEnhancer(Class<?> componentClass) {
        return ComponentBag.AS_IS;
    }

    public CommonConfig setProperties(Map<String, ?> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public CommonConfig addProperties(Map<String, ?> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    @Override
    public CommonConfig property(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    @Override
    public CommonConfig register(Class<?> componentClass) {
        this.checkComponentClassNotNull(componentClass);
        if (this.componentBag.register(componentClass, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    @Override
    public CommonConfig register(Class<?> componentClass, int bindingPriority) {
        this.checkComponentClassNotNull(componentClass);
        if (this.componentBag.register(componentClass, bindingPriority, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    @Override
    public CommonConfig register(Class<?> componentClass, Class<?> ... contracts) {
        this.checkComponentClassNotNull(componentClass);
        if (contracts == null || contracts.length == 0) {
            LOGGER.warning(LocalizationMessages.COMPONENT_CONTRACTS_EMPTY_OR_NULL(componentClass));
            return this;
        }
        if (this.componentBag.register(componentClass, this.asNewIdentitySet(contracts), this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    @Override
    public CommonConfig register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.checkComponentClassNotNull(componentClass);
        if (this.componentBag.register(componentClass, contracts, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    @Override
    public CommonConfig register(Object component) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (this.componentBag.register(component, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    @Override
    public CommonConfig register(Object component, int bindingPriority) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (this.componentBag.register(component, bindingPriority, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    @Override
    public CommonConfig register(Object component, Class<?> ... contracts) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (contracts == null || contracts.length == 0) {
            LOGGER.warning(LocalizationMessages.COMPONENT_CONTRACTS_EMPTY_OR_NULL(componentClass));
            return this;
        }
        if (this.componentBag.register(component, this.asNewIdentitySet(contracts), this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    @Override
    public CommonConfig register(Object component, Map<Class<?>, Integer> contracts) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (this.componentBag.register(component, contracts, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    private void processFeatureRegistration(Object component, Class<?> componentClass) {
        ContractProvider model = this.componentBag.getModel(componentClass);
        if (model.getContracts().contains(Feature.class)) {
            FeatureRegistration registration = component != null ? new FeatureRegistration((Feature)component) : new FeatureRegistration(componentClass);
            this.newFeatureRegistrations.add(registration);
        }
    }

    public CommonConfig loadFrom(Configuration config) {
        if (config instanceof CommonConfig) {
            CommonConfig commonConfig = (CommonConfig)config;
            this.copy(commonConfig, true);
            this.disableMetaProviderConfiguration = !commonConfig.enabledFeatureClasses.isEmpty();
        } else {
            this.setProperties(config.getProperties());
            this.enabledFeatures.clear();
            this.enabledFeatureClasses.clear();
            this.componentBag.clear();
            this.resetRegistrations();
            for (Class<?> clazz : config.getClasses()) {
                if (Feature.class.isAssignableFrom(clazz) && config.isEnabled(clazz)) {
                    this.disableMetaProviderConfiguration = true;
                }
                this.register((Class)clazz, (Map)config.getContracts(clazz));
            }
            for (Object instance : config.getInstances()) {
                if (instance instanceof Feature && config.isEnabled((Feature)instance)) {
                    this.disableMetaProviderConfiguration = true;
                }
                this.register(instance, (Map)config.getContracts(instance.getClass()));
            }
        }
        return this;
    }

    private Set<Class<?>> asNewIdentitySet(Class<?> ... contracts) {
        Set<Class<?>> result = Sets.newIdentityHashSet();
        result.addAll(Arrays.asList(contracts));
        return result;
    }

    private void checkProviderNotNull(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException(LocalizationMessages.COMPONENT_CANNOT_BE_NULL());
        }
    }

    private void checkComponentClassNotNull(Class<?> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException(LocalizationMessages.COMPONENT_CLASS_CANNOT_BE_NULL());
        }
    }

    public void configureAutoDiscoverableProviders(ServiceLocator locator, boolean forcedOnly) {
        if (!this.disableMetaProviderConfiguration) {
            TreeSet<AutoDiscoverable> providers = new TreeSet<AutoDiscoverable>(new Comparator<AutoDiscoverable>(){

                @Override
                public int compare(AutoDiscoverable o1, AutoDiscoverable o2) {
                    int p1 = o1.getClass().isAnnotationPresent(Priority.class) ? o1.getClass().getAnnotation(Priority.class).value() : 5000;
                    int p2 = o2.getClass().isAnnotationPresent(Priority.class) ? o2.getClass().getAnnotation(Priority.class).value() : 5000;
                    return p1 < p2 || p1 == p2 ? -1 : 1;
                }
            });
            LinkedList<ForcedAutoDiscoverable> forcedAutoDiscroverables = new LinkedList<ForcedAutoDiscoverable>();
            for (Class<ForcedAutoDiscoverable> forcedADType : ServiceFinder.find(ForcedAutoDiscoverable.class, true).toClassArray()) {
                forcedAutoDiscroverables.add(locator.createAndInitialize(forcedADType));
            }
            providers.addAll(forcedAutoDiscroverables);
            if (!forcedOnly) {
                providers.addAll(Providers.getProviders(locator, AutoDiscoverable.class));
            }
            for (AutoDiscoverable autoDiscoverable : providers) {
                ConstrainedTo constrainedTo = autoDiscoverable.getClass().getAnnotation(ConstrainedTo.class);
                if (constrainedTo != null && !this.type.equals((Object)constrainedTo.value())) continue;
                try {
                    autoDiscoverable.configure(this);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, LocalizationMessages.AUTODISCOVERABLE_CONFIGURATION_FAILED(autoDiscoverable.getClass()), e);
                }
            }
        }
    }

    public void configureMetaProviders(ServiceLocator locator) {
        Set<Binder> configuredBinders = this.configureBinders(locator, Collections.<Binder>emptySet());
        if (!this.disableMetaProviderConfiguration) {
            this.configureFeatures(locator, new HashSet<FeatureRegistration>(), this.resetRegistrations());
            this.configureBinders(locator, configuredBinders);
        }
    }

    private Set<Binder> configureBinders(ServiceLocator locator, Set<Binder> configured) {
        Set<Binder> allConfigured = Sets.newIdentityHashSet();
        allConfigured.addAll(configured);
        Collection<Binder> binders = this.getBinders(configured);
        if (!binders.isEmpty()) {
            DynamicConfiguration dc = Injections.getConfiguration(locator);
            for (Binder binder : binders) {
                binder.bind(dc);
                allConfigured.add(binder);
            }
            dc.commit();
        }
        return allConfigured;
    }

    private Collection<Binder> getBinders(final Set<Binder> configured) {
        return Collections2.filter(Collections2.transform(this.componentBag.getInstances(ComponentBag.BINDERS_ONLY), CAST_TO_BINDER), new Predicate<Binder>(){

            @Override
            public boolean apply(Binder binder) {
                return !configured.contains(binder);
            }
        });
    }

    private void configureFeatures(ServiceLocator locator, Set<FeatureRegistration> processed, List<FeatureRegistration> unprocessed) {
        FeatureContextWrapper featureContextWrapper = null;
        for (FeatureRegistration registration : unprocessed) {
            boolean success;
            if (processed.contains(registration)) {
                LOGGER.config(LocalizationMessages.FEATURE_HAS_ALREADY_BEEN_PROCESSED(registration.getFeatureClass()));
                continue;
            }
            Feature feature = registration.getFeature();
            if (feature == null) {
                feature = locator.createAndInitialize(registration.getFeatureClass());
            } else if (!RuntimeType.CLIENT.equals((Object)this.type)) {
                locator.inject(feature);
            }
            if (this.enabledFeatures.contains(feature)) {
                LOGGER.config(LocalizationMessages.FEATURE_HAS_ALREADY_BEEN_PROCESSED(feature));
                continue;
            }
            if (featureContextWrapper == null) {
                featureContextWrapper = new FeatureContextWrapper(this, locator);
            }
            if (!(success = feature.configure(featureContextWrapper))) continue;
            processed.add(registration);
            this.configureFeatures(locator, processed, this.resetRegistrations());
            this.enabledFeatureClasses.add(registration.getFeatureClass());
            this.enabledFeatures.add(feature);
        }
    }

    private List<FeatureRegistration> resetRegistrations() {
        ArrayList<FeatureRegistration> result = new ArrayList<FeatureRegistration>(this.newFeatureRegistrations);
        this.newFeatureRegistrations.clear();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommonConfig)) {
            return false;
        }
        CommonConfig that = (CommonConfig)o;
        if (this.type != that.type) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        if (!this.componentBag.equals(that.componentBag)) {
            return false;
        }
        if (!this.enabledFeatureClasses.equals(that.enabledFeatureClasses)) {
            return false;
        }
        if (!this.enabledFeatures.equals(that.enabledFeatures)) {
            return false;
        }
        return this.newFeatureRegistrations.equals(that.newFeatureRegistrations);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + this.componentBag.hashCode();
        result = 31 * result + this.newFeatureRegistrations.hashCode();
        result = 31 * result + this.enabledFeatures.hashCode();
        result = 31 * result + this.enabledFeatureClasses.hashCode();
        return result;
    }

    private static final class FeatureRegistration {
        private final Class<? extends Feature> featureClass;
        private final Feature feature;

        private FeatureRegistration(Class<? extends Feature> featureClass) {
            this.featureClass = featureClass;
            this.feature = null;
        }

        private FeatureRegistration(Feature feature) {
            this.featureClass = feature.getClass();
            this.feature = feature;
        }

        public Class<? extends Feature> getFeatureClass() {
            return this.featureClass;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FeatureRegistration)) {
                return false;
            }
            FeatureRegistration other = (FeatureRegistration)obj;
            return this.featureClass == other.featureClass || this.feature != null && (this.feature == other.feature || this.feature.equals(other.feature));
        }

        public int hashCode() {
            int hash = 47;
            hash = 13 * hash + (this.feature != null ? this.feature.hashCode() : 0);
            hash = 13 * hash + (this.featureClass != null ? this.featureClass.hashCode() : 0);
            return hash;
        }
    }
}

