/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.jersey.client;

import java.util.Collections;
import org.osiam.bundled.javax.inject.Inject;
import org.osiam.bundled.javax.inject.Provider;
import org.osiam.bundled.javax.ws.rs.ext.ReaderInterceptor;
import org.osiam.bundled.javax.ws.rs.ext.WriterInterceptor;
import org.osiam.bundled.jersey.repackaged.com.google.common.base.Function;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.Lists;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceLocator;
import org.osiam.bundled.org.glassfish.jersey.client.ClientRequest;
import org.osiam.bundled.org.glassfish.jersey.internal.inject.Providers;
import org.osiam.bundled.org.glassfish.jersey.internal.util.collection.Ref;
import org.osiam.bundled.org.glassfish.jersey.message.MessageBodyWorkers;
import org.osiam.bundled.org.glassfish.jersey.model.internal.RankedComparator;

public class RequestProcessingInitializationStage
implements Function<ClientRequest, ClientRequest> {
    private final Provider<Ref<ClientRequest>> requestRefProvider;
    private final Provider<MessageBodyWorkers> workersProvider;
    private final Iterable<WriterInterceptor> writerInterceptors;
    private final Iterable<ReaderInterceptor> readerInterceptors;

    @Inject
    public RequestProcessingInitializationStage(Provider<Ref<ClientRequest>> requestRefProvider, Provider<MessageBodyWorkers> workersProvider, ServiceLocator locator) {
        this.requestRefProvider = requestRefProvider;
        this.workersProvider = workersProvider;
        this.writerInterceptors = Collections.unmodifiableList(Lists.newArrayList(Providers.getAllProviders(locator, WriterInterceptor.class, new RankedComparator())));
        this.readerInterceptors = Collections.unmodifiableList(Lists.newArrayList(Providers.getAllProviders(locator, ReaderInterceptor.class, new RankedComparator())));
    }

    @Override
    public ClientRequest apply(ClientRequest requestContext) {
        this.requestRefProvider.get().set(requestContext);
        requestContext.setWorkers(this.workersProvider.get());
        requestContext.setWriterInterceptors(this.writerInterceptors);
        requestContext.setReaderInterceptors(this.readerInterceptors);
        return requestContext;
    }
}

