/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.jersey.repackaged.com.google.common.base;

import java.io.Serializable;
import org.osiam.bundled.javax.annotation.Nullable;
import org.osiam.bundled.jersey.repackaged.com.google.common.base.Objects;
import org.osiam.bundled.jersey.repackaged.com.google.common.base.Supplier;

public final class Suppliers {
    public static <T> Supplier<T> ofInstance(@Nullable T instance) {
        return new SupplierOfInstance<T>(instance);
    }

    private static class SupplierOfInstance<T>
    implements Serializable,
    Supplier<T> {
        final T instance;

        SupplierOfInstance(@Nullable T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof SupplierOfInstance) {
                SupplierOfInstance that = (SupplierOfInstance)obj;
                return Objects.equal(this.instance, that.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            return "Suppliers.ofInstance(" + this.instance + ")";
        }
    }
}

