/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.jvnet.hk2.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import org.osiam.bundled.org.glassfish.hk2.api.ActiveDescriptor;
import org.osiam.bundled.org.glassfish.hk2.api.DescriptorFileFinder;
import org.osiam.bundled.org.glassfish.hk2.api.DynamicConfiguration;
import org.osiam.bundled.org.glassfish.hk2.api.DynamicConfigurationService;
import org.osiam.bundled.org.glassfish.hk2.api.MultiException;
import org.osiam.bundled.org.glassfish.hk2.api.Populator;
import org.osiam.bundled.org.glassfish.hk2.api.PopulatorPostProcessor;
import org.osiam.bundled.org.glassfish.hk2.api.ServiceLocator;
import org.osiam.bundled.org.glassfish.hk2.utilities.ClasspathDescriptorFileFinder;
import org.osiam.bundled.org.glassfish.hk2.utilities.DescriptorImpl;
import org.osiam.bundled.org.jvnet.hk2.internal.Collector;

public class PopulatorImpl
implements Populator {
    private final ServiceLocator serviceLocator;
    private final DynamicConfigurationService dcs;

    PopulatorImpl(ServiceLocator serviceLocator, DynamicConfigurationService dcs) {
        this.serviceLocator = serviceLocator;
        this.dcs = dcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActiveDescriptor<?>> populate(DescriptorFileFinder fileFinder, PopulatorPostProcessor ... postProcessors) throws IOException {
        List<InputStream> descriptorFileInputStreams;
        LinkedList descriptors = new LinkedList();
        if (fileFinder == null && (fileFinder = this.serviceLocator.getService(DescriptorFileFinder.class, new Annotation[0])) == null) {
            return descriptors;
        }
        if (postProcessors == null) {
            postProcessors = new PopulatorPostProcessor[]{};
        }
        try {
            descriptorFileInputStreams = fileFinder.findDescriptorFiles();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
        Collector collector = new Collector();
        DynamicConfiguration config = this.dcs.createDynamicConfiguration();
        for (InputStream is : descriptorFileInputStreams) {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                boolean readOne = false;
                do {
                    DescriptorImpl descriptorImpl;
                    if (!(readOne = (descriptorImpl = new DescriptorImpl()).readObject(br))) continue;
                    for (PopulatorPostProcessor pp : postProcessors) {
                        try {
                            descriptorImpl = pp.process(this.serviceLocator, descriptorImpl);
                        }
                        catch (Throwable th) {
                            collector.addThrowable(th);
                            descriptorImpl = null;
                        }
                        if (descriptorImpl == null) break;
                    }
                    if (descriptorImpl == null) continue;
                    descriptors.add(config.bind(descriptorImpl, false));
                } while (readOne);
            }
            finally {
                br.close();
            }
        }
        collector.throwIfErrors();
        config.commit();
        return descriptors;
    }

    @Override
    public List<ActiveDescriptor<?>> populate() throws IOException {
        return this.populate(new ClasspathDescriptorFileFinder(), new PopulatorPostProcessor[0]);
    }
}

