/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.glassfish.jersey.client.authentication;

import org.osiam.bundled.javax.ws.rs.ProcessingException;
import org.osiam.bundled.javax.ws.rs.client.ClientRequestContext;
import org.osiam.bundled.javax.ws.rs.client.ClientResponseContext;
import org.osiam.bundled.org.glassfish.jersey.client.authentication.HttpAuthenticationFilter;
import org.osiam.bundled.org.glassfish.jersey.client.internal.LocalizationMessages;
import org.osiam.bundled.org.glassfish.jersey.internal.util.Base64;

final class BasicAuthenticator {
    private final HttpAuthenticationFilter.Credentials defaultCredentials;

    BasicAuthenticator(HttpAuthenticationFilter.Credentials defaultCredentials) {
        this.defaultCredentials = defaultCredentials;
    }

    private String calculateAuthentication(HttpAuthenticationFilter.Credentials credentials) {
        String username = credentials.getUsername();
        byte[] password = credentials.getPassword();
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = new byte[]{};
        }
        byte[] prefix = (username + ":").getBytes(HttpAuthenticationFilter.CHARACTER_SET);
        byte[] usernamePassword = new byte[prefix.length + password.length];
        System.arraycopy(prefix, 0, usernamePassword, 0, prefix.length);
        System.arraycopy(password, 0, usernamePassword, prefix.length, password.length);
        return "Basic " + Base64.encodeAsString(usernamePassword);
    }

    public void filterRequest(ClientRequestContext request) {
        HttpAuthenticationFilter.Credentials credentials = HttpAuthenticationFilter.getCredentials(request, this.defaultCredentials, HttpAuthenticationFilter.Type.BASIC);
        if (credentials == null) {
            throw new ProcessingException(LocalizationMessages.AUTHENTICATION_CREDENTIALS_MISSING_BASIC());
        }
        request.getHeaders().add("Authorization", this.calculateAuthentication(credentials));
    }

    public boolean filterResponseAndAuthenticate(ClientRequestContext request, ClientResponseContext response) {
        String authenticate = response.getHeaders().getFirst("WWW-Authenticate");
        if (authenticate != null && authenticate.trim().startsWith("Basic")) {
            HttpAuthenticationFilter.Credentials credentials = HttpAuthenticationFilter.getCredentials(request, this.defaultCredentials, HttpAuthenticationFilter.Type.BASIC);
            if (credentials == null) {
                throw new ProcessingException(LocalizationMessages.AUTHENTICATION_CREDENTIALS_MISSING_BASIC());
            }
            return HttpAuthenticationFilter.repeatRequest(request, response, this.calculateAuthentication(credentials));
        }
        return false;
    }
}

