/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.org.jvnet.hk2.internal;

import java.net.URL;
import org.osiam.bundled.org.glassfish.hk2.utilities.reflection.Pretty;

class DelegatingClassLoader
extends ClassLoader {
    private final Object hardPointer;
    private final ClassLoader[] delegates;

    DelegatingClassLoader(ClassLoader parent, Object hardPointer, ClassLoader ... classLoaderDelegates) {
        super(parent);
        this.hardPointer = hardPointer;
        this.delegates = classLoaderDelegates;
    }

    @Override
    public Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.getParent() != null) {
            try {
                return this.getParent().loadClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        ClassNotFoundException firstFail = null;
        for (ClassLoader delegate : this.delegates) {
            try {
                return delegate.loadClass(clazz);
            }
            catch (ClassNotFoundException ncfe) {
                if (firstFail != null) continue;
                firstFail = ncfe;
            }
        }
        if (firstFail != null) {
            throw firstFail;
        }
        throw new ClassNotFoundException("Could not find " + clazz);
    }

    @Override
    public URL getResource(String resource) {
        URL u;
        if (this.getParent() != null && (u = this.getParent().getResource(resource)) != null) {
            return u;
        }
        for (ClassLoader delegate : this.delegates) {
            URL u2 = delegate.getResource(resource);
            if (u2 == null) continue;
            return u2;
        }
        return null;
    }

    public String toString() {
        return "DelegatingClassLoader(" + this.getParent() + "," + this.hardPointer + "," + Pretty.array(this.delegates) + "," + System.identityHashCode(this) + ")";
    }
}

