/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.List;
import org.osiam.bundled.javax.ws.rs.client.Client;
import org.osiam.bundled.javax.ws.rs.client.ClientBuilder;
import org.osiam.bundled.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.osiam.bundled.org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.osiam.bundled.org.glassfish.jersey.client.ClientConfig;
import org.osiam.bundled.org.glassfish.jersey.client.RequestEntityProcessing;
import org.osiam.bundled.org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.osiam.client.AuthService;
import org.osiam.client.OsiamGroupService;
import org.osiam.client.OsiamUserService;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.oauth.Scope;
import org.osiam.client.query.Query;
import org.osiam.client.query.QueryBuilder;
import org.osiam.client.user.BasicUser;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.UpdateGroup;
import org.osiam.resources.scim.UpdateUser;
import org.osiam.resources.scim.User;

public class OsiamConnector {
    private static final int DEFAULT_CONNECT_TIMEOUT = 2500;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private static final int DEFAULT_MAX_CONNECTIONS = 40;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 20;
    private static final PoolingHttpClientConnectionManager CONNECTION_MANAGER = new PoolingHttpClientConnectionManager();
    private static final Client CLIENT;
    private AuthService authService;
    private OsiamUserService userService;
    private OsiamGroupService groupService;

    static Client getClient() {
        return CLIENT;
    }

    public static void setConnectTimeout(int connectTimeout) {
        CLIENT.property("jersey.config.client.connectTimeout", connectTimeout);
    }

    public static void setReadTimeout(int readTimeout) {
        CLIENT.property("jersey.config.client.readTimeout", readTimeout);
    }

    public static void setMaxConnections(int maxConnections) {
        CONNECTION_MANAGER.setMaxTotal(maxConnections);
    }

    public static void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        CONNECTION_MANAGER.setDefaultMaxPerRoute(maxConnectionsPerRoute);
    }

    private OsiamConnector(Builder builder) {
        String resourceServiceEndpoint;
        String authServiceEndpoint = this.authServiceEndpoint(builder.authServiceEndpoint, builder.combinedEndpoint);
        if (!Strings.isNullOrEmpty((String)authServiceEndpoint)) {
            AuthService.Builder authServiceBuilder = new AuthService.Builder(authServiceEndpoint);
            if (builder.clientId != null) {
                authServiceBuilder = authServiceBuilder.setClientId(builder.clientId);
            }
            if (builder.clientSecret != null) {
                authServiceBuilder = authServiceBuilder.setClientSecret(builder.clientSecret);
            }
            if (builder.clientRedirectUri != null) {
                authServiceBuilder = authServiceBuilder.setClientRedirectUri(builder.clientRedirectUri);
            }
            this.authService = authServiceBuilder.build();
        }
        if (!Strings.isNullOrEmpty((String)(resourceServiceEndpoint = this.resourceServiceEndpoint(builder.resourceServiceEndpoint, builder.combinedEndpoint)))) {
            this.userService = new OsiamUserService.Builder(resourceServiceEndpoint).build();
            this.groupService = new OsiamGroupService.Builder(resourceServiceEndpoint).build();
        }
    }

    private AuthService authService() {
        if (this.authService == null) {
            throw new IllegalStateException("The auth-server endpoint is not configured.");
        }
        return this.authService;
    }

    private OsiamUserService userService() {
        if (this.userService == null) {
            throw new IllegalStateException("The resource-server endpoint is not configured.");
        }
        return this.userService;
    }

    private OsiamGroupService groupService() {
        if (this.groupService == null) {
            throw new IllegalStateException("The resource-server endpoint is not configured.");
        }
        return this.groupService;
    }

    private String authServiceEndpoint(String authServiceEndpoint, String combinedEndpoint) {
        if (!Strings.isNullOrEmpty((String)authServiceEndpoint)) {
            return authServiceEndpoint;
        }
        if (!Strings.isNullOrEmpty((String)combinedEndpoint)) {
            StringBuilder endpoint = new StringBuilder(combinedEndpoint);
            if (!combinedEndpoint.endsWith("/")) {
                endpoint.append("/");
            }
            endpoint.append("osiam-auth-server");
            return endpoint.toString();
        }
        return null;
    }

    private String resourceServiceEndpoint(String resourceServiceEndpoint, String baseEndpoint) {
        if (!Strings.isNullOrEmpty((String)resourceServiceEndpoint)) {
            return resourceServiceEndpoint;
        }
        if (!Strings.isNullOrEmpty((String)baseEndpoint)) {
            StringBuilder endpoint = new StringBuilder(baseEndpoint);
            if (!baseEndpoint.endsWith("/")) {
                endpoint.append("/");
            }
            endpoint.append("osiam-resource-server");
            return endpoint.toString();
        }
        return null;
    }

    public User getUser(String id, AccessToken accessToken) {
        return this.userService().getUser(id, accessToken);
    }

    public List<User> getAllUsers(AccessToken accessToken) {
        return this.userService().getAllUsers(accessToken);
    }

    public SCIMSearchResult<User> searchUsers(Query query, AccessToken accessToken) {
        return this.userService().searchResources(query, accessToken);
    }

    public User getCurrentUser(AccessToken accessToken) {
        return this.userService().getCurrentUser(accessToken);
    }

    public BasicUser getCurrentUserBasic(AccessToken accessToken) {
        return this.userService().getCurrentUserBasic(accessToken);
    }

    public Group getGroup(String id, AccessToken accessToken) {
        return this.groupService().getGroup(id, accessToken);
    }

    public List<Group> getAllGroups(AccessToken accessToken) {
        return this.groupService().getAllGroups(accessToken);
    }

    public SCIMSearchResult<Group> searchGroups(Query query, AccessToken accessToken) {
        return this.groupService().searchGroups(query, accessToken);
    }

    public AccessToken refreshAccessToken(AccessToken accessToken, Scope ... scopes) {
        return this.authService().refreshAccessToken(accessToken, scopes);
    }

    public URI getAuthorizationUri(Scope ... scopes) {
        return this.authService().getAuthorizationUri(scopes);
    }

    public AccessToken retrieveAccessToken(Scope ... scopes) {
        return this.authService().retrieveAccessToken(scopes);
    }

    public AccessToken retrieveAccessToken(String userName, String password, Scope ... scopes) {
        return this.authService().retrieveAccessToken(userName, password, scopes);
    }

    public AccessToken retrieveAccessToken(String authCode) {
        return this.authService().retrieveAccessToken(authCode);
    }

    public User createUser(User user, AccessToken accessToken) {
        return this.userService().createUser(user, accessToken);
    }

    public Group createGroup(Group group, AccessToken accessToken) {
        return this.groupService().createGroup(group, accessToken);
    }

    public void deleteGroup(String id, AccessToken accessToken) {
        this.groupService().deleteGroup(id, accessToken);
    }

    public void deleteUser(String id, AccessToken accessToken) {
        this.userService().deleteUser(id, accessToken);
    }

    public User updateUser(String id, UpdateUser updateUser, AccessToken accessToken) {
        return this.userService().updateUser(id, updateUser, accessToken);
    }

    public User replaceUser(String id, User user, AccessToken accessToken) {
        return this.userService().replaceUser(id, user, accessToken);
    }

    public Group updateGroup(String id, UpdateGroup updateGroup, AccessToken accessToken) {
        return this.groupService().updateGroup(id, updateGroup, accessToken);
    }

    public Group replaceGroup(String id, Group group, AccessToken accessToken) {
        return this.groupService().updateGroup(id, group, accessToken);
    }

    public AccessToken validateAccessToken(AccessToken tokenToValidate) {
        return this.authService().validateAccessToken(tokenToValidate);
    }

    public void revokeAccessToken(AccessToken tokenToRevoke) {
        this.authService().revokeAccessToken(tokenToRevoke);
    }

    public void revokeAllAccessTokens(String id, AccessToken accessToken) {
        this.authService().revokeAllAccessTokens(id, accessToken);
    }

    public QueryBuilder createQueryBuilder() {
        return new QueryBuilder();
    }

    public QueryBuilder createQueryBuilder(Query original) {
        return new QueryBuilder(original);
    }

    static {
        CONNECTION_MANAGER.setMaxTotal(40);
        CONNECTION_MANAGER.setDefaultMaxPerRoute(20);
        ClientConfig clientConfig = new ClientConfig().connectorProvider(new ApacheConnectorProvider()).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED).property("jersey.config.apache.client.connectionManager", CONNECTION_MANAGER).register(HttpAuthenticationFeature.basicBuilder().build()).property("jersey.config.client.connectTimeout", 2500).property("jersey.config.client.readTimeout", 5000);
        CLIENT = ClientBuilder.newClient(clientConfig);
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String combinedEndpoint;
        private String authServiceEndpoint;
        private String resourceServiceEndpoint;
        private String clientRedirectUri;

        public Builder setEndpoint(String endpoint) {
            this.combinedEndpoint = endpoint;
            return this;
        }

        public Builder setAuthServerEndpoint(String endpoint) {
            this.authServiceEndpoint = endpoint;
            return this;
        }

        public Builder setResourceServerEndpoint(String endpoint) {
            this.resourceServiceEndpoint = endpoint;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setClientRedirectUri(String clientRedirectUri) {
            this.clientRedirectUri = clientRedirectUri;
            return this;
        }

        public OsiamConnector build() {
            return new OsiamConnector(this);
        }
    }
}

