/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.bundled.jersey.repackaged.com.google.common.collect;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.osiam.bundled.javax.annotation.Nullable;
import org.osiam.bundled.jersey.repackaged.com.google.common.base.Function;
import org.osiam.bundled.jersey.repackaged.com.google.common.base.Preconditions;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ByFunctionOrdering;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ComparatorOrdering;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ImmutableList;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.Iterables;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.Lists;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.Maps;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.NaturalOrdering;
import org.osiam.bundled.jersey.repackaged.com.google.common.collect.ReverseOrdering;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        Object[] array = Iterables.toArray(elements);
        Arrays.sort(array, this);
        return Lists.newArrayList(Arrays.asList(array));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        Object[] array;
        for (Object e : array = Iterables.toArray(elements)) {
            Preconditions.checkNotNull(e);
        }
        Arrays.sort(array, this);
        return ImmutableList.asImmutableList(array);
    }
}

