/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.osiam.bundled.com.fasterxml.jackson.core.JsonProcessingException;
import org.osiam.bundled.com.fasterxml.jackson.core.type.TypeReference;
import org.osiam.bundled.com.fasterxml.jackson.databind.JavaType;
import org.osiam.bundled.com.fasterxml.jackson.databind.module.SimpleModule;
import org.osiam.bundled.com.fasterxml.jackson.databind.node.ArrayNode;
import org.osiam.bundled.com.fasterxml.jackson.databind.node.ObjectNode;
import org.osiam.bundled.com.fasterxml.jackson.databind.type.TypeFactory;
import org.osiam.bundled.javax.ws.rs.ProcessingException;
import org.osiam.bundled.javax.ws.rs.client.Entity;
import org.osiam.bundled.javax.ws.rs.client.WebTarget;
import org.osiam.bundled.javax.ws.rs.core.Response;
import org.osiam.client.OsiamConnector;
import org.osiam.client.Version;
import org.osiam.client.exception.BadRequestException;
import org.osiam.client.exception.ConflictException;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.ForbiddenException;
import org.osiam.client.exception.NoResultException;
import org.osiam.client.exception.OAuthErrorMessage;
import org.osiam.client.exception.OsiamClientException;
import org.osiam.client.exception.OsiamRequestException;
import org.osiam.client.exception.UnauthorizedException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.client.query.QueryBuilder;
import org.osiam.resources.helper.UserDeserializer;
import org.osiam.resources.scim.ErrorResponse;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;

abstract class AbstractOsiamService<T extends Resource> {
    static final String CONNECTION_SETUP_ERROR_STRING = "Cannot connect to OSIAM";
    private static final String AUTHORIZATION = "Authorization";
    static final String BEARER = "Bearer ";
    final WebTarget targetEndpoint;
    private final Class<T> type;
    private final String typeName;
    private final int connectTimeout;
    private final int readTimeout;
    private final Version version;

    AbstractOsiamService(String endpoint, Class<T> type, int connectTimeout, int readTimeout, Version version) {
        this.type = type;
        this.typeName = type.getSimpleName();
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.version = version;
        UserDeserializer userDeserializer = this.version == Version.OSIAM_2_LEGACY_SCHEMAS ? new UserDeserializer("urn:scim:schemas:core:2.0:User") : new UserDeserializer();
        SimpleModule userDeserializerModule = new SimpleModule("userDeserializerModule", org.osiam.bundled.com.fasterxml.jackson.core.Version.unknownVersion()).addDeserializer(User.class, userDeserializer);
        OsiamConnector.objectMapper.registerModule(userDeserializerModule);
        this.targetEndpoint = OsiamConnector.getClient().target(endpoint);
    }

    static void checkAccessTokenIsNotNull(AccessToken accessToken) {
        Preconditions.checkNotNull((Object)accessToken, (Object)"The given accessToken must not be null.");
    }

    T getResource(String id, AccessToken accessToken, String ... attributes) {
        String content;
        Response.StatusType status;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"The given id must not be null nor empty.");
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        WebTarget target = attributes == null || attributes.length == 0 ? this.targetEndpoint : this.targetEndpoint.queryParam("attributes", Joiner.on((String)",").join((Object[])attributes));
        try {
            Response response = target.path(String.valueOf(this.typeName) + "s").path(id).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).get();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.mapToResource(content);
    }

    List<T> getAllResources(AccessToken accessToken, String ... attributes) {
        QueryBuilder qBuilder = new QueryBuilder().count(Integer.MAX_VALUE);
        if (attributes != null && attributes.length > 0) {
            qBuilder.attributes(Joiner.on((char)',').join((Object[])attributes));
        }
        Query query = qBuilder.build();
        return this.searchResources(query, accessToken).getResources();
    }

    SCIMSearchResult<T> searchResources(Query query, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        Preconditions.checkNotNull((Object)query, (Object)"The given query must not be null.");
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            Response response = this.targetEndpoint.path(String.valueOf(this.typeName) + "s").queryParam("attributes", query.getAttributes()).queryParam("filter", query.getFilter()).queryParam("sortBy", query.getSortBy()).queryParam("sortOrder", query.getSortOrder()).queryParam("startIndex", query.getStartIndex() != 1L ? Long.valueOf(query.getStartIndex()) : null).queryParam("count", query.getCount() != 100 ? Integer.valueOf(query.getCount()) : null).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).get();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        try {
            JavaType queryResultType = TypeFactory.defaultInstance().constructParametrizedType(SCIMSearchResult.class, SCIMSearchResult.class, this.type);
            return (SCIMSearchResult)OsiamConnector.objectMapper.readValue(content, queryResultType);
        }
        catch (IOException e) {
            throw new OsiamClientException(String.format("Unable to deserialize search result: %s", content), e);
        }
    }

    void deleteResource(String id, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"The given id must not be null nor empty.");
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            Response response = this.targetEndpoint.path(String.valueOf(this.typeName) + "s").path(id).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).delete();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
    }

    T createResource(T resource, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        String resourceAsString;
        Preconditions.checkNotNull(resource, (String)"The given %s must not be null nor empty.", (Object[])new Object[]{this.typeName});
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            resourceAsString = this.mapToString(resource);
        }
        catch (ClassCastException | JsonProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        try {
            Response response = this.targetEndpoint.path(String.valueOf(this.typeName) + "s").request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).post(Entity.json(resourceAsString));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.mapToResource(content);
    }

    @Deprecated
    T updateResource(String id, T resource, AccessToken accessToken) {
        return this.modifyResource(id, resource, "PATCH", accessToken);
    }

    T replaceResource(String id, T resource, AccessToken accessToken) {
        return this.modifyResource(id, resource, "PUT", accessToken);
    }

    private T modifyResource(String id, T resource, String method, AccessToken accessToken) {
        String content;
        Response.StatusType status;
        String resourceAsString;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"The given id must not be null nor empty.");
        Preconditions.checkNotNull(resource, (String)"The given %s must not be null nor empty.", (Object[])new Object[]{this.typeName});
        AbstractOsiamService.checkAccessTokenIsNotNull(accessToken);
        try {
            resourceAsString = this.mapToString(resource);
        }
        catch (JsonProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        try {
            Response response = this.targetEndpoint.path(String.valueOf(this.typeName) + "s").path(id).request("application/json").header(AUTHORIZATION, BEARER + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.connectTimeout).property("jersey.config.client.readTimeout", this.readTimeout).method(method, Entity.json(resourceAsString));
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException(CONNECTION_SETUP_ERROR_STRING, e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.mapToResource(content);
    }

    private T mapToResource(String content) {
        return (T)((Resource)this.mapToType(content, this.type));
    }

    <U> U mapToType(String content, Class<U> type) {
        try {
            if (this.version == Version.OSIAM_2_LEGACY_SCHEMAS && (type == User.class || type == Group.class)) {
                ObjectNode resourceNode = (ObjectNode)OsiamConnector.objectMapper.readTree(content);
                this.switchToLegacySchema(resourceNode);
                return OsiamConnector.objectMapper.readValue(OsiamConnector.objectMapper.treeAsTokens(resourceNode), type);
            }
            return OsiamConnector.objectMapper.readValue(content, type);
        }
        catch (IOException | ClassCastException e) {
            throw new OsiamClientException(String.format("Unable to parse %s: %s", this.typeName, content), e);
        }
    }

    private String mapToString(T resource) throws JsonProcessingException {
        if (this.version == Version.OSIAM_2_LEGACY_SCHEMAS) {
            ObjectNode resourceNode = (ObjectNode)OsiamConnector.objectMapper.valueToTree(resource);
            this.switchToLegacySchema(resourceNode);
            return resourceNode.toString();
        }
        return OsiamConnector.objectMapper.writeValueAsString(resource);
    }

    private void switchToLegacySchema(ObjectNode resourceNode) {
        ArrayNode schemas = (ArrayNode)resourceNode.get("schemas");
        int i = 0;
        while (i < schemas.size()) {
            if (this.getSchema().equals(schemas.get(i).textValue())) {
                schemas.remove(i);
            }
            ++i;
        }
        schemas.add(this.getLegacySchema());
    }

    protected abstract String getSchema();

    protected abstract String getLegacySchema();

    void checkAndHandleResponse(String content, Response.StatusType status, AccessToken accessToken) {
        if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
            return;
        }
        if (status.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            String errorMessage = this.extractErrorMessageUnauthorized(content, status);
            throw new UnauthorizedException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.BAD_REQUEST.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new BadRequestException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new NoResultException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.FORBIDDEN.getStatusCode()) {
            String errorMessage = this.extractErrorMessageForbidden(accessToken);
            throw new ForbiddenException(errorMessage);
        }
        if (status.getStatusCode() == Response.Status.CONFLICT.getStatusCode()) {
            String errorMessage = this.extractErrorMessage(content, status);
            throw new ConflictException(errorMessage);
        }
        String errorMessage = this.extractErrorMessageDefault(content, status);
        throw new OsiamRequestException(status.getStatusCode(), errorMessage);
    }

    private String extractErrorMessageForbidden(AccessToken accessToken) {
        return "Insufficient scopes: " + accessToken.getScopes();
    }

    private String extractErrorMessageUnauthorized(String content, Response.StatusType status) {
        return this.extractErrorMessage(content, status);
    }

    private String extractErrorMessageDefault(String content, Response.StatusType status) {
        return this.extractErrorMessage(content, status);
    }

    private String extractErrorMessage(String content, Response.StatusType status) {
        String message = this.version == Version.OSIAM_2_LEGACY_SCHEMAS ? this.getScimErrorMessageLegacy(content) : this.getScimErrorMessage(content);
        if (message == null) {
            message = this.getOAuthErrorMessage(content);
        }
        if (message == null) {
            message = String.format("Could not deserialize the error response for the HTTP status '%s'.", status.getReasonPhrase());
            if (content != null) {
                message = String.valueOf(message) + String.format(" Original response: %s", content);
            }
        }
        return message;
    }

    private String getScimErrorMessage(String content) {
        try {
            ErrorResponse error = OsiamConnector.objectMapper.readValue(content, ErrorResponse.class);
            return error.getDetail();
        }
        catch (IOException | ProcessingException exception) {
            return null;
        }
    }

    private String getScimErrorMessageLegacy(String content) {
        try {
            Map error = (Map)OsiamConnector.objectMapper.readValue(content, (TypeReference)new TypeReference<Map<String, String>>(){});
            return (String)error.get("description");
        }
        catch (IOException | ProcessingException exception) {
            return null;
        }
    }

    private String getOAuthErrorMessage(String content) {
        try {
            OAuthErrorMessage error = OsiamConnector.objectMapper.readValue(content, OAuthErrorMessage.class);
            return error.getDescription();
        }
        catch (IOException | ProcessingException exception) {
            return null;
        }
    }

    int getConnectTimeout() {
        return this.connectTimeout;
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    Version getVersion() {
        return this.version;
    }
}

