/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.client;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.List;
import org.osiam.bundled.javax.ws.rs.ProcessingException;
import org.osiam.bundled.javax.ws.rs.client.WebTarget;
import org.osiam.bundled.javax.ws.rs.core.Response;
import org.osiam.client.AbstractOsiamService;
import org.osiam.client.Version;
import org.osiam.client.exception.ConnectionInitializationException;
import org.osiam.client.exception.InvalidAttributeException;
import org.osiam.client.oauth.AccessToken;
import org.osiam.client.query.Query;
import org.osiam.client.user.BasicUser;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.UpdateUser;
import org.osiam.resources.scim.User;

class OsiamUserService
extends AbstractOsiamService<User> {
    static final String LEGACY_SCHEMA = "urn:scim:schemas:core:2.0:User";

    OsiamUserService(String endpoint, int connectTimeout, int readTimeout, Version version) {
        super(endpoint, User.class, connectTimeout, readTimeout, version);
    }

    User getUser(String id, AccessToken accessToken, String ... attributes) {
        return (User)this.getResource(id, accessToken, attributes);
    }

    @Deprecated
    BasicUser getCurrentUserBasic(AccessToken accessToken) {
        String content;
        Response.StatusType status;
        OsiamUserService.checkAccessTokenIsNotNull(accessToken);
        try {
            Response response = this.targetEndpoint.path("me").request("application/json").header("Authorization", "Bearer " + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.getConnectTimeout()).property("jersey.config.client.readTimeout", this.getReadTimeout()).get();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException("Cannot connect to OSIAM", e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return this.mapToType(content, BasicUser.class);
    }

    @Deprecated
    User getCurrentUser(AccessToken accessToken) {
        BasicUser basicUser = this.getCurrentUserBasic(accessToken);
        return (User)this.getResource(basicUser.getId(), accessToken, new String[0]);
    }

    User getMe(AccessToken accessToken, String ... attributes) {
        return this.getVersion() == Version.OSIAM_3 ? this.mapToType(this.getMeResource(accessToken, attributes), User.class) : this.getUser(this.getCurrentUserBasic(accessToken).getId(), accessToken, new String[0]);
    }

    List<User> getAllUsers(AccessToken accessToken, String ... attributes) {
        return super.getAllResources(accessToken, attributes);
    }

    SCIMSearchResult<User> searchUsers(Query query, AccessToken accessToken) {
        return this.searchResources(query, accessToken);
    }

    void deleteUser(String id, AccessToken accessToken) {
        this.deleteResource(id, accessToken);
    }

    User createUser(User user, AccessToken accessToken) {
        return this.createResource(user, accessToken);
    }

    @Deprecated
    User updateUser(String id, UpdateUser updateUser, AccessToken accessToken) {
        if (updateUser == null) {
            throw new IllegalArgumentException("The given updateUser can't be null.");
        }
        return this.updateResource(id, updateUser.getScimConformUpdateUser(), accessToken);
    }

    User replaceUser(String id, User user, AccessToken accessToken) {
        if (user == null) {
            throw new InvalidAttributeException("The given User can't be null.");
        }
        if (Strings.isNullOrEmpty((String)id)) {
            throw new InvalidAttributeException("The given User ID can't be null or empty.");
        }
        return this.replaceResource(id, user, accessToken);
    }

    @Override
    protected String getSchema() {
        return "urn:ietf:params:scim:schemas:core:2.0:User";
    }

    @Override
    protected String getLegacySchema() {
        return LEGACY_SCHEMA;
    }

    private String getMeResource(AccessToken accessToken, String ... attributes) {
        String content;
        Response.StatusType status;
        OsiamUserService.checkAccessTokenIsNotNull(accessToken);
        WebTarget target = attributes == null || attributes.length == 0 ? this.targetEndpoint : this.targetEndpoint.queryParam("attributes", Joiner.on((String)",").join((Object[])attributes));
        try {
            Response response = target.path("Me").request("application/json").header("Authorization", "Bearer " + accessToken.getToken()).property("jersey.config.client.connectTimeout", this.getConnectTimeout()).property("jersey.config.client.readTimeout", this.getReadTimeout()).get();
            status = response.getStatusInfo();
            content = response.readEntity(String.class);
        }
        catch (ProcessingException e) {
            throw new ConnectionInitializationException("Cannot connect to OSIAM", e);
        }
        this.checkAndHandleResponse(content, status, accessToken);
        return content;
    }
}

