/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.helper;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.osiam.bundled.com.fasterxml.jackson.core.JsonGenerator;
import org.osiam.bundled.com.fasterxml.jackson.databind.JsonSerializer;
import org.osiam.bundled.com.fasterxml.jackson.databind.SerializerProvider;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.ExtensionFieldType;

public class ExtensionSerializer
extends JsonSerializer<Extension> {
    @Override
    public void serialize(Extension value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        Map<String, Extension.Field> fields = value.getFields();
        for (Map.Entry<String, Extension.Field> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            ExtensionFieldType<?> fieldType = entry.getValue().getType();
            String rawFieldValue = entry.getValue().getValue();
            jgen.writeFieldName(fieldName);
            if (fieldType == ExtensionFieldType.INTEGER) {
                BigInteger valueAsBigInteger = ExtensionFieldType.INTEGER.fromString(rawFieldValue);
                jgen.writeNumber(valueAsBigInteger);
                continue;
            }
            if (fieldType == ExtensionFieldType.DECIMAL) {
                BigDecimal valueAsBigDecimal = ExtensionFieldType.DECIMAL.fromString(rawFieldValue);
                jgen.writeNumber(valueAsBigDecimal);
                continue;
            }
            if (fieldType == ExtensionFieldType.BOOLEAN) {
                Boolean valueAsBoolean = ExtensionFieldType.BOOLEAN.fromString(rawFieldValue);
                jgen.writeBoolean(valueAsBoolean);
                continue;
            }
            jgen.writeString(rawFieldValue);
        }
        jgen.writeEndObject();
    }
}

