/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import java.io.Serializable;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonInclude;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.resources.scim.MultiValuedAttribute;
import org.osiam.resources.scim.MultiValuedAttributeType;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Address
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = 2731087785568277294L;
    private final String formatted;
    private final String streetAddress;
    private final String locality;
    private final String region;
    private final String postalCode;
    private final String country;
    private final Type type;

    @JsonCreator
    private Address(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="formatted") String formatted, @JsonProperty(value="streetAddress") String streetAddress, @JsonProperty(value="locality") String locality, @JsonProperty(value="region") String region, @JsonProperty(value="postalCode") String postalCode, @JsonProperty(value="country") String country, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.formatted = formatted;
        this.streetAddress = streetAddress;
        this.locality = locality;
        this.region = region;
        this.postalCode = postalCode;
        this.country = country;
        this.type = type;
    }

    private Address(Builder builder) {
        super(builder);
        this.formatted = builder.formatted;
        this.streetAddress = builder.streetAddress;
        this.locality = builder.locality;
        this.region = builder.region;
        this.postalCode = builder.postalCode;
        this.country = builder.country;
        this.type = builder.type;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    @Deprecated
    public String getOperation() {
        return super.getOperation();
    }

    @Override
    public boolean isPrimary() {
        return super.isPrimary();
    }

    @Override
    public String getDisplay() {
        return super.getDisplay();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.formatted == null ? 0 : this.formatted.hashCode());
        result = 31 * result + (this.locality == null ? 0 : this.locality.hashCode());
        result = 31 * result + (this.postalCode == null ? 0 : this.postalCode.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.streetAddress == null ? 0 : this.streetAddress.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.formatted == null ? other.formatted != null : !this.formatted.equals(other.formatted)) {
            return false;
        }
        if (this.locality == null ? other.locality != null : !this.locality.equals(other.locality)) {
            return false;
        }
        if (this.postalCode == null ? other.postalCode != null : !this.postalCode.equals(other.postalCode)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.streetAddress == null ? other.streetAddress != null : !this.streetAddress.equals(other.streetAddress)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public String toString() {
        return "Address [formatted=" + this.formatted + ", streetAddress=" + this.streetAddress + ", locality=" + this.locality + ", region=" + this.region + ", postalCode=" + this.postalCode + ", country=" + this.country + ", type=" + this.type + ", operation=" + this.getOperation() + ", primary=" + this.isPrimary() + "]";
    }

    /* synthetic */ Address(Builder builder, Address address) {
        this(builder);
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private String formatted;
        private String streetAddress;
        private String locality;
        private String region;
        private String postalCode;
        private String country;
        private Type type;

        public Builder() {
        }

        public Builder(Address address) {
            super(address);
            this.formatted = address.formatted;
            this.streetAddress = address.streetAddress;
            this.locality = address.locality;
            this.region = address.region;
            this.postalCode = address.postalCode;
            this.country = address.country;
            this.type = address.type;
        }

        public Builder setFormatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public Builder setStreetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        public Builder setLocality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        @Override
        public Builder setPrimary(boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        @Deprecated
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        public Address build() {
            return new Address(this, null);
        }
    }

    public static class Type
    extends MultiValuedAttributeType {
        public static final Type WORK = new Type("work");
        public static final Type HOME = new Type("home");
        public static final Type OTHER = new Type("other");

        public Type(String value) {
            super(value);
        }
    }
}

