/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.resources.exception.SCIMDataValidationException;
import org.osiam.resources.scim.MultiValuedAttribute;
import org.osiam.resources.scim.MultiValuedAttributeType;

public final class Email
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = 5595340465249831012L;
    private final Type type;

    @JsonCreator
    private Email(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private Email(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    @Override
    @Deprecated
    public String getOperation() {
        return super.getOperation();
    }

    @Override
    public String getValue() {
        return super.getValue();
    }

    @Override
    public String getDisplay() {
        return super.getDisplay();
    }

    @Override
    public boolean isPrimary() {
        return super.isPrimary();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Email other = (Email)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public String toString() {
        return "Email [value=" + this.getValue() + ", type=" + this.type + ", primary=" + this.isPrimary() + ", operation=" + this.getOperation() + "]";
    }

    /* synthetic */ Email(Builder builder, Email email) {
        this(builder);
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        public static final Pattern VALIDATION_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$");
        private Type type;

        public Builder() {
        }

        public Builder(Email email) {
            super(email);
            this.type = email.type;
        }

        @Override
        @Deprecated
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        public Builder setValue(String value) {
            Matcher matcher = VALIDATION_PATTERN.matcher(value);
            if (!matcher.matches()) {
                throw new SCIMDataValidationException("The value '" + value + "' is not a well-formed email.");
            }
            super.setValue(value);
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setPrimary(boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        public Email build() {
            return new Email(this, null);
        }
    }

    public static class Type
    extends MultiValuedAttributeType {
        public static final Type WORK = new Type("work");
        public static final Type HOME = new Type("home");
        public static final Type OTHER = new Type("other");

        public Type(String value) {
            super(value);
        }
    }
}

