/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Date;
import org.osiam.bundled.org.joda.time.format.DateTimeFormatter;
import org.osiam.bundled.org.joda.time.format.ISODateTimeFormat;

public abstract class ExtensionFieldType<T>
implements Serializable {
    public static final ExtensionFieldType<String> STRING = new ExtensionFieldType<String>("STRING"){

        @Override
        public String fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            return stringValue;
        }

        @Override
        public String toString(String value) {
            this.ensureValueIsNotNull(value);
            return value;
        }
    };
    public static final ExtensionFieldType<BigInteger> INTEGER = new ExtensionFieldType<BigInteger>("INTEGER"){

        @Override
        public BigInteger fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            try {
                return new BigInteger(stringValue);
            }
            catch (NumberFormatException e) {
                throw this.createConversionException(stringValue, "BigInteger", e);
            }
        }

        @Override
        public String toString(BigInteger value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }
    };
    public static final ExtensionFieldType<BigDecimal> DECIMAL = new ExtensionFieldType<BigDecimal>("DECIMAL"){

        @Override
        public BigDecimal fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            try {
                return new BigDecimal(stringValue);
            }
            catch (NumberFormatException e) {
                throw this.createConversionException(stringValue, "BigDecimal", e);
            }
        }

        @Override
        public String toString(BigDecimal value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }
    };
    public static final ExtensionFieldType<Boolean> BOOLEAN = new ExtensionFieldType<Boolean>("BOOLEAN"){

        @Override
        public Boolean fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            if (!stringValue.equals("true") && !stringValue.equals("false")) {
                throw this.createConversionException(stringValue, "Boolean");
            }
            return Boolean.valueOf(stringValue);
        }

        @Override
        public String toString(Boolean value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }
    };
    public static final ExtensionFieldType<ByteBuffer> BINARY = new ExtensionFieldType<ByteBuffer>("BINARY"){

        @Override
        public ByteBuffer fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            try {
                return ByteBuffer.wrap(BaseEncoding.base64().decode((CharSequence)stringValue));
            }
            catch (IllegalArgumentException e) {
                throw this.createConversionException(stringValue, "byte[]", e);
            }
        }

        @Override
        public String toString(ByteBuffer value) {
            this.ensureValueIsNotNull(value);
            return BaseEncoding.base64().encode(value.array());
        }
    };
    public static final ExtensionFieldType<URI> REFERENCE = new ExtensionFieldType<URI>("REFERENCE"){

        @Override
        public URI fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            try {
                return new URI(stringValue);
            }
            catch (URISyntaxException e) {
                throw this.createConversionException(stringValue, "URI", e);
            }
        }

        @Override
        public String toString(URI value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }
    };
    private static final long serialVersionUID = 5665143978696725609L;
    private static DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();
    public static final ExtensionFieldType<Date> DATE_TIME = new ExtensionFieldType<Date>("DATE_TIME"){

        @Override
        public Date fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            try {
                long millis = dateTimeFormatter.parseDateTime(stringValue).getMillis();
                return new Date(millis);
            }
            catch (NumberFormatException e) {
                throw this.createConversionException(stringValue, "Date", e);
            }
        }

        @Override
        public String toString(Date value) {
            this.ensureValueIsNotNull(value);
            return dateTimeFormatter.print(value.getTime());
        }
    };
    private String name;

    private ExtensionFieldType(String name) {
        this.name = name;
    }

    public static ExtensionFieldType<?> valueOf(String name) {
        switch (name) {
            case "STRING": {
                return STRING;
            }
            case "INTEGER": {
                return INTEGER;
            }
            case "DECIMAL": {
                return DECIMAL;
            }
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "DATE_TIME": {
                return DATE_TIME;
            }
            case "BINARY": {
                return BINARY;
            }
            case "REFERENCE": {
                return REFERENCE;
            }
        }
        throw new IllegalArgumentException("Type " + name + " does not exist");
    }

    public abstract T fromString(String var1);

    public abstract String toString(T var1);

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    protected IllegalArgumentException createConversionException(String stringValue, String targetType, Throwable cause) {
        IllegalArgumentException exception = this.createConversionException(stringValue, targetType);
        exception.initCause(cause);
        return exception;
    }

    protected IllegalArgumentException createConversionException(String stringValue, String targetType) {
        return new IllegalArgumentException("The value " + stringValue + " cannot be converted into a " + targetType + ".");
    }

    protected void ensureValueIsNotNull(Object value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"The given value cannot be null.");
    }

    /* synthetic */ ExtensionFieldType(String string, ExtensionFieldType extensionFieldType) {
        this(string);
    }
}

