/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonInclude;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.resources.exception.SCIMDataValidationException;
import org.osiam.resources.scim.MemberRef;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.Resource;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Group
extends Resource
implements Serializable {
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:Group";
    private static final long serialVersionUID = -2995603177584656028L;
    private final String displayName;
    private final Set<MemberRef> members;

    @JsonCreator
    private Group(@JsonProperty(value="id") String id, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas", required=true) Set<String> schemas, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="members") Set<MemberRef> members) {
        super(id, externalId, meta, schemas);
        this.displayName = displayName;
        this.members = members != null ? ImmutableSet.copyOf(members) : ImmutableSet.of();
    }

    Group(Builder builder) {
        this(builder.getId(), builder.getExternalId(), builder.getMeta(), builder.getSchemas(), builder.displayName, builder.members);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<MemberRef> getMembers() {
        return this.members;
    }

    public String toString() {
        return "Group [displayName=" + this.displayName + ", members=" + this.members + ", getId()=" + this.getId() + ", getExternalId()=" + this.getExternalId() + ", getMeta()=" + this.getMeta() + ", getSchemas()=" + this.getSchemas() + "]";
    }

    public static class Builder
    extends Resource.Builder {
        private String displayName;
        private Set<MemberRef> members = new HashSet<MemberRef>();

        @Deprecated
        public Builder(String displayName, Group group) {
            super(group);
            this.addSchema(Group.SCHEMA);
            if (group != null) {
                this.displayName = group.displayName;
                this.members.addAll(group.members);
            }
            if (!Strings.isNullOrEmpty((String)displayName)) {
                this.displayName = displayName;
            }
        }

        public Builder() {
            this(null, null);
        }

        public Builder(Group group) {
            this(null, group);
            if (group == null) {
                throw new SCIMDataValidationException("The given group can't be null.");
            }
        }

        public Builder(String displayName) {
            this(displayName, null);
            if (displayName == null) {
                throw new SCIMDataValidationException("The given resource can't be null");
            }
        }

        @Override
        @Deprecated
        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        @Override
        @Deprecated
        public Builder setMeta(Meta meta) {
            super.setMeta(meta);
            return this;
        }

        @Override
        public Builder setExternalId(String externalId) {
            super.setExternalId(externalId);
            return this;
        }

        @Override
        @Deprecated
        public Builder setSchemas(Set<String> schemas) {
            super.setSchemas(schemas);
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Deprecated
        public Builder setMembers(Set<MemberRef> members) {
            this.members = members;
            return this;
        }

        public Builder addMember(MemberRef member) {
            this.members.add(member);
            return this;
        }

        public Builder addMembers(Collection<MemberRef> members) {
            if (members != null) {
                for (MemberRef entry : members) {
                    this.addMember(entry);
                }
            }
            return this;
        }

        public Builder removeMember(MemberRef member) {
            this.members.remove(member);
            return this;
        }

        public Builder removeMembers() {
            this.members.clear();
            return this;
        }

        public Group build() {
            return new Group(this);
        }
    }
}

