/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.google.common.base.Strings;
import java.io.Serializable;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonIgnore;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonInclude;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Name
implements Serializable {
    private static final long serialVersionUID = -2090787512643160922L;
    private final String formatted;
    private final String familyName;
    private final String givenName;
    private final String middleName;
    private final String honorificPrefix;
    private final String honorificSuffix;

    @JsonCreator
    private Name(@JsonProperty(value="formatted") String formatted, @JsonProperty(value="familyName") String familyName, @JsonProperty(value="givenName") String givenName, @JsonProperty(value="middleName") String middleName, @JsonProperty(value="honorificPrefix") String honorificPrefix, @JsonProperty(value="honorificSuffix") String honorificSuffix) {
        this.formatted = formatted;
        this.familyName = familyName;
        this.givenName = givenName;
        this.middleName = middleName;
        this.honorificPrefix = honorificPrefix;
        this.honorificSuffix = honorificSuffix;
    }

    private Name(Builder builder) {
        this.formatted = builder.formatted;
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
        this.middleName = builder.middleName;
        this.honorificPrefix = builder.honorificPrefix;
        this.honorificSuffix = builder.honorificSuffix;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getHonorificPrefix() {
        return this.honorificPrefix;
    }

    public String getHonorificSuffix() {
        return this.honorificSuffix;
    }

    @JsonIgnore
    public boolean isEmpty() {
        if (!Strings.isNullOrEmpty((String)this.formatted)) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)this.familyName)) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)this.givenName)) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)this.middleName)) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)this.honorificPrefix)) {
            return false;
        }
        return Strings.isNullOrEmpty((String)this.honorificSuffix);
    }

    public String toString() {
        return "Name [formatted=" + this.formatted + ", familyName=" + this.familyName + ", givenName=" + this.givenName + ", middleName=" + this.middleName + ", honorificPrefix=" + this.honorificPrefix + ", honorificSuffix=" + this.honorificSuffix + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name other = (Name)o;
        if (this.familyName != null ? !this.familyName.equals(other.familyName) : other.familyName != null) {
            return false;
        }
        if (this.formatted != null ? !this.formatted.equals(other.formatted) : other.formatted != null) {
            return false;
        }
        if (this.givenName != null ? !this.givenName.equals(other.givenName) : other.givenName != null) {
            return false;
        }
        if (this.honorificPrefix != null ? !this.honorificPrefix.equals(other.honorificPrefix) : other.honorificPrefix != null) {
            return false;
        }
        if (this.honorificSuffix != null ? !this.honorificSuffix.equals(other.honorificSuffix) : other.honorificSuffix != null) {
            return false;
        }
        return !(this.middleName != null ? !this.middleName.equals(other.middleName) : other.middleName != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.familyName == null ? 0 : this.familyName.hashCode());
        result = 31 * result + (this.formatted == null ? 0 : this.formatted.hashCode());
        result = 31 * result + (this.givenName == null ? 0 : this.givenName.hashCode());
        result = 31 * result + (this.honorificPrefix == null ? 0 : this.honorificPrefix.hashCode());
        result = 31 * result + (this.honorificSuffix == null ? 0 : this.honorificSuffix.hashCode());
        result = 31 * result + (this.middleName == null ? 0 : this.middleName.hashCode());
        return result;
    }

    /* synthetic */ Name(Builder builder, Name name) {
        this(builder);
    }

    public static class Builder {
        private String formatted;
        private String familyName;
        private String givenName;
        private String middleName;
        private String honorificPrefix;
        private String honorificSuffix;

        public Builder() {
        }

        public Builder(Name name) {
            this.formatted = name.getFormatted();
            this.familyName = name.getFamilyName();
            this.givenName = name.getGivenName();
            this.middleName = name.getMiddleName();
            this.honorificPrefix = name.getHonorificPrefix();
            this.honorificSuffix = name.getHonorificSuffix();
        }

        public Builder setFormatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public Builder setFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder setGivenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder setMiddleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public Builder setHonorificPrefix(String honorificPrefix) {
            this.honorificPrefix = honorificPrefix;
            return this;
        }

        public Builder setHonorificSuffix(String honorificSuffix) {
            this.honorificSuffix = honorificSuffix;
            return this;
        }

        public Name build() {
            return new Name(this, null);
        }
    }
}

