/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.scim;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonCreator;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonIgnore;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonInclude;
import org.osiam.bundled.com.fasterxml.jackson.annotation.JsonProperty;
import org.osiam.resources.exception.SCIMDataValidationException;
import org.osiam.resources.scim.Address;
import org.osiam.resources.scim.Email;
import org.osiam.resources.scim.Entitlement;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.GroupRef;
import org.osiam.resources.scim.Im;
import org.osiam.resources.scim.Meta;
import org.osiam.resources.scim.Name;
import org.osiam.resources.scim.PhoneNumber;
import org.osiam.resources.scim.Photo;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.Role;
import org.osiam.resources.scim.X509Certificate;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class User
extends Resource
implements Serializable {
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:User";
    private static final long serialVersionUID = -4076516708797425414L;
    private final String userName;
    private final Name name;
    private final String displayName;
    private final String nickName;
    private final String profileUrl;
    private final String title;
    private final String userType;
    private final String preferredLanguage;
    private final String locale;
    private final String timezone;
    private final Boolean active;
    private final String password;
    private final List<Email> emails;
    private final List<PhoneNumber> phoneNumbers;
    private final List<Im> ims;
    private final List<Photo> photos;
    private final List<Address> addresses;
    private final List<GroupRef> groups;
    private final List<Entitlement> entitlements;
    private final List<Role> roles;
    private final List<X509Certificate> x509Certificates;
    private final Map<String, Extension> extensions;

    @JsonCreator
    private User(@JsonProperty(value="id") String id, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas", required=true) Set<String> schemas, @JsonProperty(value="userName") String userName, @JsonProperty(value="name") Name name, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="nickName") String nickName, @JsonProperty(value="profileUrl") String profileUrl, @JsonProperty(value="title") String title, @JsonProperty(value="userType") String userType, @JsonProperty(value="preferredLanguage") String preferredLanguage, @JsonProperty(value="locale") String locale, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="active") Boolean active, @JsonProperty(value="password") String password, @JsonProperty(value="emails") List<Email> emails, @JsonProperty(value="phoneNumbers") List<PhoneNumber> phoneNumbers, @JsonProperty(value="ims") List<Im> ims, @JsonProperty(value="photos") List<Photo> photos, @JsonProperty(value="addresses") List<Address> addresses, @JsonProperty(value="groups") List<GroupRef> groups, @JsonProperty(value="entitlements") List<Entitlement> entitlements, @JsonProperty(value="roles") List<Role> roles, @JsonProperty(value="x509Certificates") List<X509Certificate> x509Certificates, @JsonProperty(value="extensions") Map<String, Extension> extensions) {
        super(id, externalId, meta, schemas);
        this.userName = userName != null ? userName : "";
        this.name = name;
        this.displayName = displayName;
        this.nickName = nickName;
        this.profileUrl = profileUrl;
        this.title = title;
        this.userType = userType;
        this.preferredLanguage = preferredLanguage;
        this.locale = locale;
        this.timezone = timezone;
        this.active = active;
        this.password = password != null ? password : "";
        this.emails = emails != null ? ImmutableList.copyOf(emails) : ImmutableList.of();
        this.phoneNumbers = phoneNumbers != null ? ImmutableList.copyOf(phoneNumbers) : ImmutableList.of();
        this.ims = ims != null ? ImmutableList.copyOf(ims) : ImmutableList.of();
        this.photos = photos != null ? ImmutableList.copyOf(photos) : ImmutableList.of();
        this.addresses = addresses != null ? ImmutableList.copyOf(addresses) : ImmutableList.of();
        this.groups = groups != null ? ImmutableList.copyOf(groups) : ImmutableList.of();
        this.entitlements = entitlements != null ? ImmutableList.copyOf(entitlements) : ImmutableList.of();
        this.roles = roles != null ? ImmutableList.copyOf(roles) : ImmutableList.of();
        this.x509Certificates = x509Certificates != null ? ImmutableList.copyOf(x509Certificates) : ImmutableList.of();
        this.extensions = extensions != null ? ImmutableMap.copyOf(extensions) : ImmutableMap.of();
    }

    User(Builder builder) {
        this(builder.getId(), builder.getExternalId(), builder.getMeta(), builder.getSchemas(), builder.userName, builder.name, builder.displayName, builder.nickName, builder.profileUrl, builder.title, builder.userType, builder.preferredLanguage, builder.locale, builder.timezone, builder.active, builder.password, builder.emails, builder.phoneNumbers, builder.ims, builder.photos, builder.addresses, builder.groups, builder.entitlements, builder.roles, builder.x509Certificates, builder.extensions);
    }

    public String getUserName() {
        return this.userName;
    }

    public Name getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Boolean isActive() {
        return this.active;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    @JsonIgnore
    public Optional<Email> getPrimaryOrFirstEmail() {
        for (Email email : this.emails) {
            if (!email.isPrimary()) continue;
            return Optional.of((Object)email);
        }
        if (this.emails.size() > 0) {
            return Optional.of((Object)this.getEmails().get(0));
        }
        return Optional.absent();
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public List<Im> getIms() {
        return this.ims;
    }

    public List<Photo> getPhotos() {
        return this.photos;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public List<GroupRef> getGroups() {
        return this.groups;
    }

    public List<Entitlement> getEntitlements() {
        return this.entitlements;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public List<X509Certificate> getX509Certificates() {
        return this.x509Certificates;
    }

    @JsonAnyGetter
    public Map<String, Extension> getExtensions() {
        return this.extensions;
    }

    public Extension getExtension(String urn) {
        if (urn == null || urn.isEmpty()) {
            throw new IllegalArgumentException("urn must be neither null nor empty");
        }
        if (!this.extensions.containsKey(urn)) {
            throw new NoSuchElementException("extension " + urn + " is not available");
        }
        return this.extensions.get(urn);
    }

    public boolean isExtensionPresent(String urn) {
        return this.extensions.containsKey(urn);
    }

    public String toString() {
        return "User [userName=" + this.userName + ", name=" + this.name + ", displayName=" + this.displayName + ", nickName=" + this.nickName + ", profileUrl=" + this.profileUrl + ", title=" + this.title + ", userType=" + this.userType + ", preferredLanguage=" + this.preferredLanguage + ", locale=" + this.locale + ", timezone=" + this.timezone + ", active=" + this.active + ", password=" + this.password + ", emails=" + this.emails + ", phoneNumbers=" + this.phoneNumbers + ", ims=" + this.ims + ", photos=" + this.photos + ", addresses=" + this.addresses + ", groups=" + this.groups + ", entitlements=" + this.entitlements + ", roles=" + this.roles + ", x509Certificates=" + this.x509Certificates + ", extensions=" + this.extensions + ", getId()=" + this.getId() + ", getExternalId()=" + this.getExternalId() + ", getMeta()=" + this.getMeta() + ", getSchemas()=" + this.getSchemas() + "]";
    }

    public static class Builder
    extends Resource.Builder {
        private String userName;
        private String password = "";
        private Boolean active;
        private String timezone;
        private String locale;
        private String preferredLanguage;
        private String userType;
        private String title;
        private String profileUrl;
        private String nickName;
        private String displayName;
        private Name name;
        private List<Email> emails = new ArrayList<Email>();
        private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
        private List<Im> ims = new ArrayList<Im>();
        private List<Photo> photos = new ArrayList<Photo>();
        private List<Address> addresses = new ArrayList<Address>();
        private List<GroupRef> groups = new ArrayList<GroupRef>();
        private List<Entitlement> entitlements = new ArrayList<Entitlement>();
        private List<Role> roles = new ArrayList<Role>();
        private List<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        private Map<String, Extension> extensions = new HashMap<String, Extension>();

        @Deprecated
        public Builder(String userName, User user) {
            super(user);
            this.addSchema(User.SCHEMA);
            if (user != null) {
                this.userName = user.userName;
                this.name = user.name;
                this.displayName = user.displayName;
                this.nickName = user.nickName;
                this.profileUrl = user.profileUrl;
                this.title = user.title;
                this.userType = user.userType;
                this.preferredLanguage = user.preferredLanguage;
                this.locale = user.locale;
                this.timezone = user.timezone;
                this.active = user.active;
                this.password = user.password;
                this.emails.addAll(user.emails);
                this.phoneNumbers.addAll(user.phoneNumbers);
                this.ims.addAll(user.ims);
                this.photos.addAll(user.photos);
                this.addresses.addAll(user.addresses);
                this.groups.addAll(user.groups);
                this.entitlements.addAll(user.entitlements);
                this.roles.addAll(user.roles);
                this.x509Certificates.addAll(user.x509Certificates);
                this.extensions.putAll(user.extensions);
            }
            if (!Strings.isNullOrEmpty((String)userName)) {
                this.userName = userName;
            }
        }

        public Builder(String userName) {
            this(userName, null);
            if (Strings.isNullOrEmpty((String)userName)) {
                throw new IllegalArgumentException("userName must not be null or empty.");
            }
        }

        public Builder() {
            this(null, null);
        }

        public Builder(User user) {
            this(null, user);
            if (user == null) {
                throw new SCIMDataValidationException("The given user must not be null");
            }
        }

        public Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder setName(Name name) {
            this.name = name;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setNickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public Builder setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setUserType(String userType) {
            this.userType = userType;
            return this;
        }

        public Builder setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public Builder setLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder setTimezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder setActive(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder addEmails(Collection<Email> emails) {
            if (emails != null) {
                for (Email email : emails) {
                    this.addEmail(email);
                }
            }
            return this;
        }

        public Builder addEmail(Email email) {
            if (email != null) {
                this.emails.add(new Email.Builder(email).build());
            }
            return this;
        }

        public Builder removeEmails() {
            this.emails.clear();
            return this;
        }

        public Builder removeEmail(Email email) {
            this.emails.remove(email);
            return this;
        }

        public Builder addPhoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            if (phoneNumbers != null) {
                for (PhoneNumber phoneNumber : phoneNumbers) {
                    this.addPhoneNumber(phoneNumber);
                }
            }
            return this;
        }

        public Builder addPhoneNumber(PhoneNumber phoneNumber) {
            if (phoneNumber != null) {
                this.phoneNumbers.add(new PhoneNumber.Builder(phoneNumber).build());
            }
            return this;
        }

        public Builder removePhoneNumbers() {
            this.phoneNumbers.clear();
            return this;
        }

        public Builder removePhoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumbers.remove(phoneNumber);
            return this;
        }

        public Builder addIms(Collection<Im> ims) {
            if (ims != null) {
                for (Im im : ims) {
                    this.addIm(im);
                }
            }
            return this;
        }

        public Builder addIm(Im im) {
            if (im != null) {
                this.ims.add(new Im.Builder(im).build());
            }
            return this;
        }

        public Builder removeIms() {
            this.ims.clear();
            return this;
        }

        public Builder removeIm(Im im) {
            this.ims.remove(im);
            return this;
        }

        public Builder addPhotos(Collection<Photo> photos) {
            if (photos != null) {
                for (Photo photo : photos) {
                    this.addPhoto(photo);
                }
            }
            return this;
        }

        public Builder addPhoto(Photo photo) {
            if (photo != null) {
                this.photos.add(new Photo.Builder(photo).build());
            }
            return this;
        }

        public Builder removePhotos() {
            this.photos.clear();
            return this;
        }

        public Builder removePhoto(Photo photo) {
            this.photos.remove(photo);
            return this;
        }

        public Builder addAddresses(Collection<Address> addresses) {
            if (addresses != null) {
                for (Address address : addresses) {
                    this.addAddress(address);
                }
            }
            return this;
        }

        public Builder addAddress(Address address) {
            if (address != null) {
                this.addresses.add(new Address.Builder(address).build());
            }
            return this;
        }

        public Builder removeAddresses() {
            this.addresses.clear();
            return this;
        }

        public Builder removeAddress(Address address) {
            this.addresses.remove(address);
            return this;
        }

        @Deprecated
        public Builder setGroups(List<GroupRef> groups) {
            this.groups = groups;
            return this;
        }

        public Builder addEntitlements(Collection<Entitlement> entitlements) {
            if (entitlements != null) {
                for (Entitlement entitlement : entitlements) {
                    this.addEntitlement(entitlement);
                }
            }
            return this;
        }

        public Builder addEntitlement(Entitlement entitlement) {
            if (entitlement != null) {
                this.entitlements.add(new Entitlement.Builder(entitlement).build());
            }
            return this;
        }

        public Builder removeEntitlements() {
            this.entitlements.clear();
            return this;
        }

        public Builder removeEntitlement(Entitlement entitlement) {
            this.entitlements.remove(entitlement);
            return this;
        }

        public Builder addRoles(Collection<Role> roles) {
            if (roles != null) {
                for (Role role : roles) {
                    this.addRole(role);
                }
            }
            return this;
        }

        public Builder addRole(Role role) {
            if (role != null) {
                this.roles.add(new Role.Builder(role).build());
            }
            return this;
        }

        public Builder removeRoles() {
            this.roles.clear();
            return this;
        }

        public Builder removeRole(Role role) {
            this.roles.remove(role);
            return this;
        }

        public Builder addX509Certificates(Collection<X509Certificate> x509Certificates) {
            if (x509Certificates != null) {
                for (X509Certificate x509Certificate : x509Certificates) {
                    this.addX509Certificate(x509Certificate);
                }
            }
            return this;
        }

        public Builder addX509Certificate(X509Certificate x509Certificate) {
            if (x509Certificate != null) {
                this.x509Certificates.add(new X509Certificate.Builder(x509Certificate).build());
            }
            return this;
        }

        public Builder removeX509Certificates() {
            this.x509Certificates.clear();
            return this;
        }

        public Builder removeX509Certificate(X509Certificate x509Certificate) {
            this.x509Certificates.remove(x509Certificate);
            return this;
        }

        public Builder addExtensions(Collection<Extension> extensions) {
            if (extensions != null) {
                for (Extension entry : extensions) {
                    this.addExtension(entry);
                }
            }
            return this;
        }

        public Builder addExtension(Extension extension) {
            if (extension != null) {
                this.extensions.put(extension.getUrn(), extension);
                this.addSchema(extension.getUrn());
            }
            return this;
        }

        public Builder removeExtensions() {
            this.extensions.clear();
            return this;
        }

        public Builder removeExtension(String urn) {
            this.extensions.remove(urn);
            return this;
        }

        @Override
        @Deprecated
        public Builder setMeta(Meta meta) {
            super.setMeta(meta);
            return this;
        }

        @Override
        public Builder setExternalId(String externalId) {
            super.setExternalId(externalId);
            return this;
        }

        @Override
        @Deprecated
        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        @Override
        @Deprecated
        public Builder setSchemas(Set<String> schemas) {
            super.setSchemas(schemas);
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

