/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.graphics.drawable.Drawable;
import java.util.HashSet;
import java.util.Set;
import org.osmdroid.library.R;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.infowindow.BasicInfoWindow;
import org.osmdroid.views.overlay.infowindow.InfoWindow;
import org.osmdroid.views.overlay.infowindow.MarkerInfoWindow;

public class MapViewRepository {
    private MapView mMapView;
    private MarkerInfoWindow mDefaultMarkerInfoWindow;
    private BasicInfoWindow mDefaultPolylineInfoWindow;
    private BasicInfoWindow mDefaultPolygonInfoWindow;
    private Drawable mDefaultMarkerIcon;
    private final Set<InfoWindow> mInfoWindowList = new HashSet<InfoWindow>();

    public MapViewRepository(MapView pMapView) {
        this.mMapView = pMapView;
    }

    public void add(InfoWindow pInfoWindow) {
        this.mInfoWindowList.add(pInfoWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDetach() {
        Set<InfoWindow> set = this.mInfoWindowList;
        synchronized (set) {
            for (InfoWindow infoWindow : this.mInfoWindowList) {
                infoWindow.onDetach();
            }
            this.mInfoWindowList.clear();
        }
        this.mMapView = null;
        this.mDefaultMarkerInfoWindow = null;
        this.mDefaultPolylineInfoWindow = null;
        this.mDefaultPolygonInfoWindow = null;
        this.mDefaultMarkerIcon = null;
    }

    public MarkerInfoWindow getDefaultMarkerInfoWindow() {
        if (this.mDefaultMarkerInfoWindow == null) {
            this.mDefaultMarkerInfoWindow = new MarkerInfoWindow(R.layout.bonuspack_bubble, this.mMapView);
        }
        return this.mDefaultMarkerInfoWindow;
    }

    public BasicInfoWindow getDefaultPolylineInfoWindow() {
        if (this.mDefaultPolylineInfoWindow == null) {
            this.mDefaultPolylineInfoWindow = new BasicInfoWindow(R.layout.bonuspack_bubble, this.mMapView);
        }
        return this.mDefaultPolylineInfoWindow;
    }

    public BasicInfoWindow getDefaultPolygonInfoWindow() {
        if (this.mDefaultPolygonInfoWindow == null) {
            this.mDefaultPolygonInfoWindow = new BasicInfoWindow(R.layout.bonuspack_bubble, this.mMapView);
        }
        return this.mDefaultPolygonInfoWindow;
    }

    public Drawable getDefaultMarkerIcon() {
        if (this.mDefaultMarkerIcon == null) {
            this.mDefaultMarkerIcon = this.mMapView.getContext().getResources().getDrawable(R.drawable.marker_default);
        }
        return this.mDefaultMarkerIcon;
    }
}

