/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.TileSystem;

public class TileSystemWebMercator
extends TileSystem {
    private static final double MinLatitude = -85.05112877980658;
    private static final double MaxLatitude = 85.05112877980658;
    private static final double MinLongitude = -180.0;
    private static final double MaxLongitude = 180.0;

    @Override
    public double getX01FromLongitude(double pLongitude) {
        return (pLongitude - this.getMinLongitude()) / (this.getMaxLongitude() - this.getMinLongitude());
    }

    @Override
    public double getY01FromLatitude(double pLatitude) {
        double sinus = Math.sin(pLatitude * Math.PI / 180.0);
        return 0.5 - Math.log((1.0 + sinus) / (1.0 - sinus)) / (Math.PI * 4);
    }

    @Override
    public double getLongitudeFromX01(double pX01) {
        return this.getMinLongitude() + (this.getMaxLongitude() - this.getMinLongitude()) * pX01;
    }

    @Override
    public double getLatitudeFromY01(double pY01) {
        return 90.0 - 360.0 * Math.atan(Math.exp((pY01 - 0.5) * 2.0 * Math.PI)) / Math.PI;
    }

    @Override
    public double getMinLatitude() {
        return -85.05112877980658;
    }

    @Override
    public double getMaxLatitude() {
        return 85.05112877980658;
    }

    @Override
    public double getMinLongitude() {
        return -180.0;
    }

    @Override
    public double getMaxLongitude() {
        return 180.0;
    }
}

