/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.Distance;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.IntegerAccepter;
import org.osmdroid.util.LineBuilder;
import org.osmdroid.util.ListPointAccepter;
import org.osmdroid.util.ListPointL;
import org.osmdroid.util.PathBuilder;
import org.osmdroid.util.PointAccepter;
import org.osmdroid.util.PointL;
import org.osmdroid.util.SegmentClipper;
import org.osmdroid.util.SideOptimizationPointAccepter;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.LineDrawer;

public class LinearRing {
    private final ArrayList<GeoPoint> mOriginalPoints = new ArrayList();
    private double[] mDistances;
    private long[] mProjectedPoints;
    private final PointL mProjectedCenter = new PointL();
    private final SegmentClipper mSegmentClipper = new SegmentClipper();
    private final Path mPath;
    private final BoundingBox mBoundingBox = new BoundingBox();
    private boolean mProjectedPrecomputed;
    private boolean mDistancesPrecomputed;
    private boolean isHorizontalRepeating = true;
    private boolean isVerticalRepeating = true;
    private final ListPointL mPointsForMilestones = new ListPointL();
    private final PointAccepter mPointAccepter;
    private final IntegerAccepter mIntegerAccepter;
    private boolean mGeodesic = false;
    private final boolean mClosed;
    private float[] mDowngradePointList;
    private int mDowngradePixelSize;
    private long mProjectedWidth;
    private long mProjectedHeight;

    public LinearRing(Path pPath) {
        this(pPath, true);
    }

    public LinearRing(LineBuilder pLineBuilder, boolean pClosePath) {
        this.mPath = null;
        this.mPointAccepter = pLineBuilder;
        if (pLineBuilder instanceof LineDrawer) {
            this.mIntegerAccepter = new IntegerAccepter(pLineBuilder.getLines().length / 2);
            ((LineDrawer)pLineBuilder).setIntegerAccepter(this.mIntegerAccepter);
        } else {
            this.mIntegerAccepter = null;
        }
        this.mClosed = pClosePath;
    }

    public LinearRing(LineBuilder pLineBuilder) {
        this(pLineBuilder, false);
    }

    public LinearRing(Path pPath, boolean pClosed) {
        this.mPath = pPath;
        this.mPointAccepter = new SideOptimizationPointAccepter(new PathBuilder(pPath));
        this.mIntegerAccepter = null;
        this.mClosed = pClosed;
    }

    void clearPath() {
        this.mOriginalPoints.clear();
        this.mProjectedPoints = null;
        this.mDistances = null;
        this.resetPrecomputations();
        this.mPointAccepter.init();
    }

    protected void addGreatCircle(GeoPoint startPoint, GeoPoint endPoint, int numberOfPoints) {
        double lat1 = startPoint.getLatitude() * (Math.PI / 180);
        double lon1 = startPoint.getLongitude() * (Math.PI / 180);
        double lat2 = endPoint.getLatitude() * (Math.PI / 180);
        double lon2 = endPoint.getLongitude() * (Math.PI / 180);
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        for (int i = 1; i <= numberOfPoints; ++i) {
            double f = 1.0 * (double)i / (double)(numberOfPoints + 1);
            double A = Math.sin((1.0 - f) * d) / Math.sin(d);
            double B = Math.sin(f * d) / Math.sin(d);
            double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
            double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
            double z = A * Math.sin(lat1) + B * Math.sin(lat2);
            double latN = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
            double lonN = Math.atan2(y, x);
            GeoPoint p = new GeoPoint(latN * 57.29577951308232, lonN * 57.29577951308232);
            this.mOriginalPoints.add(p);
        }
    }

    public void addPoint(GeoPoint p) {
        if (this.mGeodesic && this.mOriginalPoints.size() > 0) {
            GeoPoint prev = this.mOriginalPoints.get(this.mOriginalPoints.size() - 1);
            int greatCircleLength = (int)prev.distanceToAsDouble(p);
            int numberOfPoints = greatCircleLength / 100000;
            this.addGreatCircle(prev, p, numberOfPoints);
        }
        this.mOriginalPoints.add(p);
        this.resetPrecomputations();
    }

    private void resetPrecomputations() {
        this.mProjectedPrecomputed = false;
        this.mDistancesPrecomputed = false;
        this.mDowngradePixelSize = 0;
        this.mDowngradePointList = null;
    }

    public void setPoints(List<GeoPoint> points) {
        this.clearPath();
        for (GeoPoint p : points) {
            this.addPoint(p);
        }
    }

    public ArrayList<GeoPoint> getPoints() {
        return this.mOriginalPoints;
    }

    double[] getDistances() {
        this.computeDistances();
        return this.mDistances;
    }

    public double getDistance() {
        double result = 0.0;
        for (double distance : this.getDistances()) {
            result += distance;
        }
        return result;
    }

    public void setGeodesic(boolean geodesic) {
        this.mGeodesic = geodesic;
    }

    public boolean isGeodesic() {
        return this.mGeodesic;
    }

    PointL buildPathPortion(Projection pProjection, PointL pOffset, boolean pStorePoints) {
        PointL offset;
        int size = this.mOriginalPoints.size();
        if (size < 2) {
            return pOffset;
        }
        this.computeProjected();
        this.computeDistances();
        if (pOffset != null) {
            offset = pOffset;
        } else {
            offset = new PointL();
            this.getBestOffset(pProjection, offset);
        }
        this.mSegmentClipper.init();
        this.clipAndStore(pProjection, offset, this.mClosed, pStorePoints, this.mSegmentClipper);
        this.mSegmentClipper.end();
        if (this.mClosed) {
            this.mPath.close();
        }
        return offset;
    }

    void buildLinePortion(Projection pProjection, boolean pStorePoints) {
        int size = this.mOriginalPoints.size();
        if (size < 2) {
            return;
        }
        this.computeProjected();
        this.computeDistances();
        PointL offset = new PointL();
        this.getBestOffset(pProjection, offset);
        this.mSegmentClipper.init();
        this.clipAndStore(pProjection, offset, this.mClosed, pStorePoints, this.mSegmentClipper);
        this.mSegmentClipper.end();
    }

    public ListPointL getPointsForMilestones() {
        return this.mPointsForMilestones;
    }

    private void getBestOffset(Projection pProjection, PointL pOffset) {
        double powerDifference = pProjection.getProjectedPowerDifference();
        PointL center = pProjection.getLongPixelsFromProjected(this.mProjectedCenter, powerDifference, false, null);
        this.getBestOffset(pProjection, pOffset, center);
    }

    public void getBestOffset(Projection pProjection, PointL pOffset, PointL pPixel) {
        Rect screenRect = pProjection.getIntrinsicScreenRect();
        double screenCenterX = (double)(screenRect.left + screenRect.right) / 2.0;
        double screenCenterY = (double)(screenRect.top + screenRect.bottom) / 2.0;
        double worldSize = pProjection.getWorldMapSize();
        this.getBestOffset((double)pPixel.x, (double)pPixel.y, screenCenterX, screenCenterY, worldSize, pOffset);
    }

    private void getBestOffset(double pPolyCenterX, double pPolyCenterY, double pScreenCenterX, double pScreenCenterY, double pWorldSize, PointL pOffset) {
        int deltaNegative;
        int deltaPositive;
        long worldSize = Math.round(pWorldSize);
        if (!this.isVerticalRepeating) {
            deltaPositive = 0;
            deltaNegative = 0;
        } else {
            deltaPositive = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, 0L, worldSize);
            deltaNegative = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, 0L, -worldSize);
        }
        pOffset.y = worldSize * (long)(deltaPositive > deltaNegative ? deltaPositive : -deltaNegative);
        if (!this.isHorizontalRepeating) {
            deltaPositive = 0;
            deltaNegative = 0;
        } else {
            deltaPositive = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, worldSize, 0L);
            deltaNegative = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, -worldSize, 0L);
        }
        pOffset.x = worldSize * (long)(deltaPositive > deltaNegative ? deltaPositive : -deltaNegative);
    }

    private int getBestOffset(double pPolyCenterX, double pPolyCenterY, double pScreenCenterX, double pScreenCenterY, long pDeltaX, long pDeltaY) {
        double squaredDistance = 0.0;
        int i = 0;
        while (true) {
            double tmpSquaredDistance = Distance.getSquaredDistanceToPoint(pPolyCenterX + (double)((long)i * pDeltaX), pPolyCenterY + (double)((long)i * pDeltaY), pScreenCenterX, pScreenCenterY);
            if (i != 0 && !(squaredDistance > tmpSquaredDistance)) break;
            squaredDistance = tmpSquaredDistance;
            ++i;
        }
        return i - 1;
    }

    private void clipAndStore(Projection pProjection, PointL pOffset, boolean pClosePath, boolean pStorePoints, SegmentClipper pSegmentClipper) {
        this.mPointsForMilestones.clear();
        double powerDifference = pProjection.getProjectedPowerDifference();
        PointL projected = new PointL();
        PointL point = new PointL();
        PointL first = new PointL();
        for (int i = 0; i < this.mProjectedPoints.length; i += 2) {
            projected.set(this.mProjectedPoints[i], this.mProjectedPoints[i + 1]);
            pProjection.getLongPixelsFromProjected(projected, powerDifference, false, point);
            long x = point.x + pOffset.x;
            long y = point.y + pOffset.y;
            if (pStorePoints) {
                this.mPointsForMilestones.add(x, y);
            }
            if (pSegmentClipper != null) {
                pSegmentClipper.add(x, y);
            }
            if (i != 0) continue;
            first.set(x, y);
        }
        if (pClosePath) {
            if (pSegmentClipper != null) {
                pSegmentClipper.add(first.x, first.y);
            }
            if (pStorePoints) {
                this.mPointsForMilestones.add(first.x, first.y);
            }
        }
    }

    public static double getCloserValue(double pPrevious, double pNext, double pWorldSize) {
        while (Math.abs(pNext - pWorldSize - pPrevious) < Math.abs(pNext - pPrevious)) {
            pNext -= pWorldSize;
        }
        while (Math.abs(pNext + pWorldSize - pPrevious) < Math.abs(pNext - pPrevious)) {
            pNext += pWorldSize;
        }
        return pNext;
    }

    private void setCloserPoint(PointL pPrevious, PointL pNext, double pWorldSize) {
        if (this.isHorizontalRepeating) {
            pNext.x = Math.round(LinearRing.getCloserValue(pPrevious.x, pNext.x, pWorldSize));
        }
        if (this.isVerticalRepeating) {
            pNext.y = Math.round(LinearRing.getCloserValue(pPrevious.y, pNext.y, pWorldSize));
        }
    }

    boolean isCloseTo(GeoPoint pPoint, double tolerance, Projection pProjection, boolean pClosePath) {
        return this.getCloseTo(pPoint, tolerance, pProjection, pClosePath) != null;
    }

    GeoPoint getCloseTo(GeoPoint pPoint, double tolerance, Projection pProjection, boolean pClosePath) {
        this.computeProjected();
        Point pixel = pProjection.toPixels(pPoint, null);
        PointL offset = new PointL();
        this.getBestOffset(pProjection, offset);
        this.clipAndStore(pProjection, offset, pClosePath, true, null);
        double mapSize = pProjection.getWorldMapSize();
        Rect screenRect = pProjection.getIntrinsicScreenRect();
        int screenWidth = screenRect.width();
        int screenHeight = screenRect.height();
        double startX = pixel.x;
        while (startX - mapSize >= 0.0) {
            startX -= mapSize;
        }
        double startY = pixel.y;
        while (startY - mapSize >= 0.0) {
            startY -= mapSize;
        }
        double squaredTolerance = tolerance * tolerance;
        PointL point0 = new PointL();
        PointL point1 = new PointL();
        boolean first = true;
        int index = 0;
        for (PointL point : this.mPointsForMilestones) {
            point1.set(point);
            if (first) {
                first = false;
            } else {
                for (double x = startX; x < (double)screenWidth; x += mapSize) {
                    for (double y = startY; y < (double)screenHeight; y += mapSize) {
                        double projectionFactor = Distance.getProjectionFactorToSegment(x, y, point0.x, point0.y, point1.x, point1.y);
                        double squaredDistance = Distance.getSquaredDistanceToProjection(x, y, point0.x, point0.y, point1.x, point1.y, projectionFactor);
                        if (!(squaredTolerance > squaredDistance)) continue;
                        long pointAX = this.mProjectedPoints[2 * (index - 1)];
                        long pointAY = this.mProjectedPoints[2 * (index - 1) + 1];
                        long pointBX = this.mProjectedPoints[2 * index];
                        long pointBY = this.mProjectedPoints[2 * index + 1];
                        long projectionX = (long)((double)pointAX + (double)(pointBX - pointAX) * projectionFactor);
                        long projectionY = (long)((double)pointAY + (double)(pointBY - pointAY) * projectionFactor);
                        return MapView.getTileSystem().getGeoFromMercator(projectionX, projectionY, 1.152921504606847E18, null, false, false);
                    }
                }
            }
            point0.set(point1);
            ++index;
        }
        return null;
    }

    public void setClipArea(long pXMin, long pYMin, long pXMax, long pYMax) {
        this.mSegmentClipper.set(pXMin, pYMin, pXMax, pYMax, this.mPointAccepter, this.mIntegerAccepter, this.mPath != null);
    }

    public void setClipArea(Projection pProjection) {
        double border = 0.1;
        Rect rect = pProjection.getIntrinsicScreenRect();
        int halfWidth = rect.width() / 2;
        int halfHeight = rect.height() / 2;
        double radius = Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        double doubleRadius = 2.0 * radius;
        int scaledRadius = (int)(doubleRadius * 1.1);
        this.setClipArea(halfWidth - scaledRadius, halfHeight - scaledRadius, halfWidth + scaledRadius, halfHeight + scaledRadius);
        this.isHorizontalRepeating = pProjection.isHorizontalWrapEnabled();
        this.isVerticalRepeating = pProjection.isVerticalWrapEnabled();
    }

    public GeoPoint getCenter(GeoPoint pReuse) {
        GeoPoint out = pReuse != null ? pReuse : new GeoPoint(0.0, 0.0);
        BoundingBox boundingBox = this.getBoundingBox();
        out.setLatitude(boundingBox.getCenterLatitude());
        out.setLongitude(boundingBox.getCenterLongitude());
        return out;
    }

    private void computeProjected() {
        if (this.mProjectedPrecomputed) {
            return;
        }
        this.mProjectedPrecomputed = true;
        if (this.mProjectedPoints == null || this.mProjectedPoints.length != this.mOriginalPoints.size() * 2) {
            this.mProjectedPoints = new long[this.mOriginalPoints.size() * 2];
        }
        long minX = 0L;
        long maxX = 0L;
        long minY = 0L;
        long maxY = 0L;
        double north = 0.0;
        double east = 0.0;
        double south = 0.0;
        double west = 0.0;
        int index = 0;
        PointL previous = new PointL();
        PointL current = new PointL();
        TileSystem tileSystem = MapView.getTileSystem();
        double projectedMapSize = 1.152921504606847E18;
        for (GeoPoint currentGeo : this.mOriginalPoints) {
            double latitude = currentGeo.getLatitude();
            double longitude = currentGeo.getLongitude();
            tileSystem.getMercatorFromGeo(latitude, longitude, 1.152921504606847E18, current, false);
            if (index == 0) {
                minX = maxX = current.x;
                minY = maxY = current.y;
                north = south = latitude;
                east = west = longitude;
            } else {
                this.setCloserPoint(previous, current, 1.152921504606847E18);
                if (minX > current.x) {
                    minX = current.x;
                    west = longitude;
                }
                if (maxX < current.x) {
                    maxX = current.x;
                    east = longitude;
                }
                if (minY > current.y) {
                    minY = current.y;
                    north = latitude;
                }
                if (maxY < current.y) {
                    maxY = current.y;
                    south = latitude;
                }
            }
            this.mProjectedPoints[2 * index] = current.x;
            this.mProjectedPoints[2 * index + 1] = current.y;
            previous.set(current.x, current.y);
            ++index;
        }
        this.mProjectedWidth = maxX - minX;
        this.mProjectedHeight = maxY - minY;
        this.mProjectedCenter.set((minX + maxX) / 2L, (minY + maxY) / 2L);
        this.mBoundingBox.set(north, east, south, west);
    }

    private void computeDistances() {
        if (this.mDistancesPrecomputed) {
            return;
        }
        this.mDistancesPrecomputed = true;
        if (this.mDistances == null || this.mDistances.length != this.mOriginalPoints.size()) {
            this.mDistances = new double[this.mOriginalPoints.size()];
        }
        int index = 0;
        GeoPoint previousGeo = new GeoPoint(0.0, 0.0);
        for (GeoPoint currentGeo : this.mOriginalPoints) {
            this.mDistances[index] = index == 0 ? 0.0 : currentGeo.distanceToAsDouble(previousGeo);
            previousGeo.setCoords(currentGeo.getLatitude(), currentGeo.getLongitude());
            ++index;
        }
    }

    public BoundingBox getBoundingBox() {
        if (!this.mProjectedPrecomputed) {
            this.computeProjected();
        }
        return this.mBoundingBox;
    }

    public void clear() {
        this.mOriginalPoints.clear();
        if (this.mPath != null) {
            this.mPath.reset();
        }
        this.mPointsForMilestones.clear();
    }

    float[] computeDowngradePointList(int pSize) {
        long projectedSize;
        if (pSize == 0) {
            return null;
        }
        if (this.mDowngradePixelSize == pSize) {
            return this.mDowngradePointList;
        }
        this.computeProjected();
        long l = projectedSize = this.mProjectedWidth > this.mProjectedHeight ? this.mProjectedWidth : this.mProjectedHeight;
        if (projectedSize == 0L) {
            return null;
        }
        ListPointAccepter listPointAccepter = new ListPointAccepter(true);
        SideOptimizationPointAccepter pointAccepter = new SideOptimizationPointAccepter(listPointAccepter);
        double factor = (double)projectedSize * 1.0 / (double)pSize;
        int i = 0;
        while (i < this.mProjectedPoints.length) {
            long x = this.mProjectedPoints[i++];
            long y = this.mProjectedPoints[i++];
            long squareX = Math.round((double)(x - this.mProjectedCenter.x) / factor);
            long squareY = Math.round((double)(y - this.mProjectedCenter.y) / factor);
            pointAccepter.add(squareX, squareY);
        }
        this.mDowngradePixelSize = pSize;
        this.mDowngradePointList = new float[listPointAccepter.getList().size()];
        for (i = 0; i < this.mDowngradePointList.length; ++i) {
            this.mDowngradePointList[i] = listPointAccepter.getList().get(i).longValue();
        }
        return this.mDowngradePointList;
    }
}

